/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.query.QueryByExample;
import test.ojb.broker.Article;
import test.ojb.broker.ProductGroup;
import test.ojb.broker.ProductGroupProxy;
import test.ojb.broker.ProductGroupWithArray;
import test.ojb.broker.ProductGroupWithTypedCollection;

public class TypedCollectionsTest
extends TestCase {
    PersistenceBroker broker;
    private static Class CLASS = class$test$ojb$broker$TypedCollectionsTest == null ? (class$test$ojb$broker$TypedCollectionsTest = TypedCollectionsTest.class$("test.ojb.broker.TypedCollectionsTest")) : class$test$ojb$broker$TypedCollectionsTest;
    private int testId = 88884;
    static /* synthetic */ Class class$test$ojb$broker$TypedCollectionsTest;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public TypedCollectionsTest(String name) {
        super(name);
    }

    protected Article createArticle(int id) {
        Article a = new Article();
        a.setArticleId(id);
        a.setArticleName("New Funny Article " + id);
        a.setIsSelloutArticle(true);
        a.setMinimumStock(100);
        a.setOrderedUnits(17);
        a.setPrice(0.45);
        a.setProductGroupId(1);
        a.setStock(234);
        a.setSupplierId(4);
        a.setUnit("bottle");
        ProductGroup tmpPG = new ProductGroup();
        tmpPG.setId(1);
        Identity pgID = new Identity(tmpPG);
        ProductGroupProxy pgProxy = new ProductGroupProxy(pgID);
        a.setProductGroup(pgProxy);
        return a;
    }

    public void setUp() {
        this.broker = PersistenceBrokerFactory.createPersistenceBroker();
    }

    public void tearDown() {
        try {
            this.broker.clearCache();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
    }

    public void testArray() {
        try {
            int i = 1;
            while (i < 4) {
                ProductGroupWithArray example = new ProductGroupWithArray();
                example.setId(i);
                ProductGroupWithArray group = (ProductGroupWithArray)this.broker.getObjectByQuery(new QueryByExample(example));
                Assert.assertEquals((String)"should be equal", (int)i, (int)group.getId());
                this.broker.delete(group);
                this.broker.store(group);
                ++i;
            }
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testTypedCollection() {
        try {
            int i = 1;
            while (i < 4) {
                ProductGroupWithTypedCollection example = new ProductGroupWithTypedCollection();
                example.setId(i);
                ProductGroupWithTypedCollection group = (ProductGroupWithTypedCollection)this.broker.getObjectByQuery(new QueryByExample(example));
                Assert.assertEquals((String)"should be equal", (int)i, (int)group.getId());
                this.broker.delete(group);
                this.broker.store(group);
                ++i;
            }
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

