/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.singlevm.PersistenceBrokerImpl;

public class MetaDataSerializationTest
extends TestCase {
    private static Class CLASS = class$test$ojb$broker$MetaDataSerializationTest == null ? (class$test$ojb$broker$MetaDataSerializationTest = MetaDataSerializationTest.class$("test.ojb.broker.MetaDataSerializationTest")) : class$test$ojb$broker$MetaDataSerializationTest;
    private String repositoryFileName = PersistenceBrokerFactory.getConfiguration().getRepositoryFilename();
    static /* synthetic */ Class class$test$ojb$broker$MetaDataSerializationTest;

    public MetaDataSerializationTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testIt() {
        try {
            DescriptorRepository repository = DescriptorRepository.getInstance(PersistenceBrokerFactory.getConfiguration().getRepositoryFilename());
            Iterator iter = repository.iterator();
            while (iter.hasNext()) {
                ClassDescriptor cld = (ClassDescriptor)iter.next();
                byte[] arr = this.serialize(cld);
                ClassDescriptor cld1 = this.deserialize(arr);
            }
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testToDisk() {
        try {
            DescriptorRepository repository = DescriptorRepository.getInstance(PersistenceBrokerFactory.getConfiguration().getRepositoryFilename());
            Iterator iter = repository.iterator();
            Vector vec = new Vector();
            while (iter.hasNext()) {
                vec.add(iter.next());
            }
            File outfile = new File(this.repositoryFileName + ".serialized");
            FileOutputStream fos = new FileOutputStream(outfile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(vec);
            oos.close();
            fos.close();
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testFromDisk() {
        try {
            File infile = new File(this.repositoryFileName + ".serialized");
            FileInputStream fis = new FileInputStream(infile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            Vector vec = (Vector)ois.readObject();
            ois.close();
            fis.close();
            Iterator iter = ((AbstractList)vec).iterator();
            while (iter.hasNext()) {
                ClassDescriptor cld = (ClassDescriptor)iter.next();
            }
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testRemote() {
        ClassDescriptor cld = null;
        try {
            PersistenceBroker broker = PersistenceBrokerFactory.createPersistenceBroker();
            if (broker instanceof PersistenceBrokerImpl) {
                System.out.println("The Remote Metadata test can only be run in C/S mode");
                return;
            }
            int i = 0;
            while (i < 5) {
                DescriptorRepository repository = DescriptorRepository.getInstance(PersistenceBrokerFactory.getConfiguration().getRepositoryFilename());
                Iterator iter = repository.iterator();
                while (iter.hasNext()) {
                    cld = (ClassDescriptor)iter.next();
                    ClassDescriptor cldRemote = broker.getClassDescriptor(cld.getClassOfObject());
                }
                ++i;
            }
        }
        catch (Throwable t) {
            System.out.println(cld.getClassOfObject().getName());
            System.out.println(t.getMessage());
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    public void testIdentityStuff() {
        try {
            PersistenceBroker broker = PersistenceBrokerFactory.createPersistenceBroker();
            if (broker instanceof PersistenceBrokerImpl) {
                System.out.println("The Remote Identity test can only be run in C/S mode");
                return;
            }
            DescriptorRepository repository = DescriptorRepository.getInstance(PersistenceBrokerFactory.getConfiguration().getRepositoryFilename());
            Iterator iter = repository.iterator();
            while (iter.hasNext()) {
                ClassDescriptor cld = (ClassDescriptor)iter.next();
                Class c = cld.getClassOfObject();
                if (c.isInterface()) continue;
                Object o = null;
                try {
                    o = c.newInstance();
                    Identity oid = new Identity(o);
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    byte[] serialize(ClassDescriptor cld) throws Exception {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bao);
        oos.writeObject(cld);
        oos.close();
        bao.close();
        byte[] result = bao.toByteArray();
        return result;
    }

    ClassDescriptor deserialize(byte[] arr) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(arr);
        ObjectInputStream ois = new ObjectInputStream(bais);
        ClassDescriptor result = (ClassDescriptor)ois.readObject();
        ois.close();
        bais.close();
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

