/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.ObjectReferenceDescriptor;
import test.ojb.broker.Article;
import test.ojb.broker.InterfaceArticle;
import test.ojb.broker.InterfaceProductGroup;
import test.ojb.broker.ProductGroup;

public class AutomaticForeignKeys
extends TestCase {
    PersistenceBroker broker;
    private static Class CLASS = class$test$ojb$broker$AutomaticForeignKeys == null ? (class$test$ojb$broker$AutomaticForeignKeys = AutomaticForeignKeys.class$("test.ojb.broker.AutomaticForeignKeys")) : class$test$ojb$broker$AutomaticForeignKeys;
    static /* synthetic */ Class class$test$ojb$broker$AutomaticForeignKeys;
    static /* synthetic */ Class class$test$ojb$broker$Article;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public AutomaticForeignKeys(String name) {
        super(name);
    }

    public void setUp() {
        this.broker = PersistenceBrokerFactory.createPersistenceBroker();
        ClassDescriptor cld = this.broker.getClassDescriptor(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = AutomaticForeignKeys.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article);
        ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)cld.getObjectReferenceDescriptors().get(0);
        ord.setCascadeStore(true);
    }

    public void tearDown() {
        try {
            this.broker.clearCache();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
    }

    public void testOneOneReference() {
        try {
            Article art = new Article();
            art.setArticleName("OJB O/R mapping power");
            ProductGroup pg = new ProductGroup();
            pg.setName("Software");
            art.setProductGroup(pg);
            Identity artOID = new Identity(art);
            Identity pgOID = new Identity(pg);
            this.broker.beginTransaction();
            this.broker.store(art);
            this.broker.store(pg);
            this.broker.commitTransaction();
            this.broker.clearCache();
            Article readInArt = (Article)this.broker.getObjectByIdentity(artOID);
            InterfaceProductGroup readInPg = readInArt.getProductGroup();
            Assert.assertEquals((Object)art.getArticleName(), (Object)readInArt.getArticleName());
            Assert.assertEquals((Object)pg.getName(), (Object)readInPg.getName());
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    public void testOneManyReference() {
        try {
            Article art1 = new Article();
            art1.setArticleName("TOPLink");
            Article art2 = new Article();
            art2.setArticleName("OJB");
            Article art3 = new Article();
            art3.setArticleName("CASTOR");
            ProductGroup pg = new ProductGroup();
            pg.setName("O/R mapping tools");
            pg.add(art1);
            pg.add(art2);
            pg.add(art3);
            Identity a1OID = new Identity(art1);
            Identity a2OID = new Identity(art2);
            Identity a3OID = new Identity(art3);
            Identity pgOID = new Identity(pg);
            this.broker.store(pg);
            this.broker.clearCache();
            InterfaceProductGroup readInPG = (InterfaceProductGroup)this.broker.getObjectByIdentity(pgOID);
            Assert.assertEquals((Object)pg.getName(), (Object)readInPG.getName());
            Assert.assertEquals((int)pg.getAllArticles().size(), (int)readInPG.getAllArticles().size());
            InterfaceArticle art1a = (InterfaceArticle)pg.getAllArticles().get(0);
            InterfaceArticle art2a = (InterfaceArticle)pg.getAllArticles().get(1);
            InterfaceArticle art3a = (InterfaceArticle)pg.getAllArticles().get(2);
            Assert.assertEquals((Object)art1.getArticleName(), (Object)art1a.getArticleName());
            Assert.assertEquals((Object)art2.getArticleName(), (Object)art2a.getArticleName());
            Assert.assertEquals((Object)art3.getArticleName(), (Object)art3a.getArticleName());
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

