/*
 * Decompiled with CFR 0.152.
 */
package ojb.soda;

import java.util.Iterator;
import java.util.Vector;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.accesslayer.RsIterator;
import ojb.broker.query.Query;
import ojb.broker.server.RsIteratorStub;
import org.odbms.ObjectSet;

public class ObjectSetImpl
implements ObjectSet {
    protected Iterator ojbIterator;
    protected PersistenceBroker ojbBroker = PersistenceBrokerFactory.createPersistenceBroker();
    protected int length;
    protected Vector elements;
    protected int position = 0;
    protected int scrolled = 0;
    protected boolean resultSetClosed;

    public ObjectSetImpl(Query query, int limit) {
        this.length = this.ojbBroker.getCount(query);
        if (limit >= 0) {
            this.length = Math.min(this.length, limit);
        }
        this.elements = new Vector(this.length);
        this.ojbIterator = this.ojbBroker.getIteratorByQuery(query);
        this.setResultSetClosed(false);
    }

    public synchronized boolean hasNext() {
        if (this.position < this.length) {
            if (this.position < this.scrolled) {
                return true;
            }
            boolean result = this.ojbIterator.hasNext();
            return result;
        }
        this.releaseJdbcResources();
        return false;
    }

    protected void releaseJdbcResources() {
        if (!this.isResultSetClosed()) {
            if (this.ojbIterator instanceof RsIterator) {
                ((RsIterator)this.ojbIterator).releaseDbResources();
            } else if (this.ojbIterator instanceof RsIteratorStub) {
                ((RsIteratorStub)this.ojbIterator).releaseDbResources();
            }
            this.setResultSetClosed(true);
        }
    }

    public synchronized Object next() {
        if (this.position < this.scrolled) {
            ++this.position;
            return this.elements.get(this.position - 1);
        }
        Object next = this.ojbIterator.next();
        this.elements.add(next);
        ++this.position;
        ++this.scrolled;
        return next;
    }

    public synchronized void reset() {
        this.position = 0;
    }

    public int size() {
        return this.length;
    }

    public boolean isResultSetClosed() {
        return this.resultSetClosed;
    }

    public void setResultSetClosed(boolean resultSetClosed) {
        this.resultSetClosed = resultSetClosed;
    }
}

