/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg.oql;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.StringReader;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import ojb.broker.ManageableCollection;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.query.Criteria;
import ojb.broker.query.Query;
import ojb.broker.query.SelectionCriteria;
import ojb.odmg.OJB;
import ojb.odmg.TransactionImpl;
import ojb.odmg.oql.OQLLexer;
import ojb.odmg.oql.OQLParser;
import org.odmg.OQLQuery;
import org.odmg.QueryException;
import org.odmg.QueryInvalidException;
import org.odmg.QueryParameterCountInvalidException;
import org.odmg.QueryParameterTypeInvalidException;
import org.odmg.Transaction;

public class OQLQueryImpl
implements OQLQuery {
    private String queryString = null;
    private Query query = null;
    private Iterator bindIterator = null;
    private Class collectionClass;

    public Query getQuery() {
        return this.query;
    }

    protected synchronized Class getCollectionClass() {
        if (this.collectionClass == null) {
            this.collectionClass = PersistenceBrokerFactory.getConfiguration().getOqlCollectionClass();
        }
        return this.collectionClass;
    }

    public void bind(Object parameter) throws QueryParameterCountInvalidException, QueryParameterTypeInvalidException {
        try {
            SelectionCriteria crit = (SelectionCriteria)this.bindIterator.next();
            crit.bind(parameter);
        }
        catch (Exception e) {
            throw new QueryParameterCountInvalidException(e.getMessage());
        }
    }

    private Vector flatten(Criteria crit, Vector acc) {
        Enumeration e = crit.getElements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Criteria) {
                Criteria pc = (Criteria)o;
                this.flatten(pc, acc);
                continue;
            }
            SelectionCriteria c = (SelectionCriteria)o;
            acc.add(c);
        }
        return acc;
    }

    public void create(String query) throws QueryInvalidException {
        try {
            this.queryString = query;
            StringReader reader = new StringReader(this.queryString);
            OQLLexer lexer = new OQLLexer(reader);
            OQLParser parser = new OQLParser(lexer);
            this.query = parser.buildQuery();
            this.bindIterator = ((AbstractList)this.flatten(this.query.getCriteria(), new Vector())).iterator();
        }
        catch (RecognitionException e) {
            throw new QueryInvalidException(e.getMessage());
        }
        catch (TokenStreamException e) {
            throw new QueryInvalidException(e.getMessage());
        }
    }

    public Object execute() throws QueryException {
        try {
            Transaction tx = OJB.getInstance().currentTransaction();
            boolean needsCommit = false;
            if (tx == null) {
                tx = OJB.getInstance().newTransaction();
            }
            if (!tx.isOpen()) {
                tx.begin();
                needsCommit = true;
            }
            PersistenceBroker broker = ((TransactionImpl)tx).getBroker();
            broker.beginTransaction();
            ManageableCollection result = broker.getCollectionByQuery(this.getCollectionClass(), this.query);
            broker.commitTransaction();
            Iterator iter = result.ojbIterator();
            while (iter.hasNext()) {
                tx.lock(iter.next(), 1);
            }
            if (needsCommit) {
                tx.commit();
            }
            return result;
        }
        catch (Throwable t) {
            OJB.getLogger().error(t);
            throw new QueryException(t.getMessage());
        }
    }
}

