/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.metadata;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.util.LoggerFactory;

public class PersistentField
implements Serializable {
    private transient Field field;
    private Class clazz;
    private String fieldname;
    static /* synthetic */ Class class$java$lang$Object;

    public Field getField() {
        if (this.field == null) {
            this.field = this.computeField(this.clazz, this.fieldname);
        }
        return this.field;
    }

    public PersistentField(Field f) {
        this.field = f;
    }

    protected Field computeField(Class c, String fieldname) throws PersistenceBrokerException {
        Field f = null;
        try {
            f = this.getFieldRecursive(c, fieldname);
            ((AccessibleObject)f).setAccessible(true);
            return f;
        }
        catch (Throwable t) {
            LoggerFactory.getDefaultLogger().error("FieldDescriptor: Can't find member " + fieldname + " in " + c.getName());
            LoggerFactory.getDefaultLogger().error(t);
            throw new PersistenceBrokerException(t);
        }
    }

    protected Field getFieldRecursive(Class c, String fieldname) throws NoSuchFieldException {
        try {
            Field f = c.getDeclaredField(fieldname);
            return f;
        }
        catch (NoSuchFieldException e) {
            if (c == (class$java$lang$Object == null ? (class$java$lang$Object = PersistentField.class$("java.lang.Object")) : class$java$lang$Object)) {
                throw e;
            }
            return this.getFieldRecursive(c.getSuperclass(), fieldname);
        }
    }

    public PersistentField(Class c, String fieldname) {
        this.clazz = c;
        this.fieldname = fieldname;
        this.field = this.computeField(c, fieldname);
    }

    public void set(Object obj, Object value) throws IllegalAccessException, IllegalArgumentException {
        boolean before = this.getField().isAccessible();
        AccessController.doPrivileged(new SetAccessibleAction());
        Field f = this.getField();
        Class<?> type = f.getType();
        try {
            if (type == Integer.TYPE) {
                f.setInt(obj, (Integer)value);
            } else if (type == Boolean.TYPE) {
                f.setBoolean(obj, (Boolean)value);
            } else if (type == Long.TYPE) {
                f.setLong(obj, (Long)value);
            } else if (type == Float.TYPE) {
                f.setFloat(obj, ((Float)value).floatValue());
            } else if (type == Double.TYPE) {
                f.setDouble(obj, (Double)value);
            } else if (type == Short.TYPE) {
                f.setShort(obj, (Short)value);
            } else if (type == Byte.TYPE) {
                f.setByte(obj, (Byte)value);
            } else if (type == Character.TYPE) {
                f.setChar(obj, value.toString().charAt(0));
            } else {
                f.set(obj, value);
            }
        }
        catch (IllegalArgumentException ex) {
            ((AccessibleObject)this.getField()).setAccessible(before);
            LoggerFactory.getDefaultLogger().error(ex);
            LoggerFactory.getDefaultLogger().error("field: " + this.fieldname + ", type: " + type);
            LoggerFactory.getDefaultLogger().error("value: " + value + ", type: " + value.getClass());
            throw ex;
        }
        ((AccessibleObject)this.getField()).setAccessible(before);
    }

    public Object get(Object obj) throws IllegalAccessException {
        boolean before = this.getField().isAccessible();
        AccessController.doPrivileged(new SetAccessibleAction());
        Object result = this.getField().get(obj);
        ((AccessibleObject)this.getField()).setAccessible(before);
        return result;
    }

    public Class getType() {
        return this.getField().getType();
    }

    public String getName() {
        return this.getField().getName();
    }

    public Class getDeclaringClass() {
        return this.getField().getDeclaringClass();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SetAccessibleAction
    implements PrivilegedAction {
        private SetAccessibleAction() {
        }

        public Object run() {
            ((AccessibleObject)PersistentField.this.getField()).setAccessible(true);
            return null;
        }
    }
}

