/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import ojb.broker.Identity;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerSQLException;
import ojb.broker.accesslayer.JdbcAccess;
import ojb.broker.accesslayer.StatementsForClass;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.query.BetweenCriteria;
import ojb.broker.query.Criteria;
import ojb.broker.query.EqualToColumnCriteria;
import ojb.broker.query.ExistsCriteria;
import ojb.broker.query.InCriteria;
import ojb.broker.query.NullCriteria;
import ojb.broker.query.Query;
import ojb.broker.query.SelectionCriteria;
import ojb.broker.query.SqlCriteria;
import ojb.broker.singlevm.PersistenceBrokerImpl;
import ojb.broker.util.LoggerFactory;

public class StatementManager {
    private Hashtable statementTable = new Hashtable();
    private PersistenceBrokerImpl broker;

    public StatementManager(PersistenceBrokerImpl pBroker) {
        this.broker = pBroker;
    }

    public void bindDelete(PreparedStatement stmt, Identity oid) throws SQLException {
        int i = 0;
        while (i < oid.getPrimaryKeyValues().length) {
            stmt.setObject(i + 1, oid.getPrimaryKeyValues()[i]);
            ++i;
        }
    }

    public void bindDelete(PreparedStatement stmt, ClassDescriptor cld, Object obj) throws SQLException {
        int index = 1;
        Object[] currentLockingValues = cld.getCurrentLockingValues(obj);
        Object[] values = cld.getKeyValues(obj);
        int i = 0;
        while (i < values.length) {
            stmt.setObject(index, values[i]);
            ++index;
            ++i;
        }
        values = currentLockingValues;
        int i2 = 0;
        while (i2 < values.length) {
            stmt.setObject(index, values[i2]);
            ++index;
            ++i2;
        }
    }

    private int bindStatementValue(PreparedStatement stmt, int index, Object value) throws SQLException {
        if (value != null) {
            stmt.setObject(index, value);
        } else {
            stmt.setNull(index, 0);
        }
        return ++index;
    }

    private int bindStatement(PreparedStatement stmt, int index, SelectionCriteria crit) throws SQLException {
        return this.bindStatementValue(stmt, index, crit.getO());
    }

    private int bindStatement(PreparedStatement stmt, int index, NullCriteria crit) throws SQLException {
        return index;
    }

    private int bindStatement(PreparedStatement stmt, int index, EqualToColumnCriteria crit) throws SQLException {
        return index;
    }

    private int bindStatement(PreparedStatement stmt, int index, SqlCriteria crit) throws SQLException {
        return index;
    }

    private int bindStatement(PreparedStatement stmt, int index, BetweenCriteria crit) throws SQLException {
        index = this.bindStatementValue(stmt, index, crit.getO());
        return this.bindStatementValue(stmt, index, crit.getO2());
    }

    private int bindStatement(PreparedStatement stmt, int index, InCriteria crit) throws SQLException {
        Collection values = (Collection)crit.getO();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            index = this.bindStatementValue(stmt, index, iter.next());
        }
        return index;
    }

    private int bindStatement(PreparedStatement stmt, int index, ExistsCriteria crit, ClassDescriptor cld) throws SQLException {
        Query subQuery = (Query)crit.getO();
        if (subQuery.getCriteria() != null && !subQuery.getCriteria().isEmpty()) {
            return this.bindStatement(stmt, subQuery.getCriteria(), cld.getRepository().getDescriptorFor(subQuery.getSearchClass()), index);
        }
        return index;
    }

    public int bindStatement(PreparedStatement stmt, Criteria crit, ClassDescriptor cld, int param) throws SQLException {
        if (crit != null) {
            Enumeration e = crit.getElements();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o instanceof Criteria) {
                    Criteria pc = (Criteria)o;
                    param = this.bindStatement(stmt, pc, cld, param);
                    continue;
                }
                SelectionCriteria c = (SelectionCriteria)o;
                param = c instanceof NullCriteria ? this.bindStatement(stmt, param, (NullCriteria)c) : (c instanceof BetweenCriteria ? this.bindStatement(stmt, param, (BetweenCriteria)c) : (c instanceof InCriteria ? this.bindStatement(stmt, param, (InCriteria)c) : (c instanceof SqlCriteria ? this.bindStatement(stmt, param, (SqlCriteria)c) : (c instanceof EqualToColumnCriteria ? this.bindStatement(stmt, param, (EqualToColumnCriteria)c) : (c instanceof ExistsCriteria ? this.bindStatement(stmt, param, (ExistsCriteria)c, cld) : this.bindStatement(stmt, param, c))))));
            }
        }
        return param;
    }

    public void bindInsert(PreparedStatement stmt, ClassDescriptor cld, Object obj) throws SQLException {
        cld.updateLockingValues(obj);
        Object[] values = cld.getAllValues(obj);
        int i = 0;
        while (i < values.length) {
            Object val = values[i];
            if (val != null) {
                stmt.setObject(i + 1, val, JdbcAccess.getSqlTypeAll(cld, i));
            } else {
                stmt.setNull(i + 1, JdbcAccess.getSqlTypeAll(cld, i));
            }
            ++i;
        }
    }

    public void bindSelect(PreparedStatement stmt, Identity oid) throws SQLException {
        int i = 0;
        try {
            i = 0;
            while (i < oid.getPrimaryKeyValues().length) {
                stmt.setObject(i + 1, oid.getPrimaryKeyValues()[i]);
                ++i;
            }
        }
        catch (SQLException e) {
            LoggerFactory.getDefaultLogger().error("bindSelect failed for: " + oid.toString() + ", PK: " + i + ", value: " + oid.getPrimaryKeyValues()[i]);
            throw e;
        }
    }

    public void bindUpdate(PreparedStatement stmt, ClassDescriptor cld, Object obj) throws SQLException {
        int index = 1;
        Object[] currentLockingValues = cld.getCurrentLockingValues(obj);
        cld.updateLockingValues(obj);
        Object[] values = cld.getNonKeyValues(obj);
        int i = 0;
        while (i < values.length) {
            Object val = values[i];
            if (val != null) {
                stmt.setObject(index, val);
            } else {
                stmt.setNull(index, JdbcAccess.getSqlTypeNonPk(cld, i));
            }
            ++index;
            ++i;
        }
        values = cld.getKeyValues(obj);
        int i2 = 0;
        while (i2 < values.length) {
            Object val = values[i2];
            if (val != null) {
                stmt.setObject(index, values[i2]);
            } else {
                stmt.setNull(index, JdbcAccess.getSqlTypePk(cld, i2));
            }
            ++index;
            ++i2;
        }
        values = currentLockingValues;
        int i3 = 0;
        while (i3 < values.length) {
            Object val = values[i3];
            if (val != null) {
                stmt.setObject(index, values[i3]);
            } else {
                stmt.setNull(index, JdbcAccess.getSqlTypeNonPk(cld, i3));
            }
            ++index;
            ++i3;
        }
    }

    public PreparedStatement getDeleteStatement(ClassDescriptor cds) throws PersistenceBrokerSQLException {
        try {
            return this.getStatementsForClass(cds).getDeleteStmt();
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException(e);
        }
    }

    public Statement getGenericStatement(ClassDescriptor cds) throws PersistenceBrokerException {
        return this.getStatementsForClass(cds).getGenericStmt();
    }

    public PreparedStatement getInsertStatement(ClassDescriptor cds) throws PersistenceBrokerSQLException {
        try {
            return this.getStatementsForClass(cds).getInsertStmt();
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException(e);
        }
    }

    public PreparedStatement getPreparedStatement(ClassDescriptor cds, String sql) throws PersistenceBrokerException {
        return this.getStatementsForClass(cds).getPreparedStmt(sql);
    }

    public PreparedStatement getSelectByPKStatement(ClassDescriptor cds) throws PersistenceBrokerSQLException {
        try {
            return this.getStatementsForClass(cds).getSelectByPKStmt();
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException(e);
        }
    }

    private StatementsForClass getStatementsForClass(ClassDescriptor cds) throws PersistenceBrokerException {
        StatementsForClass sfc = (StatementsForClass)this.statementTable.get(cds);
        if (sfc == null) {
            sfc = new StatementsForClass(cds, this.broker);
            this.statementTable.put(cds, sfc);
        }
        return sfc;
    }

    public PreparedStatement getUpdateStatement(ClassDescriptor cds) throws PersistenceBrokerSQLException {
        try {
            return this.getStatementsForClass(cds).getUpdateStmt();
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException(e);
        }
    }
}

