/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import ojb.broker.Identity;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.VirtualProxy;
import ojb.broker.accesslayer.JdbcAccess;
import ojb.broker.cache.ObjectCache;
import ojb.broker.cache.ObjectCacheFactory;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.query.Query;
import ojb.broker.singlevm.PersistenceBrokerImpl;
import ojb.broker.util.Logger;
import ojb.broker.util.LoggerFactory;

public class RsIterator
implements Iterator {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static ObjectCache cache = ObjectCacheFactory.getObjectCache();
    protected PersistenceBrokerImpl m_broker;
    protected ResultSet m_rs;
    protected ClassDescriptor m_mif;
    protected Class itemProxyClass;
    private Class itemExtentClass = null;
    protected Object[] m_row = null;
    protected boolean hasCalledCheck = false;
    protected boolean hasNext = false;

    protected Class getExtentClass() {
        if (this.itemExtentClass == null) {
            this.itemExtentClass = this.m_broker.getExtentClass(this.m_mif.getClassOfObject());
        }
        return this.itemExtentClass;
    }

    public synchronized boolean hasNext() {
        try {
            if (!this.hasCalledCheck) {
                this.hasCalledCheck = true;
                this.hasNext = this.m_rs.next();
                if (!this.hasNext) {
                    this.releaseDbResources();
                }
            }
        }
        catch (Exception ex) {
            this.hasNext = false;
        }
        return this.hasNext;
    }

    public synchronized Object next() throws NoSuchElementException {
        try {
            if (!this.hasCalledCheck) {
                this.hasNext();
            }
            this.hasCalledCheck = false;
            if (this.hasNext) {
                Object obj = this.getObjectFromResultSet();
                return obj;
            }
            throw new NoSuchElementException();
        }
        catch (Exception ex) {
            this.logger.error(ex);
            throw new NoSuchElementException();
        }
    }

    public void remove() {
        this.logger.error("removing not supported by RsIterator");
    }

    protected RsIterator() {
    }

    public RsIterator(Query query, ClassDescriptor mif, PersistenceBrokerImpl broker) {
        this.m_rs = new JdbcAccess(broker).executeQuery(query, mif);
        this.m_row = new Object[mif.getFieldDescriptions().length];
        this.m_broker = broker;
        this.m_mif = mif;
        this.itemProxyClass = mif.getProxyClass();
    }

    protected Identity getIdentityFromResultSet() throws PersistenceBrokerException {
        try {
            FieldDescriptor[] pkFields = this.m_mif.getPkFields();
            Object[] pkValues = new Object[pkFields.length];
            int i = 0;
            while (i < pkFields.length) {
                FieldDescriptor fld = pkFields[i];
                pkValues[i] = this.m_row[i];
                ++i;
            }
            return new Identity(this.getExtentClass(), pkValues);
        }
        catch (Throwable t) {
            this.logger.error(t);
            throw new PersistenceBrokerException(t);
        }
    }

    protected Object getObjectFromResultSet() throws PersistenceBrokerException {
        if (this.itemProxyClass != null) {
            this.m_mif.getRowReader().readPkValuesFrom(this.m_rs, this.m_mif, this.m_row);
            return this.getProxyFromResultSet();
        }
        this.m_mif.getRowReader().readObjectArrayFrom(this.m_rs, this.m_mif, this.m_row);
        Identity oid = this.getIdentityFromResultSet();
        Object result = null;
        result = cache.lookup(oid);
        if (result == null) {
            result = this.m_mif.getRowReader().readObjectFrom(this.m_row, this.m_mif);
            if (result != null) {
                cache.cache(oid, result);
                this.m_broker.retrieveReferences(result, this.m_mif);
                this.m_broker.retrieveCollections(result, this.m_mif);
            }
        } else {
            this.m_broker.refreshRelationships(result, this.m_mif);
        }
        return result;
    }

    protected Object getProxyFromResultSet() throws PersistenceBrokerException {
        try {
            Identity oid = this.getIdentityFromResultSet();
            return VirtualProxy.createProxy(this.itemProxyClass, oid);
        }
        catch (PersistenceBrokerException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new PersistenceBrokerException(t);
        }
    }

    public void releaseDbResources() {
        try {
            Statement stmt = null;
            if (this.m_rs != null) {
                stmt = this.m_rs.getStatement();
            }
            if (stmt != null) {
                stmt.close();
            }
            this.m_rs = null;
        }
        catch (Throwable t) {
            this.logger.error(t.getMessage());
        }
    }
}

