/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jcfe;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class JavaType {
    private int rank = 0;
    private String dottedName;
    private boolean hasPrimitive = false;
    private static final int primitiveCount = 9;
    private static PrimitiveForm[] primitiveForms = new PrimitiveForm[9];

    public int getRank() {
        return this.rank;
    }

    public String toString() {
        return this.dottedName;
    }

    public short getSize() {
        if (this.dottedName.equals("D") || this.dottedName.equals("J")) {
            return 2;
        }
        if (this.dottedName.equals("V")) {
            return 0;
        }
        return 1;
    }

    public char getByteCodeType() {
        if (!this.hasPrimitive) {
            return 'A';
        }
        return this.dottedName.charAt(0);
    }

    public static short getSize(String desc) {
        JavaType jt = new JavaType(desc);
        return jt.getSize();
    }

    public void increaseRank() {
        ++this.rank;
    }

    public String getDottedName() {
        return this.dottedName;
    }

    public boolean isVoid() {
        return this.dottedName.equals("V");
    }

    public String getClassfileInternalForm() {
        StringBuffer sb = new StringBuffer();
        if (this.rank == 0 || this.hasPrimitive) {
            sb.append(this.dottedName);
        } else {
            sb.append('L').append(this.dottedName).append(';');
        }
        String result = sb.toString();
        return this.rankify(result.replace('.', '/'));
    }

    public String getDescriptorForm() {
        StringBuffer sb = new StringBuffer();
        if (this.hasPrimitive) {
            sb.append(this.dottedName);
        } else {
            sb.append('L').append(this.dottedName).append(';');
        }
        String result = sb.toString();
        return this.rankify(result.replace('.', '/'));
    }

    public Class toClass(ClassLoader cl) throws ClassNotFoundException {
        if (this.hasPrimitive) {
            Class<Object> cls;
            switch (this.getByteCodeType()) {
                case 'I': {
                    cls = Integer.TYPE;
                    break;
                }
                case 'B': {
                    cls = Byte.TYPE;
                    break;
                }
                case 'C': {
                    cls = Character.TYPE;
                    break;
                }
                case 'D': {
                    cls = Double.TYPE;
                    break;
                }
                case 'F': {
                    cls = Float.TYPE;
                    break;
                }
                case 'J': {
                    cls = Long.TYPE;
                    break;
                }
                case 'S': {
                    cls = Short.TYPE;
                    break;
                }
                case 'Z': {
                    cls = Boolean.TYPE;
                    break;
                }
                case 'V': {
                    cls = Void.TYPE;
                    break;
                }
                default: {
                    throw new ClassNotFoundException();
                }
            }
            if (this.rank == 0) {
                return cls;
            }
            int[] dims = new int[this.rank];
            return Array.newInstance(cls, dims).getClass();
        }
        StringBuffer sb = new StringBuffer();
        if (this.rank == 0) {
            sb.append(this.dottedName);
        } else {
            sb.append('L').append(this.dottedName).append(';');
        }
        return Class.forName(this.rankify(sb.toString()), false, cl);
    }

    public Object newInstance(ClassLoader cl) {
        try {
            JavaType jt = this.getWrapperForPrimitive();
            Class cls = null;
            if (jt != null) {
                cls = jt.toClass(cl);
            }
            if (this.isPrimitiveWrapper()) {
                cls = this.toClass(cl);
            }
            if (cls != null) {
                Class[] paramTypes = new Class[1];
                Object[] params = new Object[1];
                paramTypes[0] = Class.forName("java.lang.String");
                params[0] = "0";
                Constructor cons = cls.getConstructor(paramTypes);
                return cons.newInstance(params);
            }
            return Class.forName(this.dottedName, true, cl).newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private String rankify(String base) {
        if (this.rank == 0 || base == null) {
            return base;
        }
        StringBuffer sb = new StringBuffer();
        int n = 0;
        while (n < this.rank) {
            sb.append('[');
            ++n;
        }
        return sb.append(base).toString();
    }

    public static JavaType forClass(Class clazz) {
        return new JavaType(clazz.getName());
    }

    public JavaType(String fullname) {
        while (fullname.charAt(this.rank) == '[') {
            ++this.rank;
        }
        String name = fullname.substring(this.rank, fullname.length()).replace('/', '.');
        String desc = JavaType.getDescriptorFromReflectionPrimitive(name);
        if (desc != null) {
            this.hasPrimitive = true;
            this.dottedName = desc;
        } else if (JavaType.isPrimitiveDescriptor(name)) {
            this.hasPrimitive = true;
            this.dottedName = name;
        } else {
            this.dottedName = name.startsWith("L") && name.endsWith(";") ? name.substring(1, name.length() - 1) : name;
        }
    }

    public static String getDescriptorForm(String name) {
        JavaType jt = new JavaType(name);
        return jt.getDescriptorForm();
    }

    public static String getClassfileInternalForm(String name) {
        JavaType jt = new JavaType(name);
        return jt.getClassfileInternalForm();
    }

    public static String getDescriptorFromMethod(Method meth) {
        Class<?>[] paramTypes = meth.getParameterTypes();
        StringBuffer result = new StringBuffer();
        result.append('(');
        int n = 0;
        while (n < paramTypes.length) {
            result.append(JavaType.getDescriptorForm(paramTypes[n].getName()));
            ++n;
        }
        result.append(')');
        Class<?> retType = meth.getReturnType();
        return result.append(JavaType.getDescriptorForm(retType.getName())).toString();
    }

    public JavaType getWrapperForPrimitive() {
        if (this.rank == 0) {
            return JavaType.getWrapperForPrimitive(this.dottedName);
        }
        return null;
    }

    public static JavaType getWrapperForPrimitive(String desc) {
        if (desc.charAt(0) == '[') {
            throw new Error("getWrapperForPrimitive doesn't handle array types");
        }
        int n = 0;
        while (n < 9) {
            if (primitiveForms[n] != null && JavaType.primitiveForms[n].descriptor.equals(desc)) {
                return new JavaType(JavaType.primitiveForms[n].wrapperDescriptor);
            }
            ++n;
        }
        return null;
    }

    public static JavaType getWrapperForPrimitiveReflection(String refl) {
        if (refl.charAt(0) == '[') {
            throw new Error("getWrapperForPrimitiveReflection doesn't handle array types");
        }
        int n = 0;
        while (n < 9) {
            if (JavaType.primitiveForms[n].reflectionForm.equals(refl)) {
                return new JavaType(JavaType.primitiveForms[n].wrapperDescriptor);
            }
            ++n;
        }
        return null;
    }

    public static String getDescriptorFromReflectionPrimitive(String refl) {
        int n = 0;
        while (n < 9) {
            if (JavaType.primitiveForms[n].reflectionForm.equals(refl)) {
                return JavaType.primitiveForms[n].descriptor;
            }
            ++n;
        }
        return null;
    }

    public String getConversionMethodName() {
        return JavaType.getConversionMethodName(this.dottedName);
    }

    public static String getConversionMethodName(String desc) {
        int n = 0;
        while (n < 9) {
            if (JavaType.primitiveForms[n].descriptor.equals(desc)) {
                return JavaType.primitiveForms[n].methodName;
            }
            ++n;
        }
        return null;
    }

    public String getConversionMethodSig() {
        return JavaType.getConversionMethodSig(this.dottedName);
    }

    public static String getConversionMethodSig(String desc) {
        int n = 0;
        while (n < 9) {
            if (JavaType.primitiveForms[n].descriptor.equals(desc)) {
                return JavaType.primitiveForms[n].methodSig;
            }
            ++n;
        }
        return null;
    }

    public static boolean isPrimitiveDescriptor(String desc) {
        int n = 0;
        while (n < 9) {
            if (JavaType.primitiveForms[n].descriptor.equals(desc)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isPrimitive() {
        return this.hasPrimitive && this.rank == 0;
    }

    public boolean hasPrimitive() {
        return this.hasPrimitive;
    }

    public boolean isPrimitiveWrapper() {
        String desc = this.getDescriptorForm();
        int n = 0;
        while (n < 9) {
            if (desc.equals(JavaType.primitiveForms[n].wrapperDescriptor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static {
        JavaType.primitiveForms[0] = new PrimitiveForm("I", "int", "Ljava/lang/Integer;", "intValue", "()I");
        JavaType.primitiveForms[1] = new PrimitiveForm("B", "byte", "Ljava/lang/Byte;", "byteValue", "()B");
        JavaType.primitiveForms[2] = new PrimitiveForm("C", "char", "Ljava/lang/Char;", "charValue", "()C");
        JavaType.primitiveForms[3] = new PrimitiveForm("D", "double", "Ljava/lang/Double;", "doubleValue", "()D");
        JavaType.primitiveForms[4] = new PrimitiveForm("F", "float", "Ljava/lang/Float;", "floatValue", "()F");
        JavaType.primitiveForms[5] = new PrimitiveForm("J", "long", "Ljava/lang/Long;", "longValue", "()J");
        JavaType.primitiveForms[6] = new PrimitiveForm("S", "short", "Ljava/lang/Short;", "shortValue", "()S");
        JavaType.primitiveForms[7] = new PrimitiveForm("Z", "boolean", "Ljava/lang/Boolean;", "booleanValue", "()Z");
        JavaType.primitiveForms[8] = new PrimitiveForm("V", "void", null, null, null);
    }

    private static class PrimitiveForm {
        public final String descriptor;
        public final String reflectionForm;
        public final String wrapperDescriptor;
        public final String methodName;
        public final String methodSig;

        public PrimitiveForm(String descriptor, String reflectionForm, String wrapperDescriptor, String methodName, String methodSig) {
            this.descriptor = descriptor;
            this.reflectionForm = reflectionForm;
            this.wrapperDescriptor = wrapperDescriptor;
            this.methodName = methodName;
            this.methodSig = methodSig;
        }
    }
}

