/*
 * Decompiled with CFR 0.152.
 */
package com.develop.delegator;

import com.develop.jcfe.ClassFile;
import com.develop.jcfe.ClassfileConstants;
import com.develop.jcfe.JavaType;
import com.develop.jcfe.MethodType;
import com.develop.jcfe.attribute.CodeAttribute;
import com.develop.jcfe.attribute.ExceptionTableEntry;
import com.develop.jcfe.attribute.ExceptionsAttribute;
import com.develop.jcfe.cpool.ConstantPool;
import com.develop.jcfe.method_info;
import java.util.Vector;

public class MethodMachine
implements ClassfileConstants {
    Vector byteCodes = new Vector();
    private final ClassFile cf;
    private final ConstantPool cp;
    private short max_stack = 0;
    private short cur_stack = 0;
    private short max_locals = 0;
    private short currentOffset = 0;
    String methodName;
    String methodDesc;
    Vector exceptionTable = new Vector();
    ExceptionsAttribute ea;
    public static final byte EQ = -103;
    CodeAttribute ca = null;
    method_info mi = null;

    private CodeAttribute getCodeAttribute() {
        if (this.ca == null) {
            byte[] bytes = new byte[this.byteCodes.size()];
            int n = 0;
            while (n < this.byteCodes.size()) {
                bytes[n] = (Byte)this.byteCodes.elementAt(n);
                ++n;
            }
            this.ca = new CodeAttribute(this.cp, this.max_stack, this.max_locals, bytes, this.exceptionTable);
            this.byteCodes = null;
        }
        return this.ca;
    }

    public short getCurrentOffset() {
        return this.currentOffset;
    }

    public void addExceptionTableEntry(short start, short end, short handler, Class cls) {
        short classIndex = this.cp.addClass(JavaType.forClass(cls));
        this.exceptionTable.add(new ExceptionTableEntry(start, end, handler, classIndex));
    }

    public void addException(Class cls) {
        short classIndex = this.cp.addClass(JavaType.forClass(cls));
        this.ea.addException(classIndex);
    }

    public method_info connectMethodToClassFile() {
        MethodMachine methodMachine = this;
        synchronized (methodMachine) {
            if (this.mi == null) {
                this.mi = this.cf.addMethod((short)1, this.methodName, this.methodDesc);
                this.mi.addCodeAttribute(this.getCodeAttribute());
                if (this.ea.getNumberOfExceptions() > 0) {
                    this.mi.addExceptionsAttribute(this.ea);
                }
            }
        }
        return this.mi;
    }

    public MethodMachine(ClassFile cf, String methodName, String methodDesc) {
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.cf = cf;
        this.cp = cf.getConstantPool();
        this.ea = new ExceptionsAttribute(this.cp);
    }

    private void local(int referencedLocal) {
        if (referencedLocal >= this.max_locals) {
            this.max_locals = (short)(referencedLocal + 1);
        }
    }

    private void growStack(int nCount) {
        this.cur_stack = (short)(this.cur_stack + nCount);
        if (this.max_stack < this.cur_stack) {
            this.max_stack = this.cur_stack;
        }
    }

    private void shrinkStack(int nCount) {
        this.cur_stack = (short)(this.cur_stack - nCount);
        if (this.cur_stack < 0) {
            throw new Error("ByteCodeGenerator stack underflow");
        }
    }

    private void pushStack() {
        this.growStack(1);
    }

    private void popStack() {
        this.cur_stack = (short)(this.cur_stack - 1);
        if (this.cur_stack < 0) {
            throw new Error("ByteCodeGenerator stack underflow");
        }
    }

    private void appendByte(byte b) {
        this.byteCodes.addElement(new Byte(b));
        this.currentOffset = (short)(this.currentOffset + 1);
    }

    private void appendShort(short s) {
        this.appendByte((byte)(s >>> 8));
        this.appendByte((byte)s);
    }

    private boolean isByteSized(int n) {
        return n >= -128 && n <= 127;
    }

    public void xload(char type, int n) {
        int fastInstruction;
        byte instruction;
        this.pushStack();
        this.local(n);
        switch (type) {
            case 'A': {
                instruction = 25;
                fastInstruction = 42;
                break;
            }
            case 'D': {
                instruction = 24;
                fastInstruction = 38;
                this.pushStack();
                this.local(n + 1);
                break;
            }
            case 'F': {
                instruction = 23;
                fastInstruction = 34;
                break;
            }
            case 'J': {
                instruction = 22;
                fastInstruction = 30;
                this.pushStack();
                this.local(n + 1);
                break;
            }
            default: {
                instruction = 21;
                fastInstruction = 26;
            }
        }
        if (n > -1 && n < 4) {
            this.appendByte((byte)(fastInstruction + n));
        } else if (this.isByteSized(n)) {
            this.appendByte(instruction);
            this.appendByte((byte)n);
        } else {
            throw new Error("not implemented yet");
        }
    }

    public void xstore(char type, int n) {
        int fastInstruction;
        byte instruction;
        this.popStack();
        this.local(n);
        switch (type) {
            case 'A': {
                instruction = 58;
                fastInstruction = 75;
                break;
            }
            case 'D': {
                instruction = 57;
                fastInstruction = 71;
                this.popStack();
                this.local(n + 1);
                break;
            }
            case 'F': {
                instruction = 56;
                fastInstruction = 67;
                break;
            }
            case 'J': {
                instruction = 55;
                fastInstruction = 63;
                this.popStack();
                this.local(n + 1);
                break;
            }
            default: {
                instruction = 54;
                fastInstruction = 59;
            }
        }
        if (n > -1 && n < 4) {
            this.appendByte((byte)(fastInstruction + n));
        } else if (this.isByteSized(n)) {
            this.appendByte(instruction);
            this.appendByte((byte)n);
        } else {
            throw new Error("not implemented yet");
        }
    }

    public void aastore() {
        this.shrinkStack(3);
        this.appendByte((byte)83);
    }

    public void aconst_null() {
        this.pushStack();
        this.appendByte((byte)1);
    }

    public void anewarray(String className) {
        this.anewarray(new JavaType(className));
    }

    public void anewarray(JavaType jt) {
        short sIndex = this.cp.addClass(jt);
        this.appendByte((byte)-67);
        this.appendShort(sIndex);
    }

    public void areturn() {
        this.popStack();
        this.appendByte((byte)-80);
    }

    public void athrow() {
        this.appendByte((byte)-65);
    }

    public void beginHandler() {
        this.cur_stack = 1;
    }

    public void bipush(int b) {
        this.pushStack();
        this.appendByte((byte)16);
        this.appendByte((byte)b);
    }

    public void checkcast(JavaType jt) {
        this.appendByte((byte)-64);
        this.appendShort(this.cp.addClass(jt));
    }

    public void checkcast(Class cls) {
        this.appendByte((byte)-64);
        this.appendShort(this.cp.addClass(JavaType.forClass(cls)));
    }

    public void dreturn() {
        this.shrinkStack(2);
        this.appendByte((byte)-81);
    }

    public void dup() {
        this.pushStack();
        this.appendByte((byte)89);
    }

    public void freturn() {
        this.popStack();
        this.appendByte((byte)-82);
    }

    public void getfield(short sIndex) {
        if (this.cp.getFieldSize(sIndex) == 2) {
            this.pushStack();
        }
        this.appendByte((byte)-76);
        this.appendShort(sIndex);
    }

    public void iconst(int n) {
        this.pushStack();
        if (n > -2 && n < 6) {
            this.appendByte((byte)(3 + n));
        } else if (this.isByteSized(n)) {
            this.bipush(n);
        } else {
            throw new Error("not implemented yet");
        }
    }

    public void ifx(byte cond, int offset) {
        this.popStack();
        this.appendByte(cond);
        this.appendShort((short)offset);
    }

    public void instanceof_(Class cls) {
        this.appendByte((byte)-63);
        this.appendShort(this.cp.addClass(JavaType.forClass(cls)));
    }

    public void invokeinterface(String className, String methodName, String desc, byte nargs) {
        this.invokeinterface(new JavaType(className), methodName, desc, nargs);
    }

    public void invokeinterface(JavaType jt, String methodName, String desc, byte nargs) {
        short sIndex = this.cp.addInterfaceMethodref(jt, methodName, desc);
        MethodType mt = new MethodType(desc);
        int popcount = 1 + mt.getParamsSize() - mt.getRetvalSize();
        this.shrinkStack(popcount);
        this.appendByte((byte)-71);
        this.appendShort(sIndex);
        this.appendByte(nargs);
        this.appendByte((byte)0);
    }

    public void invokespecial(JavaType jt, String methodName, String desc) {
        MethodType mt = new MethodType(desc);
        int popcount = 1 + mt.getParamsSize() - mt.getRetvalSize();
        this.shrinkStack(popcount);
        short sIndex = this.cp.addMethodref(jt, methodName, desc);
        this.appendByte((byte)-73);
        this.appendShort(sIndex);
    }

    public void invokestatic(JavaType jt, String methodName, String desc) {
        MethodType mt = new MethodType(desc);
        int popcount = mt.getParamsSize() - mt.getRetvalSize();
        this.shrinkStack(popcount);
        short sIndex = this.cp.addMethodref(jt, methodName, desc);
        this.appendByte((byte)-72);
        this.appendShort(sIndex);
    }

    public void invokevirtual(JavaType jt, String methodName, String desc) {
        MethodType mt = new MethodType(desc);
        int popcount = 1 + mt.getParamsSize() - mt.getRetvalSize();
        this.shrinkStack(popcount);
        short sIndex = this.cp.addMethodref(jt, methodName, desc);
        this.appendByte((byte)-74);
        this.appendShort(sIndex);
    }

    public void ireturn() {
        this.popStack();
        this.appendByte((byte)-84);
    }

    public void ldc(String str) {
        this.pushStack();
        short sIndex = this.cp.addString(str);
        if (this.isByteSized(sIndex)) {
            this.appendByte((byte)18);
            this.appendByte((byte)sIndex);
        } else {
            this.appendByte((byte)19);
            this.appendShort(sIndex);
        }
    }

    public void lreturn() {
        this.shrinkStack(2);
        this.appendByte((byte)-83);
    }

    public void new_(JavaType jt) {
        this.pushStack();
        short sClassIndex = this.cp.addClass(jt);
        this.appendByte((byte)-69);
        this.appendShort(sClassIndex);
    }

    public void pop() {
        this.popStack();
        this.appendByte((byte)87);
    }

    public void putfield(String className, String fieldName, String fieldClass) {
        this.putfield(new JavaType(className), fieldName, fieldClass);
    }

    public void putfield(JavaType jtClass, String fieldName, String fieldClass) {
        JavaType jtField = new JavaType(fieldClass);
        this.shrinkStack(1 + jtField.getSize());
        short sFieldIndex = this.cp.addFieldref(jtClass, fieldName, fieldClass);
        this.appendByte((byte)-75);
        this.appendShort(sFieldIndex);
    }

    public void return_() {
        this.appendByte((byte)-79);
    }
}

