/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs.html;

import org.apache.ecs.Element;
import org.apache.ecs.FocusEvents;
import org.apache.ecs.FormEvents;
import org.apache.ecs.KeyEvents;
import org.apache.ecs.MouseEvents;
import org.apache.ecs.PageEvents;
import org.apache.ecs.Printable;
import org.apache.ecs.SinglePartElement;

public class Input
extends SinglePartElement
implements Printable,
FormEvents,
PageEvents,
FocusEvents,
MouseEvents,
KeyEvents {
    public static final String TEXT = "TEXT";
    public static final String PASSWORD = "PASSWORD";
    public static final String CHECKBOX = "CHECKBOX";
    public static final String RADIO = "RADIO";
    public static final String FILE = "FILE";
    public static final String BUTTON = "BUTTON";
    public static final String IMAGE = "IMAGE";
    public static final String HIDDEN = "HIDDEN";
    public static final String SUBMIT = "SUBMIT";
    public static final String RESET = "RESET";
    public static final String text = "text";
    public static final String password = "password";
    public static final String checkbox = "checkbox";
    public static final String radio = "radio";
    public static final String file = "file";
    public static final String button = "button";
    public static final String image = "image";
    public static final String hidden = "hidden";
    public static final String submit = "submit";
    public static final String reset = "reset";

    public Input() {
        this.setElementType("input");
    }

    public Input(String string, String string2, double d) {
        this.setElementType("input");
        this.setType(string);
        this.setName(string2);
        this.setValue(d);
    }

    public Input(String string, String string2, int n) {
        this.setElementType("input");
        this.setType(string);
        this.setName(string2);
        this.setValue(n);
    }

    public Input(String string, String string2, Integer n) {
        this.setElementType("input");
        this.setType(string);
        this.setName(string2);
        this.setValue(n);
    }

    public Input(String string, String string2, String string3) {
        this.setElementType("input");
        this.setType(string);
        this.setName(string2);
        this.setValue(string3);
    }

    public Input addElement(String string) {
        this.addElementToRegistry(string);
        return this;
    }

    public Input addElement(String string, String string2) {
        this.addElementToRegistry(string, string2);
        return this;
    }

    public Input addElement(String string, Element element) {
        this.addElementToRegistry(string, element);
        return this;
    }

    public Input addElement(Element element) {
        this.addElementToRegistry(element);
        return this;
    }

    public Input removeElement(String string) {
        this.removeElementFromRegistry(string);
        return this;
    }

    public Input setAccept(String string) {
        this.addAttribute("accept", string);
        return this;
    }

    public Input setAlt(String string) {
        this.addAttribute("alt", string);
        return this;
    }

    public Input setBorder(int n) {
        this.addAttribute("border", Integer.toString(n));
        return this;
    }

    public Input setChecked(boolean bl) {
        if (bl) {
            this.addAttribute("checked", "ECS_NO_ATTRIBUTE_VALUE");
        } else {
            this.removeAttribute("checked");
        }
        return this;
    }

    public Input setDisabled(boolean bl) {
        if (bl) {
            this.addAttribute("disabled", "ECS_NO_ATTRIBUTE_VALUE");
        } else {
            this.removeAttribute("disabled");
        }
        return this;
    }

    public Input setMaxlength(int n) {
        this.setMaxlength(Integer.toString(n));
        return this;
    }

    public Input setMaxlength(String string) {
        this.addAttribute("maxlength", string);
        return this;
    }

    public Input setName(String string) {
        this.addAttribute("name", string);
        return this;
    }

    public void setOnBlur(String string) {
        this.addAttribute("onBlur", string);
    }

    public void setOnChange(String string) {
        this.addAttribute("onChange", string);
    }

    public void setOnClick(String string) {
        this.addAttribute("onClick", string);
    }

    public void setOnDblClick(String string) {
        this.addAttribute("onDblClick", string);
    }

    public void setOnFocus(String string) {
        this.addAttribute("onFocus", string);
    }

    public void setOnKeyDown(String string) {
        this.addAttribute("onKeyDown", string);
    }

    public void setOnKeyPress(String string) {
        this.addAttribute("onKeyPress", string);
    }

    public void setOnKeyUp(String string) {
        this.addAttribute("onKeyUp", string);
    }

    public void setOnLoad(String string) {
        this.addAttribute("onLoad", string);
    }

    public void setOnMouseDown(String string) {
        this.addAttribute("onMouseDown", string);
    }

    public void setOnMouseMove(String string) {
        this.addAttribute("onMouseMove", string);
    }

    public void setOnMouseOut(String string) {
        this.addAttribute("onMouseOut", string);
    }

    public void setOnMouseOver(String string) {
        this.addAttribute("onMouseOver", string);
    }

    public void setOnMouseUp(String string) {
        this.addAttribute("onMouseUp", string);
    }

    public void setOnReset(String string) {
        this.addAttribute("onReset", string);
    }

    public void setOnSelect(String string) {
        this.addAttribute("onSelect", string);
    }

    public void setOnSubmit(String string) {
        this.addAttribute("onSubmit", string);
    }

    public void setOnUnload(String string) {
        this.addAttribute("onUnload", string);
    }

    public Input setReadOnly(boolean bl) {
        if (bl) {
            this.addAttribute("readonly", "ECS_NO_ATTRIBUTE_VALUE");
        } else {
            this.removeAttribute("readonly");
        }
        return this;
    }

    public Input setSize(int n) {
        this.setSize(Integer.toString(n));
        return this;
    }

    public Input setSize(String string) {
        this.addAttribute("size", string);
        return this;
    }

    public Input setSrc(String string) {
        this.addAttribute("src", string);
        return this;
    }

    public Input setTabindex(int n) {
        this.setTabindex(Integer.toString(n));
        return this;
    }

    public Input setTabindex(String string) {
        this.addAttribute("tabindex", string);
        return this;
    }

    public Input setType(String string) {
        this.addAttribute("type", string);
        return this;
    }

    public Input setUsemap(String string) {
        this.addAttribute("usemap", string);
        return this;
    }

    public Input setValue(double d) {
        this.addAttribute("value", Double.toString(d));
        return this;
    }

    public Input setValue(int n) {
        this.addAttribute("value", Integer.toString(n));
        return this;
    }

    public Input setValue(Integer n) {
        this.addAttribute("value", n.toString());
        return this;
    }

    public Input setValue(String string) {
        this.addAttribute("value", string);
        return this;
    }
}

