/*
 * Decompiled with CFR 0.152.
 */
package slidestore.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Hashtable;
import org.apache.slide.common.AbstractSimpleService;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.store.ContentStore;

public class FileContentStoreNoVersioning
extends AbstractSimpleService
implements ContentStore {
    public static final int BUFFER_SIZE = 2048;
    public static final String CHARACTER_ENCODING = "8859_1";
    private String rootpath;

    public synchronized void commit() throws ServiceAccessException {
    }

    public synchronized void connect() throws ServiceConnectionFailedException {
    }

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        String revisionUri = uri.toString();
        try {
            boolean created;
            File file = new File(String.valueOf(this.rootpath) + revisionUri);
            File parentFile = new File(file.getParent());
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (!(created = file.exists() ^ true)) {
                throw new RevisionAlreadyExistException(uri.toString(), revisionDescriptor.getRevisionNumber());
            }
            InputStream is = revisionContent.streamContent();
            if (is != null) {
                int nChar;
                FileOutputStream os = new FileOutputStream(file);
                byte[] buffer = new byte[2048];
                long position = 0L;
                long contentLength = revisionDescriptor.getContentLength();
                while ((nChar = is.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, nChar);
                    position += (long)nChar;
                }
                ((OutputStream)os).close();
                if (contentLength != -1L) {
                    if (position != contentLength) {
                        if (position < contentLength) {
                            throw new IOException("Not enough bytes read");
                        }
                        if (position > contentLength) {
                            throw new IOException("Too many bytes read");
                        }
                    }
                } else {
                    revisionDescriptor.setContentLength(position);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
    }

    public synchronized void disconnect() throws ServiceDisconnectionFailedException {
    }

    public synchronized void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        try {
            File baseDir = new File(this.rootpath);
            baseDir.mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceInitializationFailedException((Service)this, e);
        }
    }

    public boolean isConnected() throws ServiceAccessException {
        return true;
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        String revisionUri = uri.toString();
        try {
            File file = new File(String.valueOf(this.rootpath) + revisionUri);
            boolean deleted = file.delete();
            File parentFile = new File(file.getParent());
            if (parentFile != null) {
                parentFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
    }

    public void reset() throws ServiceResetFailedException {
    }

    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        NodeRevisionContent result = null;
        String revisionUri = uri.toString();
        try {
            File file = new File(String.valueOf(this.rootpath) + revisionUri);
            FileInputStream is = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader((InputStream)is, CHARACTER_ENCODING);
            result = new NodeRevisionContent();
            result.setContent((Reader)reader);
            result.setContent((InputStream)is);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
        return result;
    }

    public synchronized void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        this.rootpath = (String)parameters.get("rootpath");
        if (this.rootpath == null) {
            this.rootpath = "";
        }
    }

    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        block13: {
            String revisionUri = uri.toString();
            try {
                int nChar;
                File file = new File(String.valueOf(this.rootpath) + revisionUri);
                InputStream is = revisionContent.streamContent();
                if (is == null) break block13;
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    File parentFile = new File(file.getParent());
                    if (parentFile != null && !parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    os = new FileOutputStream(file);
                }
                byte[] buffer = new byte[2048];
                long position = 0L;
                long contentLength = revisionDescriptor.getContentLength();
                while ((nChar = is.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, nChar);
                    position += (long)nChar;
                }
                ((OutputStream)os).close();
                if (contentLength != -1L) {
                    if (position != contentLength) {
                        if (position < contentLength) {
                            throw new IOException("Not enough bytes read");
                        }
                        if (position > contentLength) {
                            throw new IOException("Too many bytes read");
                        }
                    }
                } else {
                    revisionDescriptor.setContentLength(position);
                }
                if (position < contentLength) {
                    throw new IOException("Not enough bytes read");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ServiceAccessException((Service)this, e.getMessage());
            }
        }
    }
}

