
-----------------------------------------------------------------------------
-- WEBLOG
-----------------------------------------------------------------------------
DROP TABLE WEBLOG;


CREATE TABLE WEBLOG
(
                            weblog_id integer NOT NULL,
                            owner varchar (255) NOT NULL,
                            year integer NOT NULL,
                            month integer NOT NULL,
                            Day integer NOT NULL,
                            title varchar (255) NOT NULL,
    PRIMARY KEY (weblog_id)
);


-----------------------------------------------------------------------------
-- WEBLOG_MESSAGE
-----------------------------------------------------------------------------
DROP TABLE WEBLOG_MESSAGE;


CREATE TABLE WEBLOG_MESSAGE
(
                            weblog_message_id integer NOT NULL,
                              -- REFERENCES WEBLOG (weblog_id)
    weblog_id integer NOT NULL,
                            title varchar (64) NOT NULL,
                            message bytea NOT NULL,
                            message_format_type varchar (16) NOT NULL,
                            posted_date timestamp NOT NULL,
    PRIMARY KEY (weblog_message_id)
);


-----------------------------------------------------------------------------
-- WEBLOG_COMMENT
-----------------------------------------------------------------------------
DROP TABLE WEBLOG_COMMENT;


CREATE TABLE WEBLOG_COMMENT
(
                            weblog_comment_id integer NOT NULL,
                              -- REFERENCES WEBLOG (weblog_id)
    weblog_id integer NOT NULL,
                            name varchar (255) NOT NULL,
                            mail varchar (255),
                            url varchar (255),
                            comment bytea NOT NULL,
                            posted_date timestamp NOT NULL,
                            log varchar (255),
    PRIMARY KEY (weblog_comment_id)
);


-----------------------------------------------------------------------------
-- WEBLOG_TRACKBACK
-----------------------------------------------------------------------------
DROP TABLE WEBLOG_TRACKBACK;


CREATE TABLE WEBLOG_TRACKBACK
(
                            weblog_trackback_id integer NOT NULL,
                              -- REFERENCES WEBLOG (weblog_id)
    weblog_id integer NOT NULL,
                            url varchar (255) NOT NULL,
                            name varchar (255) NOT NULL,
                            title varchar (255) NOT NULL,
                            overview bytea NOT NULL,
                            posted_date timestamp NOT NULL,
                            log varchar (255),
    PRIMARY KEY (weblog_trackback_id)
);


----------------------------------------------------------------------
-- WEBLOG_TRACKBACK                                                      
----------------------------------------------------------------------


----------------------------------------------------------------------
-- WEBLOG                                                      
----------------------------------------------------------------------

ALTER TABLE WEBLOG_MESSAGE
    ADD CONSTRAINT WEBLOG_MESSAGE_FK_1 FOREIGN KEY (weblog_id)
    REFERENCES WEBLOG (weblog_id)
;

----------------------------------------------------------------------
-- WEBLOG_MESSAGE                                                      
----------------------------------------------------------------------

ALTER TABLE WEBLOG_COMMENT
    ADD CONSTRAINT WEBLOG_COMMENT_FK_1 FOREIGN KEY (weblog_id)
    REFERENCES WEBLOG (weblog_id)
;

----------------------------------------------------------------------
-- WEBLOG_COMMENT                                                      
----------------------------------------------------------------------

ALTER TABLE WEBLOG_TRACKBACK
    ADD CONSTRAINT WEBLOG_TRACKBACK_FK_1 FOREIGN KEY (weblog_id)
    REFERENCES WEBLOG (weblog_id)
;
