/*
 * Created on 2003/10/08
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.sourceforge.jetspeedjapan.portlet.weblog.util;

import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

import jp.sourceforge.jetspeedjapan.portlet.weblog.WebLogException;
import jp.sourceforge.jetspeedjapan.portlet.weblog.WebLogManager;
import jp.sourceforge.jetspeedjapan.portlet.weblog.om.Weblog;
import jp.sourceforge.jetspeedjapan.portlet.weblog.om.WeblogPeer;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

/**
 * 
 * 
 * @author <a href="mailto:shinsuke@users.sourceforge.jp">Shinsuke Sugaya</a>
 */
public class CalendarUtil
{
    /**
     * Static initialization of the logger for this class
     */
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(CalendarUtil.class.getName());

    public static String printCalendar(WebLogManager manager)
    {
        String url = manager.getCurrentUrl();
        int thisYear = manager.getYear();
        int thisMonth = manager.getMonth();
        int thisDay = manager.getDay();

        String frameBackgroundColor = manager.getFrameBackgroundColor();
        String frameTextColor = manager.getFrameTextColor();
        String targetdayBackgroundColor = manager.getTargetdayBackgroundColor();
        String targetdayTextColor = manager.getTargetdayTextColor();
        String dayBackgroundColor = manager.getDayBackgroundColor();
        String dayTextColor = manager.getDayTextColor();
        String sundayBackgroundColor = manager.getSundayBackgroundColor();
        String sundayTextColor = manager.getSundayTextColor();
        String saturdayBackgroundColor = manager.getSaturdayBackgroundColor();
        String saturdayTextColor = manager.getSaturdayTextColor();

        //TODO: TRANSLATION
        String[] weekName = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
        // TODO: TRANSLATION
        String title = Integer.toString(thisYear) + "/" + Integer.toString(thisMonth);
        StringBuffer buf = new StringBuffer("<!-- BEGIN: printCalendar -->\n");

        // Weblog exist?
        boolean[] hasWeblog = new boolean[31];
        if (manager.getType().equals(WebLogUtil.WEBLOG_VIEW))
        {
            for (int i = 0; i < 31; i++)
            {
                hasWeblog[i] = false;
            }

            try
            {
                List list = WeblogPeer.getWeblogs(manager.getUserName(), manager.getYear(), manager.getMonth(), -1);

                if (!list.isEmpty())
                {
                    Iterator i = list.iterator();
                    while (i.hasNext())
                    {
                        Object o = i.next();
                        if (o instanceof Weblog)
                        {
                            hasWeblog[((Weblog) o).getDay() - 1] = true;
                        }
                        else
                        {
                            logger.warn("printCalendar: Object is not Weblog!");
                        }
                    }
                }
            }
            catch (WebLogException e)
            {
                for (int i = 0; i < 31; i++)
                {
                    hasWeblog[i] = true;
                }
                logger.warn("printCalendar: Cannot get Weblog data.");
            }
        }
        else
        {
            for (int i = 0; i < 31; i++)
            {
                hasWeblog[i] = true;
            }

        }

        int i, w;
        int startDay, endDay;

        int cYear = thisYear;
        int cMonth = thisMonth;
        int cDay = thisDay;

        // Set Start Day
        Calendar d1 = Calendar.getInstance();
        d1.set(cYear, cMonth - 1, 1);
        startDay = d1.get(Calendar.DAY_OF_WEEK);

        d1.set(cYear, cMonth, 0);
        endDay = d1.get(Calendar.DATE);
        buf.append(
            "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"background-color: "
                + frameBackgroundColor
                + ";\">");
        buf.append("<tr>");
        buf.append("<td>");

        // Calendar Title
        buf.append("<table border=\"0\" cellspacing=\"1\" cellpadding=\"3\"> <tr> ");
        buf.append("<th colspan=\"7\">");
        buf.append("<span style=\"color: " + frameTextColor + ";\">" + title + "</span>");
        buf.append("</th>");

        // Add User Name
        if (manager.getUserName() != null)
        {
            buf.append("</tr><tr>");
            buf.append("<th colspan=\"7\">");
            buf.append("<span style=\"color: " + frameTextColor + ";\">(" + manager.getUserName() + ")</span>");
            buf.append("</th>");
        }

        // Week Title
        buf.append("</tr><tr>");
        for (i = 0; i < 7; i++)
        {
            buf.append("<th>" + "<span style=\"color: " + frameTextColor + ";\">" + weekName[i] + "</span>" + "</th>");
        }
        buf.append("</tr><tr>");

        // Calendar Content
        for (i = 1; i < startDay; i++)
        {
            buf.append("<td style=\"background-color: " + dayBackgroundColor + ";\" >&nbsp;</td>");
        }

        for (i = 1, w = startDay; i <= endDay; i++, w++)
        {
            // End of Week
            if (w > 7)
            {
                w = 1;
                buf.append("</tr></tr>");
            }

            if (i == cDay)
            {
                // Target day
                buf.append(
                    CalendarUtil.printDayCell(
                        manager.getUserName(),
                        url,
                        thisYear,
                        thisMonth,
                        i,
                        targetdayTextColor,
                        targetdayBackgroundColor,
                        hasWeblog[i - 1]));
            }
            else
            {
                if (w == 1)
                {
                    // Sun
                    buf.append(
                        CalendarUtil.printDayCell(
                            manager.getUserName(),
                            url,
                            thisYear,
                            thisMonth,
                            i,
                            sundayTextColor,
                            sundayBackgroundColor,
                            hasWeblog[i - 1]));
                }
                else if (w == 7)
                {
                    // Sat
                    buf.append(
                        CalendarUtil.printDayCell(
                            manager.getUserName(),
                            url,
                            thisYear,
                            thisMonth,
                            i,
                            saturdayTextColor,
                            saturdayBackgroundColor,
                            hasWeblog[i - 1]));
                }
                else
                {
                    buf.append(
                        CalendarUtil.printDayCell(
                            manager.getUserName(),
                            url,
                            thisYear,
                            thisMonth,
                            i,
                            dayTextColor,
                            dayBackgroundColor,
                            hasWeblog[i - 1]));
                }
            }
        }

        for (; w <= 7; w++)
        {
            buf.append("<td style=\"background-color: " + dayBackgroundColor + ";\" >&nbsp;</td>");
        }

        buf.append("</tr></table>");

        buf.append("</td></tr></table>");

        return buf.toString();

    }

    private static String printDayCell(
        String user,
        String url,
        int year,
        int month,
        int day,
        String textColor,
        String bgColor,
        boolean link)
    {
        StringBuffer buf = new StringBuffer();

        buf.append("<td style=\"background-color: " + bgColor + ";\" > ");
        if (link)
        {
            buf.append("<a href=\"" + url + "?");
            buf.append(WebLogUtil.YEAR + "=" + year + "&");
            buf.append(WebLogUtil.MONTH + "=" + month + "&");
            buf.append(WebLogUtil.DAY + "=" + day);
            if (user != null)
            {
                buf.append("&" + WebLogUtil.USER_NAME + "=" + user);
            }
            buf.append("\">");
        }
        buf.append("<span style=\"color: " + textColor + ";\">" + day + "</span>");
        if (link)
        {
            buf.append("</a>");
        }
        buf.append("</td>");

        return buf.toString();
    }

    public static String printFormNavigation(WebLogManager manager)
    {
        String url = manager.getCurrentUrl();
        int thisYear = manager.getYear();
        int thisMonth = manager.getMonth();
        int thisDay = manager.getDay();

        StringBuffer buf = new StringBuffer("<!-- BEGIN: printFormNavigation -->\n");

        buf.append("<form action=\"" + url + "\">");
        if (manager.getUserName() != null)
        {
            buf.append(
                "<input type=\"hidden\" name=\""
                    + WebLogUtil.USER_NAME
                    + "\" value=\""
                    + manager.getUserName()
                    + "\"/>");
        }
        buf.append("<table border=\"0\" width=\"100%\"><tr><td align=\"center\">");
        buf.append("<table border=\"0\"><tr><td align=\"center\">");

        buf.append("<select name=\"" + WebLogUtil.YEAR + "\">");
        for (int i = thisYear - 4; i < thisYear + 5; i++)
        {
            buf.append("<option value=\"" + i + "\"");
            if (i == thisYear)
            {
                buf.append(" selected");
            }
            buf.append(">" + i + "</option>");
        }
        buf.append("</select>");
        buf.append("</td><td align=\"center\">");
        buf.append("/");
        buf.append("</td><td align=\"center\">");
        buf.append("<select name=\"" + WebLogUtil.MONTH + "\">");
        for (int i = 1; i < 13; i++)
        {
            buf.append("<option value=\"" + i + "\"");
            if (i == thisMonth)
            {
                buf.append(" selected");
            }
            buf.append(">" + i + "</option>");
        }
        buf.append("</select>");
        buf.append("</td><td align=\"center\">");
        buf.append("/");
        buf.append("</td><td align=\"center\">");
        buf.append("<select name=\"" + WebLogUtil.DAY + "\">");
        for (int i = 1; i < 32; i++)
        {
            buf.append("<option value=\"" + i + "\"");
            if (i == thisDay)
            {
                buf.append(" selected");
            }
            buf.append(">" + i + "</option>");
        }
        buf.append("</select>");
        buf.append("</td><td align=\"center\">");
        buf.append("<input type=\"hidden\" name=\"" + WebLogUtil.DAY + "\" ");
        buf.append("value=\"" + thisDay + "\" />");
        //TODO: TRANSLATION
        buf.append("<input type=\"submit\" value=\"Go\" />");

        buf.append("</td></tr></table>");
        buf.append("</td></tr></table>");
        buf.append("</form>");

        return buf.toString();
    }

    public static String printTextMonthNavigation(WebLogManager manager)
    {
        String url = manager.getCurrentUrl();
        int thisYear = manager.getYear();
        int thisMonth = manager.getMonth();
        int thisDay = manager.getDay();

        int prevYear = thisYear;
        int prevMonth = thisMonth - 1;
        if (prevMonth == 0)
        {
            prevYear--;
            prevMonth = 12;
        }

        int nextYear = thisYear;
        int nextMonth = thisMonth + 1;
        if (nextMonth == 13)
        {
            nextYear++;
            nextMonth = 1;
        }

        StringBuffer buf = new StringBuffer("<!-- BEGIN: printTextMonthNavigation -->\n");

        buf.append("<table border=\"0\" width=\"100%\"><tr><td align=\"left\">");

        buf.append("<a href=\"" + url + "?");
        buf.append(WebLogUtil.YEAR + "=" + prevYear + "&");
        buf.append(WebLogUtil.MONTH + "=" + prevMonth + "&");
        buf.append(WebLogUtil.DAY + "=" + thisDay);
        if (manager.getUserName() != null)
        {
            buf.append("&" + WebLogUtil.USER_NAME + "=" + manager.getUserName());
        }
        //TODO: TRANSLATION
        buf.append("\">&lt;&lt; Previous Month</a>");

        buf.append("</td><td align=\"right\">");

        buf.append("<a href=\"" + url + "?");
        buf.append(WebLogUtil.YEAR + "=" + nextYear + "&");
        buf.append(WebLogUtil.MONTH + "=" + nextMonth + "&");
        buf.append(WebLogUtil.DAY + "=" + thisDay);
        if (manager.getUserName() != null)
        {
            buf.append("&" + WebLogUtil.USER_NAME + "=" + manager.getUserName());
        }
        //TODO: TRANSLATION
        buf.append("\">Next Month&gt;&gt;</a>");

        buf.append("</td></tr></table>");

        return buf.toString();
    }

    public static String printTextDateNavigation(WebLogManager manager)
    {
        String url = manager.getCurrentUrl();
        int thisYear = manager.getYear();
        int thisMonth = manager.getMonth();
        int thisDay = manager.getDay();

        StringBuffer buf = new StringBuffer("<!-- BEGIN: printTextDateNavigation -->\n");

        Calendar cal = Calendar.getInstance();
        int year = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH) + 1;
        int day = cal.get(Calendar.DAY_OF_MONTH);

        buf.append("<table border=\"0\" width=\"100%\"><tr><td align=\"left\">");

        buf.append("<a href=\"" + url + "?");
        buf.append(WebLogUtil.YEAR + "=" + thisYear + "&");
        buf.append(WebLogUtil.MONTH + "=" + thisMonth + "&");
        buf.append(WebLogUtil.DAY + "=" + (thisDay - 1));
        if (manager.getUserName() != null)
        {
            buf.append("&" + WebLogUtil.USER_NAME + "=" + manager.getUserName());
        }
        //TODO: TRANSLATION
        buf.append("\">&lt;&lt; Previous Day</a>");
        buf.append("</td><td align=\"center\">");

        buf.append("&nbsp;");
        if (thisYear != year || thisMonth != month || thisDay != day)
        {
            buf.append("<a href=\"" + url + "?");
            buf.append(WebLogUtil.YEAR + "=" + year + "&");
            buf.append(WebLogUtil.MONTH + "=" + month + "&");
            buf.append(WebLogUtil.DAY + "=" + day);
            if (manager.getUserName() != null)
            {
                buf.append("&" + WebLogUtil.USER_NAME + "=" + manager.getUserName());
            }
            //TODO: TRANSLATION
            buf.append("\">Today</a>");
        }
        buf.append("&nbsp;");
        buf.append("</td><td align=\"right\">");

        buf.append("<a href=\"" + url + "?");
        buf.append(WebLogUtil.YEAR + "=" + thisYear + "&");
        buf.append(WebLogUtil.MONTH + "=" + thisMonth + "&");
        buf.append(WebLogUtil.DAY + "=" + (thisDay + 1));
        if (manager.getUserName() != null)
        {
            buf.append("&" + WebLogUtil.USER_NAME + "=" + manager.getUserName());
        }
        //TODO: TRANSLATION
        buf.append("\">Next Day &gt;&gt;</a>");
        buf.append("</td></tr></table>");

        return buf.toString();

    }

}
