package jp.sourceforge.jetspeedjapan.portlet.weblog.modules.actions.portlets;

/* ====================================================================================
 * Copyright (c) 2003, jetspeed-japan.sourceforge.jp
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright notice,
 *     * this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *     * notice, this list of conditions and the following disclaimer in the
 *     * documentation and/or other materials provided with the distribution.
 *     * Neither the name of the jetspeed-japan.sourceforge.jp nor the names 
 *       of its contributors
 *     * may be used to endorse or promote products derived from this software
 *     * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================================
 */

import org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.PortletConfigState;

import org.apache.turbine.util.RunData;

// Velocity Stuff
import org.apache.velocity.app.FieldMethodizer;
import org.apache.velocity.context.Context;

import jp.sourceforge.jetspeedjapan.portlet.weblog.WebLogManager;
import jp.sourceforge.jetspeedjapan.portlet.weblog.util.WebLogUtil;

/**
 * Portlet action class is to view the Web Log Calendar.
 * 
 * @author <a href="mailto:shinsuke@users.sourceforge.jp">Shinsuke Sugaya</a>
 */
public class WebLogCalendarPortletAction extends VelocityPortletAction
{
    /**
     * Static initialization of the logger for this class
     */
    private static final JetspeedLogger logger =
        JetspeedLogFactoryService.getLogger(WebLogViewerPortletAction.class.getName());

    /** 
     * Default behavior when maximized context.
     */
    //    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata)
    //    {
    ////        buildNormalContext(portlet, context, rundata);
    //    }

    /** 
     * Default is to use Portal base customizer action
     */
    protected void buildConfigureContext(VelocityPortlet portlet, Context context, RunData rundata)
    {
        //        buildNormalContext(portlet, context, rundata);
    }

    /** 
     * Default behavior for the portlet action
     */
    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata)
    {
        if (rundata.getRequest().getAttribute(WebLogUtil.WEBLOG_CALENDAR) == null)
        {
            WebLogManager manager = setup(context, rundata, WebLogUtil.CALENDAR_TEMPLATE);
            manager.putCalendar();
            manager.putCalendarHeader();
            manager.putCalendarFooter();
            manager.putDate();
            manager.putInfo();
        }
    }

    /**
     * Create the controller for this portlet.
     * 
     * @param context
     * @param rundata
     * @param template
     * @return
     */
    private WebLogManager setup(Context context, RunData rundata, String template)
    {
        if (rundata.getRequest().getAttribute(WebLogUtil.WEBLOG_CALENDAR) == null)
        {
            // Set template
            setTemplate(rundata, template);

            context.put(WebLogUtil.WEBLOGUTIL, new FieldMethodizer(new WebLogUtil()));

            VelocityPortlet portlet = (VelocityPortlet) context.get("portlet");

            WebLogManager manager =
                new WebLogManager(
                    context,
                    rundata,
                    rundata.getParameters().getString(
                        WebLogUtil.USER_NAME,
                        PortletConfigState.getParameter(portlet, rundata, WebLogUtil.USER_NAME, null)));
            manager.setType(
                (String) portlet.getPortletConfig().getInitParameter(WebLogUtil.WEBLOG_TYPE, WebLogUtil.WEBLOG_EDIT));
            rundata.getRequest().setAttribute(WebLogUtil.WEBLOG_MANAGER, manager);
            return manager;
        }
        else
        {
            return (WebLogManager) rundata.getRequest().getAttribute(WebLogUtil.WEBLOG_CALENDAR);
        }
    }
}
