package jp.sourceforge.jetspeedjapan.portlet.weblog.om;

/* ====================================================================================
 * Copyright (c) 2003, jetspeed-japan.sourceforge.jp
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright notice,
 *     * this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *     * notice, this list of conditions and the following disclaimer in the
 *     * documentation and/or other materials provided with the distribution.
 *     * Neither the name of the jetspeed-japan.sourceforge.jp nor the names 
 *       of its contributors
 *     * may be used to endorse or promote products derived from this software
 *     * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================================
 */

import java.text.DateFormat;
import java.util.Locale;

import org.apache.commons.lang.StringUtils;
import org.apache.torque.om.Persistent;

import jp.sourceforge.jetspeedjapan.portlet.weblog.util.WebLogUtil;

/**
 * This class is the Object Model for Web Log Message in Database.
 * 
 * @author <a href="mailto:shinsuke@users.sourceforge.jp">Shinsuke Sugaya</a>
 */
public class WeblogMessage extends jp.sourceforge.jetspeedjapan.portlet.weblog.om.BaseWeblogMessage implements Persistent
{
    /**
     * Returns the formatted posted date.
     * 
     * @return  Formatted posted date
     */
    public String getFormattedPostedDate(Locale lc)
    {
        DateFormat df = DateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.LONG, lc);
        return df.format(getPostedDate());
    }

    /**
     * Returns the title formatted by the format type.
     * 
     * @return  Formatted title
     */
    public String getFormattedTitle()
    {

        if (getMessageFormatType().equals(WebLogUtil.HTML))
        {
            // HTML
            String title = WebLogUtil.decodeForDatabase(getTitle());

            return title;
        }
        else
        {
            // PLAIN - Default
            String title = getTitle();

            return title;
        }
    }

    /**
     * Returns the message formatted by the format type.
     * 
     * @return  Formatted message
     */
    public String getFormattedMessage()
    {
        if (getMessageFormatType().equals(WebLogUtil.HTML))
        {
            // HTML
            String msg = WebLogUtil.decodeForDatabase(getMessage());

            return msg;
        }
        else
        {
            // PLAIN - Default
            String msg = getMessage();

            msg = StringUtils.replace(msg, "\n", "<br />");

            return msg;
        }
    }
}
