package jp.sourceforge.jetspeedjapan.portlet.weblog.om;


import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;

   
   
/**
 * This class was autogenerated by Torque on:
 *
 * [Mon Aug 11 00:36:14 JST 2003]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to WeblogComment
 */
public abstract class BaseWeblogComment extends BaseObject
{
    /** The Peer class */
    private static final WeblogCommentPeer peer =
        new WeblogCommentPeer();

                  
        /**
         * The value for the weblog_comment_id field
         */
        private int weblog_comment_id;
              
        /**
         * The value for the weblog_id field
         */
        private int weblog_id;
              
        /**
         * The value for the name field
         */
        private String name;
              
        /**
         * The value for the mail field
         */
        private String mail;
              
        /**
         * The value for the url field
         */
        private String url;
              
        /**
         * The value for the comment field
         */
        private String comment;
              
        /**
         * The value for the posted_date field
         */
        private Date posted_date;
              
        /**
         * The value for the log field
         */
        private String log;
      
      
        /**
         * Get the WeblogCommentId
         *
         * @return int
         */
        public int getWeblogCommentId()
        {
            return weblog_comment_id;
        }

                                            
        /**
         * Set the value of WeblogCommentId
         *
         * @param v new value
         */
        public void setWeblogCommentId(int v) 
        {
          


         if (this.weblog_comment_id != v)
        {
             this.weblog_comment_id = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the WeblogId
         *
         * @return int
         */
        public int getWeblogId()
        {
            return weblog_id;
        }

                                                      
        /**
         * Set the value of WeblogId
         *
         * @param v new value
         */
        public void setWeblogId(int v) throws TorqueException
        {
          


         if (this.weblog_id != v)
        {
             this.weblog_id = v;
            setModified(true);
        }

                                          
                if (aWeblog != null && !(aWeblog.getWeblogId()==v))
                {
            aWeblog = null;
        }
          
                       }


        /**
         * Get the Name
         *
         * @return String
         */
        public String getName()
        {
            return name;
        }

                                            
        /**
         * Set the value of Name
         *
         * @param v new value
         */
        public void setName(String v) 
        {
          


         if (!ObjectUtils.equals(this.name, v))
        {
             this.name = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the Mail
         *
         * @return String
         */
        public String getMail()
        {
            return mail;
        }

                                            
        /**
         * Set the value of Mail
         *
         * @param v new value
         */
        public void setMail(String v) 
        {
          


         if (!ObjectUtils.equals(this.mail, v))
        {
             this.mail = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the Url
         *
         * @return String
         */
        public String getUrl()
        {
            return url;
        }

                                            
        /**
         * Set the value of Url
         *
         * @param v new value
         */
        public void setUrl(String v) 
        {
          


         if (!ObjectUtils.equals(this.url, v))
        {
             this.url = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the Comment
         *
         * @return String
         */
        public String getComment()
        {
            return comment;
        }

                                            
        /**
         * Set the value of Comment
         *
         * @param v new value
         */
        public void setComment(String v) 
        {
          


         if (!ObjectUtils.equals(this.comment, v))
        {
             this.comment = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the PostedDate
         *
         * @return Date
         */
        public Date getPostedDate()
        {
            return posted_date;
        }

                                            
        /**
         * Set the value of PostedDate
         *
         * @param v new value
         */
        public void setPostedDate(Date v) 
        {
          


         if (!ObjectUtils.equals(this.posted_date, v))
        {
             this.posted_date = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the Log
         *
         * @return String
         */
        public String getLog()
        {
            return log;
        }

                                            
        /**
         * Set the value of Log
         *
         * @param v new value
         */
        public void setLog(String v) 
        {
          


         if (!ObjectUtils.equals(this.log, v))
        {
             this.log = v;
            setModified(true);
        }

                  
                       }


 
     
   
             
   
       private Weblog aWeblog;

    /**
     * Declares an association between this object and a Weblog object
     *
     * @param v Weblog
     * @throws TorqueException
     */
    public void setWeblog(Weblog v) throws TorqueException
    {
           if (v == null)
        {
                        setWeblogId(0);
                    }
        else
        {
            setWeblogId(v.getWeblogId());
        }
           aWeblog = v;
    }

                 
    /**
     * Get the associated Weblog object
     *
     * @return the associated Weblog object
     * @throws TorqueException
     */
    public Weblog getWeblog() throws TorqueException
    {
        if (aWeblog == null && (this.weblog_id > 0))
        {
              aWeblog = WeblogPeer.retrieveByPK(SimpleKey.keyFor(this.weblog_id));
      
            /* The following can be used instead of the line above to
               guarantee the related object contains a reference
               to this object, but this level of coupling
               may be undesirable in many circumstances.
               As it can lead to a db query with many results that may
               never be used.
               Weblog obj = WeblogPeer.retrieveByPK(this.weblog_id);
               obj.addWeblogComments(this);
             */
        }
        return aWeblog;
    }

    /**
     * Provides convenient way to set a relationship based on a
     * ObjectKey.  e.g.
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
     */
    public void setWeblogKey(ObjectKey key) throws TorqueException
    {
    
                                        setWeblogId(((NumberKey) key).intValue());
                    }
    
        
    
    private static List fieldNames = null;

    /**
     * Generate a list of field names.
     *
     * @return a list of field names
     */
    public static synchronized List getFieldNames()
    {
      if (fieldNames == null)
      {
        fieldNames = new ArrayList();
            fieldNames.add("WeblogCommentId");
            fieldNames.add("WeblogId");
            fieldNames.add("Name");
            fieldNames.add("Mail");
            fieldNames.add("Url");
            fieldNames.add("Comment");
            fieldNames.add("PostedDate");
            fieldNames.add("Log");
            fieldNames = Collections.unmodifiableList(fieldNames);
      }
      return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in as a String.
     *
     * @param name field name
     * @return value
     */
    public Object getByName(String name)
    {
            if (name.equals("WeblogCommentId"))
    {
              return new Integer(getWeblogCommentId());
          }
            if (name.equals("WeblogId"))
    {
              return new Integer(getWeblogId());
          }
            if (name.equals("Name"))
    {
              return getName();
          }
            if (name.equals("Mail"))
    {
              return getMail();
          }
            if (name.equals("Url"))
    {
              return getUrl();
          }
            if (name.equals("Comment"))
    {
              return getComment();
          }
            if (name.equals("PostedDate"))
    {
              return getPostedDate();
          }
            if (name.equals("Log"))
    {
              return getLog();
          }
            return null;
    }
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     *
     * @param name peer name
     * @return value
     */
    public Object getByPeerName(String name)
    {
            if (name.equals(WeblogCommentPeer.WEBLOG_COMMENT_ID))
        {
              return new Integer(getWeblogCommentId());
          }
            if (name.equals(WeblogCommentPeer.WEBLOG_ID))
        {
              return new Integer(getWeblogId());
          }
            if (name.equals(WeblogCommentPeer.NAME))
        {
              return getName();
          }
            if (name.equals(WeblogCommentPeer.MAIL))
        {
              return getMail();
          }
            if (name.equals(WeblogCommentPeer.URL))
        {
              return getUrl();
          }
            if (name.equals(WeblogCommentPeer.COMMENT))
        {
              return getComment();
          }
            if (name.equals(WeblogCommentPeer.POSTED_DATE))
        {
              return getPostedDate();
          }
            if (name.equals(WeblogCommentPeer.LOG))
        {
              return getLog();
          }
            return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     *
     * @param pos position in xml schema
     * @return value
     */
    public Object getByPosition(int pos)
    {
            if (pos == 0)
    {
              return new Integer(getWeblogCommentId());
          }
            if (pos == 1)
    {
              return new Integer(getWeblogId());
          }
            if (pos == 2)
    {
              return getName();
          }
            if (pos == 3)
    {
              return getMail();
          }
            if (pos == 4)
    {
              return getUrl();
          }
            if (pos == 5)
    {
              return getComment();
          }
            if (pos == 6)
    {
              return getPostedDate();
          }
            if (pos == 7)
    {
              return getLog();
          }
                return null;
    }

     


    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     *
     * @throws Exception
     */
    public void save() throws Exception
    {
             save(WeblogCommentPeer.getMapBuilder()
                .getDatabaseMap().getName());
     }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
     *
     * @param dbName
     * @throws TorqueException
     */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
         try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }

     }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     *
     * @param con
     * @throws TorqueException
     */
    public void save(Connection con) throws TorqueException
    {
        if (!alreadyInSave)
      {
        alreadyInSave = true;



  
        // If this object has been modified, then save it to the database.
        if (isModified())
        {
            if (isNew())
            {
                WeblogCommentPeer.doInsert((WeblogComment) this, con);
                setNew(false);
            }
            else
            {
                WeblogCommentPeer.doUpdate((WeblogComment) this, con);
            }
        }

              alreadyInSave = false;
      }
      }


                
    
    

        /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param  weblog_comment_id ObjectKey
     */
    public void setPrimaryKey(ObjectKey key)
        
    {
                    setWeblogCommentId(((NumberKey) key).intValue());
            }

    /**
     * Set the PrimaryKey using a String.
     *
     * @param key
     */
    public void setPrimaryKey(String key) 
    {
                    setWeblogCommentId(Integer.parseInt(key));
            }


    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
        return SimpleKey.keyFor(getWeblogCommentId());
    }

 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     */
    public WeblogComment copy() throws TorqueException
    {
        return copyInto(new WeblogComment());
    }

    protected WeblogComment copyInto(WeblogComment copyObj) throws TorqueException
    {
        copyObj.setWeblogCommentId(weblog_comment_id);
        copyObj.setWeblogId(weblog_id);
        copyObj.setName(name);
        copyObj.setMail(mail);
        copyObj.setUrl(url);
        copyObj.setComment(comment);
        copyObj.setPostedDate(posted_date);
        copyObj.setLog(log);

                      copyObj.setWeblogCommentId(0);
                                        

  
        return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public WeblogCommentPeer getPeer()
    {
        return peer;
    }
}
