package jp.sourceforge.jetspeedjapan.portlet.weblog.om;


import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;


/**
 * This class was autogenerated by Torque on:
 *
 * [Mon Aug 11 00:36:14 JST 2003]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to Weblog
 */
public abstract class BaseWeblog extends BaseObject
{
    /** The Peer class */
    private static final WeblogPeer peer =
        new WeblogPeer();

                  
        /**
         * The value for the weblog_id field
         */
        private int weblog_id;
              
        /**
         * The value for the owner field
         */
        private String owner;
              
        /**
         * The value for the year field
         */
        private int year;
              
        /**
         * The value for the month field
         */
        private int month;
              
        /**
         * The value for the day field
         */
        private int day;
              
        /**
         * The value for the title field
         */
        private String title;
      
      
        /**
         * Get the WeblogId
         *
         * @return int
         */
        public int getWeblogId()
        {
            return weblog_id;
        }

                                                                              
        /**
         * Set the value of WeblogId
         *
         * @param v new value
         */
        public void setWeblogId(int v) throws TorqueException
        {
          


         if (this.weblog_id != v)
        {
             this.weblog_id = v;
            setModified(true);
        }

                  
                                                  
              // update associated WeblogMessage
              if (collWeblogMessages != null)
              {
                  for (int i = 0; i < collWeblogMessages.size(); i++)
                  {
                      ((WeblogMessage) collWeblogMessages.get(i))
                          .setWeblogId(v);
                  }
              }
                                                              
              // update associated WeblogComment
              if (collWeblogComments != null)
              {
                  for (int i = 0; i < collWeblogComments.size(); i++)
                  {
                      ((WeblogComment) collWeblogComments.get(i))
                          .setWeblogId(v);
                  }
              }
                                                              
              // update associated WeblogTrackback
              if (collWeblogTrackbacks != null)
              {
                  for (int i = 0; i < collWeblogTrackbacks.size(); i++)
                  {
                      ((WeblogTrackback) collWeblogTrackbacks.get(i))
                          .setWeblogId(v);
                  }
              }
                                   }


        /**
         * Get the Owner
         *
         * @return String
         */
        public String getOwner()
        {
            return owner;
        }

                                            
        /**
         * Set the value of Owner
         *
         * @param v new value
         */
        public void setOwner(String v) 
        {
          


         if (!ObjectUtils.equals(this.owner, v))
        {
             this.owner = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the Year
         *
         * @return int
         */
        public int getYear()
        {
            return year;
        }

                                            
        /**
         * Set the value of Year
         *
         * @param v new value
         */
        public void setYear(int v) 
        {
          


         if (this.year != v)
        {
             this.year = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the Month
         *
         * @return int
         */
        public int getMonth()
        {
            return month;
        }

                                            
        /**
         * Set the value of Month
         *
         * @param v new value
         */
        public void setMonth(int v) 
        {
          


         if (this.month != v)
        {
             this.month = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the Day
         *
         * @return int
         */
        public int getDay()
        {
            return day;
        }

                                            
        /**
         * Set the value of Day
         *
         * @param v new value
         */
        public void setDay(int v) 
        {
          


         if (this.day != v)
        {
             this.day = v;
            setModified(true);
        }

                  
                       }


        /**
         * Get the Title
         *
         * @return String
         */
        public String getTitle()
        {
            return title;
        }

                                            
        /**
         * Set the value of Title
         *
         * @param v new value
         */
        public void setTitle(String v) 
        {
          


         if (!ObjectUtils.equals(this.title, v))
        {
             this.title = v;
            setModified(true);
        }

                  
                       }


 
        
                
      
    /**
     * Collection to store aggregation of collWeblogMessages
     */
    protected List collWeblogMessages;

    /**
     * Temporary storage of collWeblogMessages to save a possible db hit in
     * the event objects are add to the collection, but the
     * complete collection is never requested.
     */
    protected void initWeblogMessages()
    {
        if (collWeblogMessages == null)
        {
            collWeblogMessages = new ArrayList();
        }
    }

    /**
     * Method called to associate a WeblogMessage object to this object
     * through the WeblogMessage foreign key attribute
     *
     * @param l WeblogMessage
     * @throws TorqueException
     */
    public void addWeblogMessage(WeblogMessage l) throws TorqueException
    {
        getWeblogMessages().add(l);
        l.setWeblog((Weblog) this);
    }

    /**
     * The criteria used to select the current contents of collWeblogMessages
     */
    private Criteria lastWeblogMessagesCriteria = null;

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getWeblogMessages(new Criteria())
     *
     * @throws TorqueException
     */
    public List getWeblogMessages() throws TorqueException
    {
        if (collWeblogMessages == null)
        {
            collWeblogMessages = getWeblogMessages(new Criteria(10));
        }
        return collWeblogMessages;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Weblog has previously
     * been saved, it will retrieve related WeblogMessages from storage.
     * If this Weblog is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     *
     * @throws TorqueException
     */
    public List getWeblogMessages(Criteria criteria) throws TorqueException
    {
        if (collWeblogMessages == null)
        {
            if (isNew())
            {
               collWeblogMessages = new ArrayList();
            }
            else
            {
                   criteria.add(WeblogMessagePeer.WEBLOG_ID, getWeblogId() );
                   collWeblogMessages = WeblogMessagePeer.doSelect(criteria);
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                   criteria.add(WeblogMessagePeer.WEBLOG_ID, getWeblogId());
                   if (!lastWeblogMessagesCriteria.equals(criteria))
                {
                    collWeblogMessages = WeblogMessagePeer.doSelect(criteria);
                }
            }
        }
        lastWeblogMessagesCriteria = criteria;

        return collWeblogMessages;
    }

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getWeblogMessages(new Criteria(),Connection)
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List getWeblogMessages(Connection con) throws TorqueException
    {
        if (collWeblogMessages == null)
        {
            collWeblogMessages = getWeblogMessages(new Criteria(10), con);
        }
        return collWeblogMessages;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Weblog has previously
     * been saved, it will retrieve related WeblogMessages from storage.
     * If this Weblog is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List getWeblogMessages(Criteria criteria, Connection con)
            throws TorqueException
    {
        if (collWeblogMessages == null)
        {
            if (isNew())
            {
               collWeblogMessages = new ArrayList();
            }
            else
            {
                     criteria.add(WeblogMessagePeer.WEBLOG_ID, getWeblogId());
                     collWeblogMessages = WeblogMessagePeer.doSelect(criteria, con);
             }
         }
         else
         {
             // criteria has no effect for a new object
             if (!isNew())
             {
                 // the following code is to determine if a new query is
                 // called for.  If the criteria is the same as the last
                 // one, just return the collection.
                     criteria.add(WeblogMessagePeer.WEBLOG_ID, getWeblogId());
                     if (!lastWeblogMessagesCriteria.equals(criteria))
                 {
                     collWeblogMessages = WeblogMessagePeer.doSelect(criteria, con);
                 }
             }
         }
         lastWeblogMessagesCriteria = criteria;

         return collWeblogMessages;
     }

   

     
      
         
          
                            
                
        
        
   
    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Weblog is new, it will return
     * an empty collection; or if this Weblog has previously
     * been saved, it will retrieve related WeblogMessages from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Weblog.
     */
    protected List getWeblogMessagesJoinWeblog(Criteria criteria)
        throws TorqueException
    {
        if (collWeblogMessages == null)
        {
            if (isNew())
            {
               collWeblogMessages = new ArrayList();
            }
            else
            {
                   criteria.add(WeblogMessagePeer.WEBLOG_ID, getWeblogId());
                   collWeblogMessages = WeblogMessagePeer.doSelectJoinWeblog(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
            boolean newCriteria = true;
                   criteria.add(WeblogMessagePeer.WEBLOG_ID, getWeblogId());
               if (!lastWeblogMessagesCriteria.equals(criteria))
            {
                collWeblogMessages = WeblogMessagePeer.doSelectJoinWeblog(criteria);
            }
        }
        lastWeblogMessagesCriteria = criteria;

        return collWeblogMessages;
    }
     



             
      
    /**
     * Collection to store aggregation of collWeblogComments
     */
    protected List collWeblogComments;

    /**
     * Temporary storage of collWeblogComments to save a possible db hit in
     * the event objects are add to the collection, but the
     * complete collection is never requested.
     */
    protected void initWeblogComments()
    {
        if (collWeblogComments == null)
        {
            collWeblogComments = new ArrayList();
        }
    }

    /**
     * Method called to associate a WeblogComment object to this object
     * through the WeblogComment foreign key attribute
     *
     * @param l WeblogComment
     * @throws TorqueException
     */
    public void addWeblogComment(WeblogComment l) throws TorqueException
    {
        getWeblogComments().add(l);
        l.setWeblog((Weblog) this);
    }

    /**
     * The criteria used to select the current contents of collWeblogComments
     */
    private Criteria lastWeblogCommentsCriteria = null;

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getWeblogComments(new Criteria())
     *
     * @throws TorqueException
     */
    public List getWeblogComments() throws TorqueException
    {
        if (collWeblogComments == null)
        {
            collWeblogComments = getWeblogComments(new Criteria(10));
        }
        return collWeblogComments;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Weblog has previously
     * been saved, it will retrieve related WeblogComments from storage.
     * If this Weblog is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     *
     * @throws TorqueException
     */
    public List getWeblogComments(Criteria criteria) throws TorqueException
    {
        if (collWeblogComments == null)
        {
            if (isNew())
            {
               collWeblogComments = new ArrayList();
            }
            else
            {
                   criteria.add(WeblogCommentPeer.WEBLOG_ID, getWeblogId() );
                   collWeblogComments = WeblogCommentPeer.doSelect(criteria);
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                   criteria.add(WeblogCommentPeer.WEBLOG_ID, getWeblogId());
                   if (!lastWeblogCommentsCriteria.equals(criteria))
                {
                    collWeblogComments = WeblogCommentPeer.doSelect(criteria);
                }
            }
        }
        lastWeblogCommentsCriteria = criteria;

        return collWeblogComments;
    }

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getWeblogComments(new Criteria(),Connection)
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List getWeblogComments(Connection con) throws TorqueException
    {
        if (collWeblogComments == null)
        {
            collWeblogComments = getWeblogComments(new Criteria(10), con);
        }
        return collWeblogComments;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Weblog has previously
     * been saved, it will retrieve related WeblogComments from storage.
     * If this Weblog is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List getWeblogComments(Criteria criteria, Connection con)
            throws TorqueException
    {
        if (collWeblogComments == null)
        {
            if (isNew())
            {
               collWeblogComments = new ArrayList();
            }
            else
            {
                     criteria.add(WeblogCommentPeer.WEBLOG_ID, getWeblogId());
                     collWeblogComments = WeblogCommentPeer.doSelect(criteria, con);
             }
         }
         else
         {
             // criteria has no effect for a new object
             if (!isNew())
             {
                 // the following code is to determine if a new query is
                 // called for.  If the criteria is the same as the last
                 // one, just return the collection.
                     criteria.add(WeblogCommentPeer.WEBLOG_ID, getWeblogId());
                     if (!lastWeblogCommentsCriteria.equals(criteria))
                 {
                     collWeblogComments = WeblogCommentPeer.doSelect(criteria, con);
                 }
             }
         }
         lastWeblogCommentsCriteria = criteria;

         return collWeblogComments;
     }

   

     
      
         
          
                            
                
        
        
   
    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Weblog is new, it will return
     * an empty collection; or if this Weblog has previously
     * been saved, it will retrieve related WeblogComments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Weblog.
     */
    protected List getWeblogCommentsJoinWeblog(Criteria criteria)
        throws TorqueException
    {
        if (collWeblogComments == null)
        {
            if (isNew())
            {
               collWeblogComments = new ArrayList();
            }
            else
            {
                   criteria.add(WeblogCommentPeer.WEBLOG_ID, getWeblogId());
                   collWeblogComments = WeblogCommentPeer.doSelectJoinWeblog(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
            boolean newCriteria = true;
                   criteria.add(WeblogCommentPeer.WEBLOG_ID, getWeblogId());
               if (!lastWeblogCommentsCriteria.equals(criteria))
            {
                collWeblogComments = WeblogCommentPeer.doSelectJoinWeblog(criteria);
            }
        }
        lastWeblogCommentsCriteria = criteria;

        return collWeblogComments;
    }
     



             
      
    /**
     * Collection to store aggregation of collWeblogTrackbacks
     */
    protected List collWeblogTrackbacks;

    /**
     * Temporary storage of collWeblogTrackbacks to save a possible db hit in
     * the event objects are add to the collection, but the
     * complete collection is never requested.
     */
    protected void initWeblogTrackbacks()
    {
        if (collWeblogTrackbacks == null)
        {
            collWeblogTrackbacks = new ArrayList();
        }
    }

    /**
     * Method called to associate a WeblogTrackback object to this object
     * through the WeblogTrackback foreign key attribute
     *
     * @param l WeblogTrackback
     * @throws TorqueException
     */
    public void addWeblogTrackback(WeblogTrackback l) throws TorqueException
    {
        getWeblogTrackbacks().add(l);
        l.setWeblog((Weblog) this);
    }

    /**
     * The criteria used to select the current contents of collWeblogTrackbacks
     */
    private Criteria lastWeblogTrackbacksCriteria = null;

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getWeblogTrackbacks(new Criteria())
     *
     * @throws TorqueException
     */
    public List getWeblogTrackbacks() throws TorqueException
    {
        if (collWeblogTrackbacks == null)
        {
            collWeblogTrackbacks = getWeblogTrackbacks(new Criteria(10));
        }
        return collWeblogTrackbacks;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Weblog has previously
     * been saved, it will retrieve related WeblogTrackbacks from storage.
     * If this Weblog is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     *
     * @throws TorqueException
     */
    public List getWeblogTrackbacks(Criteria criteria) throws TorqueException
    {
        if (collWeblogTrackbacks == null)
        {
            if (isNew())
            {
               collWeblogTrackbacks = new ArrayList();
            }
            else
            {
                   criteria.add(WeblogTrackbackPeer.WEBLOG_ID, getWeblogId() );
                   collWeblogTrackbacks = WeblogTrackbackPeer.doSelect(criteria);
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                   criteria.add(WeblogTrackbackPeer.WEBLOG_ID, getWeblogId());
                   if (!lastWeblogTrackbacksCriteria.equals(criteria))
                {
                    collWeblogTrackbacks = WeblogTrackbackPeer.doSelect(criteria);
                }
            }
        }
        lastWeblogTrackbacksCriteria = criteria;

        return collWeblogTrackbacks;
    }

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getWeblogTrackbacks(new Criteria(),Connection)
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List getWeblogTrackbacks(Connection con) throws TorqueException
    {
        if (collWeblogTrackbacks == null)
        {
            collWeblogTrackbacks = getWeblogTrackbacks(new Criteria(10), con);
        }
        return collWeblogTrackbacks;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Weblog has previously
     * been saved, it will retrieve related WeblogTrackbacks from storage.
     * If this Weblog is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List getWeblogTrackbacks(Criteria criteria, Connection con)
            throws TorqueException
    {
        if (collWeblogTrackbacks == null)
        {
            if (isNew())
            {
               collWeblogTrackbacks = new ArrayList();
            }
            else
            {
                     criteria.add(WeblogTrackbackPeer.WEBLOG_ID, getWeblogId());
                     collWeblogTrackbacks = WeblogTrackbackPeer.doSelect(criteria, con);
             }
         }
         else
         {
             // criteria has no effect for a new object
             if (!isNew())
             {
                 // the following code is to determine if a new query is
                 // called for.  If the criteria is the same as the last
                 // one, just return the collection.
                     criteria.add(WeblogTrackbackPeer.WEBLOG_ID, getWeblogId());
                     if (!lastWeblogTrackbacksCriteria.equals(criteria))
                 {
                     collWeblogTrackbacks = WeblogTrackbackPeer.doSelect(criteria, con);
                 }
             }
         }
         lastWeblogTrackbacksCriteria = criteria;

         return collWeblogTrackbacks;
     }

   

     
      
         
          
                            
                
        
        
   
    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Weblog is new, it will return
     * an empty collection; or if this Weblog has previously
     * been saved, it will retrieve related WeblogTrackbacks from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Weblog.
     */
    protected List getWeblogTrackbacksJoinWeblog(Criteria criteria)
        throws TorqueException
    {
        if (collWeblogTrackbacks == null)
        {
            if (isNew())
            {
               collWeblogTrackbacks = new ArrayList();
            }
            else
            {
                   criteria.add(WeblogTrackbackPeer.WEBLOG_ID, getWeblogId());
                   collWeblogTrackbacks = WeblogTrackbackPeer.doSelectJoinWeblog(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
            boolean newCriteria = true;
                   criteria.add(WeblogTrackbackPeer.WEBLOG_ID, getWeblogId());
               if (!lastWeblogTrackbacksCriteria.equals(criteria))
            {
                collWeblogTrackbacks = WeblogTrackbackPeer.doSelectJoinWeblog(criteria);
            }
        }
        lastWeblogTrackbacksCriteria = criteria;

        return collWeblogTrackbacks;
    }
     



     
    
    private static List fieldNames = null;

    /**
     * Generate a list of field names.
     *
     * @return a list of field names
     */
    public static synchronized List getFieldNames()
    {
      if (fieldNames == null)
      {
        fieldNames = new ArrayList();
            fieldNames.add("WeblogId");
            fieldNames.add("Owner");
            fieldNames.add("Year");
            fieldNames.add("Month");
            fieldNames.add("Day");
            fieldNames.add("Title");
            fieldNames = Collections.unmodifiableList(fieldNames);
      }
      return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in as a String.
     *
     * @param name field name
     * @return value
     */
    public Object getByName(String name)
    {
            if (name.equals("WeblogId"))
    {
              return new Integer(getWeblogId());
          }
            if (name.equals("Owner"))
    {
              return getOwner();
          }
            if (name.equals("Year"))
    {
              return new Integer(getYear());
          }
            if (name.equals("Month"))
    {
              return new Integer(getMonth());
          }
            if (name.equals("Day"))
    {
              return new Integer(getDay());
          }
            if (name.equals("Title"))
    {
              return getTitle();
          }
            return null;
    }
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     *
     * @param name peer name
     * @return value
     */
    public Object getByPeerName(String name)
    {
            if (name.equals(WeblogPeer.WEBLOG_ID))
        {
              return new Integer(getWeblogId());
          }
            if (name.equals(WeblogPeer.OWNER))
        {
              return getOwner();
          }
            if (name.equals(WeblogPeer.YEAR))
        {
              return new Integer(getYear());
          }
            if (name.equals(WeblogPeer.MONTH))
        {
              return new Integer(getMonth());
          }
            if (name.equals(WeblogPeer.DAY))
        {
              return new Integer(getDay());
          }
            if (name.equals(WeblogPeer.TITLE))
        {
              return getTitle();
          }
            return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     *
     * @param pos position in xml schema
     * @return value
     */
    public Object getByPosition(int pos)
    {
            if (pos == 0)
    {
              return new Integer(getWeblogId());
          }
            if (pos == 1)
    {
              return getOwner();
          }
            if (pos == 2)
    {
              return new Integer(getYear());
          }
            if (pos == 3)
    {
              return new Integer(getMonth());
          }
            if (pos == 4)
    {
              return new Integer(getDay());
          }
            if (pos == 5)
    {
              return getTitle();
          }
                return null;
    }

     


    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     *
     * @throws Exception
     */
    public void save() throws Exception
    {
             save(WeblogPeer.getMapBuilder()
                .getDatabaseMap().getName());
     }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
     *
     * @param dbName
     * @throws TorqueException
     */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
         try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }

     }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     *
     * @param con
     * @throws TorqueException
     */
    public void save(Connection con) throws TorqueException
    {
        if (!alreadyInSave)
      {
        alreadyInSave = true;



  
        // If this object has been modified, then save it to the database.
        if (isModified())
        {
            if (isNew())
            {
                WeblogPeer.doInsert((Weblog) this, con);
                setNew(false);
            }
            else
            {
                WeblogPeer.doUpdate((Weblog) this, con);
            }
        }

                                    
                
          if (collWeblogMessages != null)
          {
              for (int i = 0; i < collWeblogMessages.size(); i++)
              {
                  ((WeblogMessage) collWeblogMessages.get(i)).save(con);
              }
          }
                                        
                
          if (collWeblogComments != null)
          {
              for (int i = 0; i < collWeblogComments.size(); i++)
              {
                  ((WeblogComment) collWeblogComments.get(i)).save(con);
              }
          }
                                        
                
          if (collWeblogTrackbacks != null)
          {
              for (int i = 0; i < collWeblogTrackbacks.size(); i++)
              {
                  ((WeblogTrackback) collWeblogTrackbacks.get(i)).save(con);
              }
          }
                  alreadyInSave = false;
      }
      }


                        
    
    

        /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param  weblog_id ObjectKey
     */
    public void setPrimaryKey(ObjectKey key)
        throws TorqueException
    {
                    setWeblogId(((NumberKey) key).intValue());
            }

    /**
     * Set the PrimaryKey using a String.
     *
     * @param key
     */
    public void setPrimaryKey(String key) throws TorqueException
    {
                    setWeblogId(Integer.parseInt(key));
            }


    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
        return SimpleKey.keyFor(getWeblogId());
    }

 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     */
    public Weblog copy() throws TorqueException
    {
        return copyInto(new Weblog());
    }

    protected Weblog copyInto(Weblog copyObj) throws TorqueException
    {
        copyObj.setWeblogId(weblog_id);
        copyObj.setOwner(owner);
        copyObj.setYear(year);
        copyObj.setMonth(month);
        copyObj.setDay(day);
        copyObj.setTitle(title);

                      copyObj.setWeblogId(0);
                                

                                  
                
        List v = getWeblogMessages();
        for (int i = 0; i < v.size(); i++)
        {
            WeblogMessage obj = (WeblogMessage) v.get(i);
            copyObj.addWeblogMessage(obj.copy());
        }
                                              
                
        v = getWeblogComments();
        for (int i = 0; i < v.size(); i++)
        {
            WeblogComment obj = (WeblogComment) v.get(i);
            copyObj.addWeblogComment(obj.copy());
        }
                                              
                
        v = getWeblogTrackbacks();
        for (int i = 0; i < v.size(); i++)
        {
            WeblogTrackback obj = (WeblogTrackback) v.get(i);
            copyObj.addWeblogTrackback(obj.copy());
        }
              
        return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public WeblogPeer getPeer()
    {
        return peer;
    }
}
