/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jetspeedjapan.portlet.weblog.om;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.jetspeedjapan.portlet.weblog.WebLogException;
import jp.sourceforge.jetspeedjapan.portlet.weblog.om.BaseWeblogPeer;
import jp.sourceforge.jetspeedjapan.portlet.weblog.om.Weblog;
import jp.sourceforge.jetspeedjapan.portlet.weblog.om.utils.PageList;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public class WeblogPeer
extends BaseWeblogPeer {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)(class$jp$sourceforge$jetspeedjapan$portlet$weblog$om$WeblogPeer == null ? (class$jp$sourceforge$jetspeedjapan$portlet$weblog$om$WeblogPeer = WeblogPeer.class$("jp.sourceforge.jetspeedjapan.portlet.weblog.om.WeblogPeer")) : class$jp$sourceforge$jetspeedjapan$portlet$weblog$om$WeblogPeer).getName());
    static /* synthetic */ Class class$jp$sourceforge$jetspeedjapan$portlet$weblog$om$WeblogPeer;

    public static Weblog add(Connection con, String owner, int year, int month, int day) throws WebLogException {
        try {
            Weblog wlog = new Weblog();
            wlog.setOwner(owner);
            wlog.setYear(year);
            wlog.setMonth(month);
            wlog.setDay(day);
            wlog.setTitle(Integer.toString(year) + "/" + Integer.toString(month) + "/" + Integer.toString(day));
            wlog.save(con);
            return wlog;
        }
        catch (TorqueException e) {
            logger.warn((Object)("add: " + e.toString()));
            throw new WebLogException("Cannot create Weblog data.", e);
        }
    }

    public static List getWeblogs(String owner, int year, int month, int day) throws WebLogException {
        Criteria crit = new Criteria();
        if (owner != null) {
            crit.add(BaseWeblogPeer.OWNER, (Object)owner);
        }
        if (year > 0) {
            crit.add(BaseWeblogPeer.YEAR, year);
        }
        if (month > 0) {
            crit.add(BaseWeblogPeer.MONTH, month);
        }
        if (day > 0) {
            crit.add(BaseWeblogPeer.DAY, day);
        }
        try {
            return BaseWeblogPeer.doSelect(crit);
        }
        catch (TorqueException e) {
            logger.warn((Object)("getWeblogs: " + e.toString()));
            throw new WebLogException("Cannot get Weblog data.", e);
        }
    }

    public static PageList getWeblogs(Connection con, String owner, int year, int month, int day, int page, int size) throws WebLogException {
        Criteria crit = new Criteria();
        if (owner != null) {
            crit.add(BaseWeblogPeer.OWNER, (Object)owner);
        }
        if (year != -1) {
            crit.add(BaseWeblogPeer.YEAR, year);
        }
        if (month > 0 && month < 13) {
            crit.add(BaseWeblogPeer.MONTH, month);
        }
        if (day > 0 && day < 32) {
            crit.add(BaseWeblogPeer.DAY, day);
        }
        crit.addDescendingOrderByColumn(BaseWeblogPeer.YEAR);
        crit.addDescendingOrderByColumn(BaseWeblogPeer.MONTH);
        crit.addDescendingOrderByColumn(BaseWeblogPeer.DAY);
        return WeblogPeer.doPageSelect(con, crit, page, size);
    }

    public static PageList doPageSelect(Connection con, Criteria crit, int page, int size) throws WebLogException {
        PageList pageList = new PageList(page, size);
        if (page > 1) {
            pageList.setPrevious(true);
        }
        if (crit.getDbName() == Torque.getDefaultDB()) {
            crit.setDbName("weblog");
        }
        Object list = null;
        try {
            String sql = BasePeer.createQueryString((Criteria)crit);
            sql = StringUtils.replace((String)sql, (String)"SELECT  ", (String)"SELECT * ");
            sql = StringUtils.replace((String)sql, (String)"FROM  ", (String)"FROM WEBLOG ");
            Statement stat = con.createStatement();
            ResultSet rs = stat.executeQuery(sql);
            int count = 1;
            LinkedList<String> pkList = new LinkedList<String>();
            while (rs.next()) {
                if (count <= page * size) {
                    if (count > (page - 1) * size) {
                        pkList.add(rs.getString(1));
                    }
                } else {
                    pageList.setNext(true);
                }
                ++count;
            }
            pageList.setTotalSize(count);
            rs.close();
            stat.close();
            if (pkList.isEmpty()) {
                return pageList;
            }
            crit.andIn(BaseWeblogPeer.WEBLOG_ID, pkList);
            pageList.setList(BaseWeblogPeer.doSelect(crit, con));
        }
        catch (TorqueException e) {
            logger.warn((Object)("doSelectByPage: " + e.toString()));
            throw new WebLogException("Could not find Weblog data. ", e);
        }
        catch (SQLException e) {
            logger.warn((Object)("doSelectByPage: " + e.toString()));
            throw new WebLogException("Could not find Weblog data. ", e);
        }
        return pageList;
    }

    public static Weblog getInstance(Connection con, String owner, int year, int month, int day) throws WebLogException {
        List l;
        if (owner == null || year == -1 || month < 1 || month > 12 || day < 1 || day > 31) {
            throw new WebLogException("Invalid Weblog data.");
        }
        Criteria crit = new Criteria();
        crit.add(BaseWeblogPeer.OWNER, (Object)owner);
        crit.add(BaseWeblogPeer.YEAR, year);
        crit.add(BaseWeblogPeer.MONTH, month);
        crit.add(BaseWeblogPeer.DAY, day);
        try {
            l = BaseWeblogPeer.doSelect(crit, con);
        }
        catch (TorqueException e) {
            logger.warn((Object)("getInstance: " + e.toString()));
            throw new WebLogException("Could not get Weblog data. (Error Code: TorqueException on Transaction)", e);
        }
        if (!l.isEmpty() && l.get(0) instanceof Weblog) {
            return (Weblog)((Object)l.get(0));
        }
        return null;
    }

    public static PageList getLatestWeblogs(Connection con, String owner, int page, int size) throws WebLogException {
        Criteria crit = new Criteria();
        if (owner != null) {
            crit.add(BaseWeblogPeer.OWNER, (Object)owner);
        }
        crit.addDescendingOrderByColumn(BaseWeblogPeer.YEAR);
        crit.addDescendingOrderByColumn(BaseWeblogPeer.MONTH);
        crit.addDescendingOrderByColumn(BaseWeblogPeer.DAY);
        return WeblogPeer.doPageSelect(con, crit, page, size);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

