/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jetspeedjapan.portlet.weblog.om;

import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import jp.sourceforge.jetspeedjapan.portlet.weblog.WebLogException;
import jp.sourceforge.jetspeedjapan.portlet.weblog.om.BaseWeblogMessagePeer;
import jp.sourceforge.jetspeedjapan.portlet.weblog.om.BaseWeblogPeer;
import jp.sourceforge.jetspeedjapan.portlet.weblog.om.WeblogMessage;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.torque.TorqueException;
import org.apache.torque.util.Criteria;

public class WeblogMessagePeer
extends BaseWeblogMessagePeer {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)(class$jp$sourceforge$jetspeedjapan$portlet$weblog$om$WeblogMessagePeer == null ? (class$jp$sourceforge$jetspeedjapan$portlet$weblog$om$WeblogMessagePeer = WeblogMessagePeer.class$("jp.sourceforge.jetspeedjapan.portlet.weblog.om.WeblogMessagePeer")) : class$jp$sourceforge$jetspeedjapan$portlet$weblog$om$WeblogMessagePeer).getName());
    static /* synthetic */ Class class$jp$sourceforge$jetspeedjapan$portlet$weblog$om$WeblogMessagePeer;

    public static List doSelectJoinWeblog(Criteria c) throws TorqueException {
        return BaseWeblogMessagePeer.doSelectJoinWeblog(c);
    }

    public static WeblogMessage add(Connection con, int wlogId, String title, String message, String format, Date d) throws WebLogException {
        try {
            WeblogMessage dMessage = new WeblogMessage();
            if (wlogId <= 0) {
                throw new WebLogException("Weblog ID error.");
            }
            dMessage.setWeblogId(wlogId);
            if (title != null) {
                dMessage.setTitle(title);
            }
            if (message != null) {
                dMessage.setMessage(message);
            }
            if (format != null) {
                dMessage.setMessageFormatType(format);
            }
            if (d != null) {
                dMessage.setPostedDate(d);
            } else {
                Calendar cal = Calendar.getInstance();
                dMessage.setPostedDate(cal.getTime());
            }
            dMessage.save(con);
            return dMessage;
        }
        catch (TorqueException e) {
            logger.warn((Object)("add: " + e.toString()));
            throw new WebLogException("Cannot create WeblogMessage data.", e);
        }
    }

    public static WeblogMessage update(Connection con, String owner, int id, int wlogId, String title, String message, String format, Date d) throws WebLogException {
        WeblogMessage dMessage = WeblogMessagePeer.getInstance(con, owner, id);
        if (dMessage == null) {
            throw new WebLogException("WeblogMessage(ID=" + id + ", OWNER=" + owner + ") does not exist.");
        }
        try {
            if (wlogId > 0) {
                dMessage.setWeblogId(wlogId);
            }
            if (title != null) {
                dMessage.setTitle(title);
            }
            if (message != null) {
                dMessage.setMessage(message);
            }
            if (format != null) {
                dMessage.setMessageFormatType(format);
            }
            if (d != null) {
                dMessage.setPostedDate(d);
            }
            dMessage.save(con);
            return dMessage;
        }
        catch (TorqueException e) {
            logger.warn((Object)("add: " + e.toString()));
            throw new WebLogException("Cannot update WeblogMessage data. ", e);
        }
    }

    public static void delete(Connection con, String owner, int id) throws WebLogException {
        WeblogMessage dMessage = WeblogMessagePeer.getInstance(con, owner, id);
        if (dMessage == null) {
            throw new WebLogException("WeblogMessage(ID=" + id + ", OWNER=" + owner + ") does not exist.");
        }
        try {
            BaseWeblogMessagePeer.doDelete(dMessage, con);
        }
        catch (TorqueException e) {
            logger.warn((Object)("delete: " + e.toString()));
            throw new WebLogException("Cannot delete WeblogMessage data.", e);
        }
    }

    public static WeblogMessage getInstance(Connection con, String owner, int id) throws WebLogException {
        List l;
        Criteria crit = new Criteria();
        crit.add(BaseWeblogPeer.OWNER, (Object)owner);
        crit.add(BaseWeblogMessagePeer.WEBLOG_MESSAGE_ID, id);
        try {
            l = WeblogMessagePeer.doSelectJoinWeblog(crit);
        }
        catch (TorqueException e) {
            logger.warn((Object)("getInstance: " + e.toString()));
            throw new WebLogException("", e);
        }
        if (!l.isEmpty() && l.get(0) instanceof WeblogMessage) {
            return (WeblogMessage)((Object)l.get(0));
        }
        return null;
    }

    public static List getWeblogMessages(String owner, int year, int month, int day) throws WebLogException {
        Criteria crit = new Criteria();
        if (owner != null) {
            crit.add(BaseWeblogPeer.OWNER, (Object)owner);
        }
        if (year > 0) {
            crit.add(BaseWeblogPeer.YEAR, year);
        }
        if (month > 0) {
            crit.add(BaseWeblogPeer.MONTH, month);
        }
        if (day > 0) {
            crit.add(BaseWeblogPeer.DAY, day);
        }
        crit.addAscendingOrderByColumn(BaseWeblogMessagePeer.POSTED_DATE);
        try {
            return WeblogMessagePeer.doSelectJoinWeblog(crit);
        }
        catch (TorqueException e) {
            throw new WebLogException("Cannot get WeblogMessage data.", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

