/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jetspeedjapan.portlet.weblog;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jp.sourceforge.jetspeedjapan.portlet.weblog.WebLogException;
import jp.sourceforge.jetspeedjapan.portlet.weblog.om.BaseWeblogMessagePeer;
import jp.sourceforge.jetspeedjapan.portlet.weblog.om.BaseWeblogPeer;
import jp.sourceforge.jetspeedjapan.portlet.weblog.om.Weblog;
import jp.sourceforge.jetspeedjapan.portlet.weblog.om.WeblogMessage;
import jp.sourceforge.jetspeedjapan.portlet.weblog.om.WeblogMessagePeer;
import jp.sourceforge.jetspeedjapan.portlet.weblog.om.WeblogPeer;
import jp.sourceforge.jetspeedjapan.portlet.weblog.om.utils.PageList;
import jp.sourceforge.jetspeedjapan.portlet.weblog.util.CalendarUtil;
import jp.sourceforge.jetspeedjapan.portlet.weblog.util.WebLogUtil;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.PortletConfigState;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.util.Criteria;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WebLogManager {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)(class$jp$sourceforge$jetspeedjapan$portlet$weblog$WebLogManager == null ? (class$jp$sourceforge$jetspeedjapan$portlet$weblog$WebLogManager = WebLogManager.class$("jp.sourceforge.jetspeedjapan.portlet.weblog.WebLogManager")) : class$jp$sourceforge$jetspeedjapan$portlet$weblog$WebLogManager).getName());
    public static String DEFAULT_FRAME_BACKGROUND_COLOR = "#ffcc00";
    public static String DEFAULT_FRAME_TEXT_COLOR = "#000000";
    public static String DEFAULT_CONTENT_BACKGROUND_COLOR = "#ffffff";
    public static String DEFAULT_CONTENT_TEXT_COLOR = "#000000";
    public static String DEFAULT_TARGET_DAY_BACKGROUND_COLOR = "#ff3399";
    public static String DEFAULT_TARGET_DAY_TEXT_COLOR = "#ffffff";
    public static String DEFAULT_DAY_BACKGROUND_COLOR = "#ffffff";
    public static String DEFAULT_DAY_TEXT_COLOR = "#000000";
    public static String DEFAULT_SUNDAY_BACKGROUND_COLOR = "#ffccff";
    public static String DEFAULT_SUNDAY_TEXT_COLOR = "#ff0000";
    public static String DEFAULT_SATURDAY_BACKGROUND_COLOR = "#ccffff";
    public static String DEFAULT_SATURDAY_TEXT_COLOR = "#0000ff";
    private Context context;
    private RunData rundata;
    private ParameterParser params;
    private String userName;
    private int year;
    private int month;
    private int day;
    private String title;
    private String message;
    private String formatType;
    private int weblogMessageId;
    private String currentUrl;
    private int page;
    private int size;
    private int topicSize;
    private String type;
    private ArrayList infoList;
    private ArrayList errorList;
    private String frameBackgroundColor;
    private String frameTextColor;
    private String contentBackgroundColor;
    private String contentTextColor;
    private String targetdayBackgroundColor;
    private String targetdayTextColor;
    private String dayBackgroundColor;
    private String dayTextColor;
    private String sundayBackgroundColor;
    private String sundayTextColor;
    private String saturdayBackgroundColor;
    private String saturdayTextColor;
    static /* synthetic */ Class class$jp$sourceforge$jetspeedjapan$portlet$weblog$WebLogManager;

    public WebLogManager(Context context, RunData rundata, String username) {
        VelocityPortlet portlet;
        this.context = context;
        this.rundata = rundata;
        this.params = rundata.getParameters();
        this.infoList = new ArrayList();
        this.errorList = new ArrayList();
        this.setUserName(username);
        this.setYear(this.params.getInt(WebLogUtil.YEAR, -1));
        this.setMonth(this.params.getInt(WebLogUtil.MONTH, -1));
        this.setDay(this.params.getInt(WebLogUtil.DAY, -1));
        this.setTitle(this.params.getString(WebLogUtil.TITLE, null));
        this.setMessage(this.params.getString(WebLogUtil.MESSAGE, null));
        this.setFormatType(this.params.getString(WebLogUtil.FORMATTYPE, null));
        this.setWeblogMessageId(this.params.getInt(WebLogUtil.WEBLOGMESSAGEID, 0));
        this.setPage(this.params.getInt(WebLogUtil.WEBLOG_PAGE, 1));
        this.setSize(this.params.getInt(WebLogUtil.WEBLOG_SIZE, 5));
        String url = DynamicURI.toString((RunData)rundata);
        int pos = url.indexOf("?");
        if (pos > -1) {
            this.setCurrentUrl(url.substring(0, pos));
        } else {
            this.setCurrentUrl(url);
        }
        Calendar cal = Calendar.getInstance();
        if (this.getYear() == -1 || this.getMonth() == -1 || this.getDay() == -1) {
            this.setYear(cal.get(1));
            this.setMonth(cal.get(2) + 1);
            this.setDay(cal.get(5));
        } else {
            cal.set(this.getYear(), this.getMonth() - 1, this.getDay());
            this.setYear(cal.get(1));
            this.setMonth(cal.get(2) + 1);
            this.setDay(cal.get(5));
        }
        if (this.getUserName() != null && this.getUserName().equals("")) {
            this.setUserName(null);
        }
        if ((portlet = (VelocityPortlet)context.get("portlet")) != null) {
            this.setFrameBackgroundColor(PortletConfigState.getParameter((VelocityPortlet)portlet, (RunData)rundata, (String)WebLogUtil.FRAME_BACKGROUND_COLOR, (String)DEFAULT_FRAME_BACKGROUND_COLOR));
            context.put(WebLogUtil.FRAME_BACKGROUND_COLOR, (Object)this.getFrameBackgroundColor());
            this.setFrameTextColor(PortletConfigState.getParameter((VelocityPortlet)portlet, (RunData)rundata, (String)WebLogUtil.FRAME_TEXT_COLOR, (String)DEFAULT_FRAME_TEXT_COLOR));
            context.put(WebLogUtil.FRAME_TEXT_COLOR, (Object)this.getFrameTextColor());
            this.setContentBackgroundColor(PortletConfigState.getParameter((VelocityPortlet)portlet, (RunData)rundata, (String)WebLogUtil.CONTENT_BACKGROUND_COLOR, (String)DEFAULT_CONTENT_BACKGROUND_COLOR));
            context.put(WebLogUtil.CONTENT_BACKGROUND_COLOR, (Object)this.getContentBackgroundColor());
            this.setContentTextColor(PortletConfigState.getParameter((VelocityPortlet)portlet, (RunData)rundata, (String)WebLogUtil.CONTENT_TEXT_COLOR, (String)DEFAULT_CONTENT_TEXT_COLOR));
            context.put(WebLogUtil.CONTENT_TEXT_COLOR, (Object)this.getContentTextColor());
            this.setDayBackgroundColor(PortletConfigState.getParameter((VelocityPortlet)portlet, (RunData)rundata, (String)WebLogUtil.DAY_BACKGROUND_COLOR, (String)DEFAULT_DAY_BACKGROUND_COLOR));
            context.put(WebLogUtil.DAY_BACKGROUND_COLOR, (Object)this.getDayBackgroundColor());
            this.setDayTextColor(PortletConfigState.getParameter((VelocityPortlet)portlet, (RunData)rundata, (String)WebLogUtil.DAY_TEXT_COLOR, (String)DEFAULT_DAY_TEXT_COLOR));
            context.put(WebLogUtil.DAY_TEXT_COLOR, (Object)this.getDayTextColor());
            this.setTargetdayBackgroundColor(PortletConfigState.getParameter((VelocityPortlet)portlet, (RunData)rundata, (String)WebLogUtil.TARGET_DAY_BACKGROUND_COLOR, (String)DEFAULT_TARGET_DAY_BACKGROUND_COLOR));
            context.put(WebLogUtil.TARGET_DAY_BACKGROUND_COLOR, (Object)this.getTargetdayBackgroundColor());
            this.setTargetdayTextColor(PortletConfigState.getParameter((VelocityPortlet)portlet, (RunData)rundata, (String)WebLogUtil.TARGET_DAY_TEXT_COLOR, (String)DEFAULT_TARGET_DAY_TEXT_COLOR));
            context.put(WebLogUtil.TARGET_DAY_TEXT_COLOR, (Object)this.getTargetdayTextColor());
            this.setSundayBackgroundColor(PortletConfigState.getParameter((VelocityPortlet)portlet, (RunData)rundata, (String)WebLogUtil.SUNDAY_BACKGROUND_COLOR, (String)DEFAULT_SUNDAY_BACKGROUND_COLOR));
            context.put(WebLogUtil.SUNDAY_BACKGROUND_COLOR, (Object)this.getSundayBackgroundColor());
            this.setSundayTextColor(PortletConfigState.getParameter((VelocityPortlet)portlet, (RunData)rundata, (String)WebLogUtil.SUNDAY_TEXT_COLOR, (String)DEFAULT_SUNDAY_TEXT_COLOR));
            context.put(WebLogUtil.SUNDAY_TEXT_COLOR, (Object)this.getSundayTextColor());
            this.setSaturdayBackgroundColor(PortletConfigState.getParameter((VelocityPortlet)portlet, (RunData)rundata, (String)WebLogUtil.SATURDAY_BACKGROUND_COLOR, (String)DEFAULT_SATURDAY_BACKGROUND_COLOR));
            context.put(WebLogUtil.SATURDAY_BACKGROUND_COLOR, (Object)this.getSaturdayBackgroundColor());
            this.setSaturdayTextColor(PortletConfigState.getParameter((VelocityPortlet)portlet, (RunData)rundata, (String)WebLogUtil.SATURDAY_TEXT_COLOR, (String)DEFAULT_SATURDAY_TEXT_COLOR));
            context.put(WebLogUtil.SATURDAY_TEXT_COLOR, (Object)this.getSaturdayTextColor());
        }
    }

    public void putDate() {
        this.context.put(WebLogUtil.YEAR, (Object)Integer.toString(this.getYear()));
        this.context.put(WebLogUtil.MONTH, (Object)Integer.toString(this.getMonth()));
        this.context.put(WebLogUtil.DAY, (Object)Integer.toString(this.getDay()));
    }

    public void putInfo() {
        this.context.put(WebLogUtil.CURRENT_URL, (Object)this.getCurrentUrl());
        if (this.getUserName() != null) {
            this.context.put(WebLogUtil.USER_NAME, (Object)this.getUserName());
        }
        if (!this.infoList.isEmpty()) {
            this.context.put(WebLogUtil.INFO_MESSAGE, (Object)this.infoList);
        }
        if (!this.errorList.isEmpty()) {
            this.context.put(WebLogUtil.ERROR_MESSAGE, (Object)this.errorList);
        }
    }

    public void putPageInfo() {
        this.context.put(WebLogUtil.WEBLOG_PAGE, (Object)Integer.toString(this.getPage()));
        this.context.put(WebLogUtil.WEBLOG_SIZE, (Object)Integer.toString(this.getSize()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putWeblog() {
        Connection con = null;
        try {
            try {
                con = Torque.getConnection((String)"weblog");
                con.setAutoCommit(false);
                Weblog wlog = WeblogPeer.getInstance(con, this.getUserName(), this.getYear(), this.getMonth(), this.getDay());
                if (wlog != null) {
                    wlog.setCachedWeblogMessages(con);
                }
                con.commit();
                this.context.put(WebLogUtil.WEBLOG, (Object)wlog);
            }
            catch (WebLogException e) {
                this.addErrorMessage((Exception)((Object)e));
                this.rollback(con);
                Object var6_5 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            catch (TorqueException e) {
                this.addErrorMessage((Exception)((Object)e));
                this.rollback(con);
                Object var6_6 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            catch (SQLException e) {
                this.addErrorMessage(e);
                this.rollback(con);
                Object var6_7 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            Torque.closeConnection((Connection)con);
            throw throwable;
        }
        Torque.closeConnection((Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putWeblogs() {
        Connection con = null;
        PageList pageList = null;
        try {
            try {
                con = Torque.getConnection((String)"weblog");
                con.setAutoCommit(false);
                pageList = WeblogPeer.getWeblogs(con, this.getUserName(), this.getYear(), this.getMonth(), this.getDay(), this.getPage(), this.getSize());
                con.commit();
            }
            catch (WebLogException e) {
                this.addErrorMessage((Exception)((Object)e));
                this.rollback(con);
                Object var7_4 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            catch (TorqueException e) {
                this.addErrorMessage((Exception)((Object)e));
                this.rollback(con);
                Object var7_5 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            catch (SQLException e) {
                this.addErrorMessage(e);
                this.rollback(con);
                Object var7_6 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            Object var7_3 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Torque.closeConnection((Connection)con);
            throw throwable;
        }
        Torque.closeConnection((Connection)con);
        if (!pageList.isEmpty()) {
            Vector<Weblog> v = new Vector<Weblog>();
            Iterator i = pageList.iterator();
            Criteria c = new Criteria();
            c.addAscendingOrderByColumn(BaseWeblogMessagePeer.POSTED_DATE);
            while (i.hasNext()) {
                Object o = i.next();
                if (o instanceof Weblog) {
                    ((Weblog)((Object)o)).setCachedWeblogMessages(c);
                    v.add((Weblog)((Object)o));
                    continue;
                }
                logger.warn((Object)"selectMessageByDate: Object is not Weblog!");
            }
            this.context.put(WebLogUtil.WEBLOGS, v);
            this.context.put(WebLogUtil.WEBLOG_NEXTPAGE, (Object)Boolean.toString(pageList.hasNextPage()));
        } else {
            this.addInfoMessage("Weblog for this day does not exist.");
        }
    }

    public void putWeblogMessages() {
        try {
            List l = WeblogMessagePeer.getWeblogMessages(this.getUserName(), this.getYear(), this.getMonth(), this.getDay());
            if (!l.isEmpty()) {
                Vector<WeblogMessage> v = new Vector<WeblogMessage>();
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    if (o instanceof WeblogMessage) {
                        v.add((WeblogMessage)((Object)o));
                        continue;
                    }
                    logger.warn((Object)"getWeblogMessage: Object is not WeblogMessage!");
                }
                this.context.put(WebLogUtil.WEBLOG_MESSAGES, v);
            }
        }
        catch (WebLogException e) {
            this.addErrorMessage((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addWeblogMessage() {
        Connection con = null;
        try {
            try {
                con = Torque.getConnection((String)"weblog");
                con.setAutoCommit(false);
                Weblog wlog = WeblogPeer.getInstance(con, this.getUserName(), this.getYear(), this.getMonth(), this.getDay());
                Calendar cal = Calendar.getInstance();
                if (wlog != null) {
                    WeblogMessagePeer.add(con, wlog.getWeblogId(), this.getTitle() != null ? WebLogUtil.encodeForDatabase(this.getTitle()) : "", this.getMessage() != null ? WebLogUtil.encodeForDatabase(this.getMessage()) : "", this.getFormatType() == null ? WebLogUtil.PLAIN : this.getFormatType(), cal.getTime());
                    con.commit();
                    this.addInfoMessage("Added New Message.");
                }
                wlog = WeblogPeer.add(con, this.getUserName(), this.getYear(), this.getMonth(), this.getDay());
                WeblogMessagePeer.add(con, wlog.getWeblogId(), this.getTitle() != null ? WebLogUtil.encodeForDatabase(this.getTitle()) : "", this.getMessage() != null ? WebLogUtil.encodeForDatabase(this.getMessage()) : "", this.getFormatType() == null ? WebLogUtil.PLAIN : this.getFormatType(), cal.getTime());
                con.commit();
                this.addInfoMessage("Created New Message.");
            }
            catch (WebLogException e) {
                this.addErrorMessage((Exception)((Object)e));
                this.rollback(con);
                Object var6_7 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            catch (TorqueException e) {
                this.addErrorMessage((Exception)((Object)e));
                this.rollback(con);
                Object var6_8 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            catch (SQLException e) {
                this.addErrorMessage(e);
                this.rollback(con);
                Object var6_9 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            Torque.closeConnection((Connection)con);
            throw throwable;
        }
        Torque.closeConnection((Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateWeblogMessage() {
        Connection con = null;
        try {
            try {
                con = Torque.getConnection((String)"weblog");
                con.setAutoCommit(false);
                WeblogMessagePeer.update(con, this.getUserName(), this.getWeblogMessageId(), -1, this.getTitle() != null ? WebLogUtil.encodeForDatabase(this.getTitle()) : "", this.getMessage() != null ? WebLogUtil.encodeForDatabase(this.getMessage()) : "", this.getFormatType() == null ? WebLogUtil.PLAIN : this.getFormatType(), null);
                con.commit();
                this.addInfoMessage("Updated WeblogMessage data.");
            }
            catch (WebLogException e) {
                this.addErrorMessage((Exception)((Object)e));
                this.rollback(con);
                Object var6_3 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            catch (TorqueException e) {
                this.addErrorMessage((Exception)((Object)e));
                this.rollback(con);
                Object var6_4 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            catch (SQLException e) {
                this.addErrorMessage(e);
                this.rollback(con);
                Object var6_5 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            Object var6_2 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Torque.closeConnection((Connection)con);
            throw throwable;
        }
        Torque.closeConnection((Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteWeblogMessage() {
        Connection con = null;
        try {
            try {
                con = Torque.getConnection((String)"weblog");
                con.setAutoCommit(false);
                WeblogMessagePeer.delete(con, this.getUserName(), this.getWeblogMessageId());
                con.commit();
                this.addInfoMessage("Deleted WeblogMessage data.");
            }
            catch (WebLogException e) {
                this.addErrorMessage((Exception)((Object)e));
                this.rollback(con);
                Object var6_3 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            catch (TorqueException e) {
                this.addErrorMessage((Exception)((Object)e));
                this.rollback(con);
                Object var6_4 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            catch (SQLException e) {
                this.addErrorMessage(e);
                this.rollback(con);
                Object var6_5 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            Object var6_2 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Torque.closeConnection((Connection)con);
            throw throwable;
        }
        Torque.closeConnection((Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateWeblog() {
        Connection con = null;
        try {
            try {
                con = Torque.getConnection((String)"weblog");
                con.setAutoCommit(false);
                Weblog wlog = WeblogPeer.getInstance(con, this.getUserName(), this.getYear(), this.getMonth(), this.getDay());
                wlog.setTitle(this.getTitle());
                wlog.save(con);
                con.commit();
                this.addInfoMessage("Updated Weblog data.");
            }
            catch (WebLogException e) {
                this.addErrorMessage((Exception)((Object)e));
                this.rollback(con);
                Object var6_5 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            catch (TorqueException e) {
                this.addErrorMessage((Exception)((Object)e));
                this.rollback(con);
                Object var6_6 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            catch (SQLException e) {
                this.addErrorMessage(e);
                this.rollback(con);
                Object var6_7 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            Torque.closeConnection((Connection)con);
            throw throwable;
        }
        Torque.closeConnection((Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteWeblog() {
        Connection con;
        block11: {
            block10: {
                con = null;
                try {
                    try {
                        con = Torque.getConnection((String)"weblog");
                        con.setAutoCommit(false);
                        Weblog wlog = WeblogPeer.getInstance(con, this.getUserName(), this.getYear(), this.getMonth(), this.getDay());
                        List list = wlog.getWeblogMessages(con);
                        if (list != null) {
                            Iterator i = list.iterator();
                            while (i.hasNext()) {
                                Object obj = i.next();
                                if (obj instanceof WeblogMessage) {
                                    BaseWeblogMessagePeer.doDelete((WeblogMessage)((Object)obj), con);
                                    continue;
                                }
                                this.addErrorMessage("Wrong WeblogMessage type.");
                                this.rollback(con);
                                Object var7_9 = null;
                                break block10;
                            }
                        }
                        BaseWeblogPeer.doDelete(wlog, con);
                        con.commit();
                        this.addInfoMessage("Deleted Weblog data.");
                        break block11;
                    }
                    catch (WebLogException e) {
                        this.addErrorMessage((Exception)((Object)e));
                        this.rollback(con);
                        Object var7_11 = null;
                        Torque.closeConnection((Connection)con);
                        return;
                    }
                    catch (TorqueException e) {
                        this.addErrorMessage((Exception)((Object)e));
                        this.rollback(con);
                        Object var7_12 = null;
                        Torque.closeConnection((Connection)con);
                        return;
                    }
                    catch (SQLException e) {
                        this.addErrorMessage(e);
                        this.rollback(con);
                        Object var7_13 = null;
                        Torque.closeConnection((Connection)con);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_14 = null;
                    Torque.closeConnection((Connection)con);
                    throw throwable;
                }
            }
            Torque.closeConnection((Connection)con);
            return;
        }
        Object var7_10 = null;
        Torque.closeConnection((Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTopicWeblogs() {
        PageList pageList;
        Connection con = null;
        try {
            try {
                con = Torque.getConnection((String)"weblog");
                con.setAutoCommit(false);
                pageList = WeblogPeer.getLatestWeblogs(con, this.getUserName(), 1, this.getTopicSize());
                con.commit();
            }
            catch (WebLogException e) {
                this.addErrorMessage((Exception)((Object)e));
                this.rollback(con);
                Object var7_4 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            catch (TorqueException e) {
                this.addErrorMessage((Exception)((Object)e));
                this.rollback(con);
                Object var7_5 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            catch (SQLException e) {
                this.addErrorMessage(e);
                this.rollback(con);
                Object var7_6 = null;
                Torque.closeConnection((Connection)con);
                return;
            }
            Object var7_3 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Torque.closeConnection((Connection)con);
            throw throwable;
        }
        Torque.closeConnection((Connection)con);
        if (!pageList.isEmpty()) {
            Vector<Weblog> v = new Vector<Weblog>();
            Iterator i = pageList.iterator();
            Criteria c = new Criteria();
            c.addAscendingOrderByColumn(BaseWeblogMessagePeer.POSTED_DATE);
            while (i.hasNext()) {
                Object o = i.next();
                if (o instanceof Weblog) {
                    ((Weblog)((Object)o)).setCachedWeblogMessages(c);
                    v.add((Weblog)((Object)o));
                    continue;
                }
                logger.warn((Object)"selectMessageByDate: Object is not Weblog!");
            }
            this.context.put(WebLogUtil.WEBLOGS, v);
            this.context.put(WebLogUtil.WEBLOG_NEXTPAGE, (Object)Boolean.toString(pageList.hasNextPage()));
        } else {
            this.addErrorMessage("Cannot find messages.");
        }
    }

    public void putCalendar() {
        StringBuffer buf = new StringBuffer();
        buf.append(CalendarUtil.printCalendar(this));
        this.context.put(WebLogUtil.WEBLOG_CALENDAR, (Object)buf.toString());
    }

    public void putEditorHeader() {
        StringBuffer buf = new StringBuffer();
        buf.append(CalendarUtil.printTextDateNavigation(this));
        this.context.put(WebLogUtil.WEBLOG_EDITOR_HEADER, (Object)buf.toString());
    }

    public void putViewerHeader() {
        StringBuffer buf = new StringBuffer();
        buf.append(CalendarUtil.printFormNavigation(this));
        buf.append(CalendarUtil.printTextDateNavigation(this));
        this.context.put(WebLogUtil.WEBLOG_VIEWER_HEADER, (Object)buf.toString());
    }

    public void putCalendarHeader() {
        StringBuffer buf = new StringBuffer();
        buf.append(CalendarUtil.printFormNavigation(this));
        this.context.put(WebLogUtil.WEBLOG_CALENDAR_HEADER, (Object)buf.toString());
    }

    public void putEditorFooter() {
        StringBuffer buf = new StringBuffer();
        buf.append(CalendarUtil.printFormNavigation(this));
        this.context.put(WebLogUtil.WEBLOG_EDITOR_FOOTER, (Object)buf.toString());
    }

    public void putViewerFooter() {
        StringBuffer buf = new StringBuffer();
        this.context.put(WebLogUtil.WEBLOG_VIEWER_FOOTER, (Object)buf.toString());
    }

    public void putCalendarFooter() {
        StringBuffer buf = new StringBuffer();
        buf.append(CalendarUtil.printTextMonthNavigation(this));
        this.context.put(WebLogUtil.WEBLOG_CALENDAR_FOOTER, (Object)buf.toString());
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public void setDay(int i) {
        this.day = i;
    }

    public void setMonth(int i) {
        this.month = i;
    }

    public void setYear(int i) {
        this.year = i;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTitle() {
        return this.title;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getWeblogMessageId() {
        return this.weblogMessageId;
    }

    public String getFormatType() {
        return this.formatType;
    }

    public void setWeblogMessageId(int i) {
        this.weblogMessageId = i;
    }

    public void setFormatType(String string) {
        this.formatType = string;
    }

    private void addInfoMessage(String str) {
        this.infoList.add(str);
    }

    private void addErrorMessage(String str) {
        this.errorList.add(str);
    }

    private void addErrorMessage(Exception e) {
        logger.warn((Object)e.toString());
        this.addErrorMessage(e.getMessage());
    }

    public String getCurrentUrl() {
        return this.currentUrl;
    }

    public void setCurrentUrl(String string) {
        this.currentUrl = string;
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public void setPage(int i) {
        this.page = i;
    }

    public void setSize(int i) {
        this.size = i;
    }

    public void rollback(Connection con) {
        try {
            con.rollback();
        }
        catch (SQLException e) {
            logger.warn((Object)("addWeblogMessage: " + e.toString()));
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public int getTopicSize() {
        return this.topicSize;
    }

    public void setTopicSize(int i) {
        this.topicSize = i;
    }

    public String getDayBackgroundColor() {
        return this.dayBackgroundColor;
    }

    public String getDayTextColor() {
        return this.dayTextColor;
    }

    public String getFrameBackgroundColor() {
        return this.frameBackgroundColor;
    }

    public String getFrameTextColor() {
        return this.frameTextColor;
    }

    public String getSaturdayBackgroundColor() {
        return this.saturdayBackgroundColor;
    }

    public String getSaturdayTextColor() {
        return this.saturdayTextColor;
    }

    public String getSundayBackgroundColor() {
        return this.sundayBackgroundColor;
    }

    public String getSundayTextColor() {
        return this.sundayTextColor;
    }

    public String getTargetdayBackgroundColor() {
        return this.targetdayBackgroundColor;
    }

    public String getTargetdayTextColor() {
        return this.targetdayTextColor;
    }

    public void setDayBackgroundColor(String string) {
        this.dayBackgroundColor = string;
    }

    public void setDayTextColor(String string) {
        this.dayTextColor = string;
    }

    public void setFrameBackgroundColor(String string) {
        this.frameBackgroundColor = string;
    }

    public void setFrameTextColor(String string) {
        this.frameTextColor = string;
    }

    public void setSaturdayBackgroundColor(String string) {
        this.saturdayBackgroundColor = string;
    }

    public void setSaturdayTextColor(String string) {
        this.saturdayTextColor = string;
    }

    public void setSundayBackgroundColor(String string) {
        this.sundayBackgroundColor = string;
    }

    public void setSundayTextColor(String string) {
        this.sundayTextColor = string;
    }

    public void setTargetdayBackgroundColor(String string) {
        this.targetdayBackgroundColor = string;
    }

    public void setTargetdayTextColor(String string) {
        this.targetdayTextColor = string;
    }

    public String getContentBackgroundColor() {
        return this.contentBackgroundColor;
    }

    public void setContentBackgroundColor(String string) {
        this.contentBackgroundColor = string;
    }

    public String getContentTextColor() {
        return this.contentTextColor;
    }

    public void setContentTextColor(String string) {
        this.contentTextColor = string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

