package jp.mobster.webapp.wiki.transform;

/**
 * ɡ---ס--ס-פ
 * 
 * --- : <ul><ul><ul><li>[̾ʸ]</li></ul></ul></ul>
 * -- : <ul><ul><li>[̾ʸ]</li></ul></ul>
 * - : <ul><li>[̾ʸ]</li></ul>
 * 
 * @see DataLineCreator
 */
public class ULDataLine implements DataLine
{
    protected String keyword_, //ɡ֤оݡ
    lineData_, //ǡ
        dataHoldTag_ = "li", //ǡΤϤॿ
        outerHoldTag_ = "ul", //ǡγ¦Ϥॿ
    baseSpaces_;

    /**
     * 
     * 
     * @param lineData ԥǡʥʬ
     **/
    public void init(String lineData)
    {
        if (lineData.indexOf("---") == 0)
        {
            keyword_ = "---";
            baseSpaces_ = "  ";
        }
        else if (lineData.indexOf("--") == 0)
        {
            keyword_ = "--";
            baseSpaces_ = " ";
        }
        else
        {
            keyword_ = "-";
            baseSpaces_ = "";
        }

        lineData_ = lineData.substring(getKeyword().length());
    }

    /**
     * Ƭɼ
     * 
     * @return Ƭ
     **/
    public String getKeyword()
    {
        return keyword_;
    }

    /**
     * ǡγ¦򶴤೫ϥ<ul>˼
     * 
     * @param oldLine ιԥǡ
     * @return <ul>
     **/
    public String openTag(DataLine oldLine)
    {
        if (oldLine != null && oldLine instanceof ULDataLine)
        {
            //ιԤ UL ξ
            ULDataLine oldULLine = (ULDataLine) oldLine;
            int depth = getKeyword().length() - oldULLine.getKeyword().length();
            switch (depth)
            {
                case 0 :
                    // UL ƱξϤʤ
                    return "";
                case 1 :
                    return baseSpaces_ + "<" + outerHoldTag_ + ">\n";
                case 2 :
                    return " <" + outerHoldTag_ + ">\n" + baseSpaces_ + "<" + outerHoldTag_ + ">\n";
                default :
                    return "";
            }
        }
        else
        {
            int depth = getKeyword().length();
            switch (depth)
            {
                case 1 :
                    return baseSpaces_ + "<" + outerHoldTag_ + ">\n";
                case 2 :
                    return "<" + outerHoldTag_ + ">\n" + baseSpaces_ + "<" + outerHoldTag_ + ">\n";
                case 3 :
                    return "<"
                        + outerHoldTag_
                        + ">\n"
                        + " <"
                        + outerHoldTag_
                        + ">\n"
                        + baseSpaces_
                        + "<"
                        + outerHoldTag_
                        + ">\n";
                default :
                    return "";
            }
        }
    }

    /**
     * ƬղäȾѥڡ" "˼
     * 
     * @param spaceNum ڡ
     * @return Ƭղä륹ڡ
     **/
    private String getBaseSpaces(int spaceNum)
    {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < spaceNum; i++)
        {
            buf.append(" ");
        }

        return buf.toString();
    }

    /**
     * ǡγ¦򶴤ཪλ<ul>˼
     * 
     * @param oldLine ιԥǡ
     * @return </ul>
     **/
    public String closeTag(DataLine newLine)
    {
        if (newLine != null && newLine instanceof ULDataLine)
        {
            //ιԤ UL ξ
            ULDataLine oldULLine = (ULDataLine) newLine;
            int depth = getKeyword().length() - newLine.getKeyword().length();
            switch (depth)
            {
                case 0 :
                    // UL ƱξϤʤ
                    return "";
                case 1 :
                    return baseSpaces_ + "</" + outerHoldTag_ + ">\n";
                case 2 :
                    return baseSpaces_ + "</" + outerHoldTag_ + ">\n" + " </" + outerHoldTag_ + ">\n";
                default :
                    return "";
            }
        }
        else
        {
            int depth = getKeyword().length();
            switch (depth)
            {
                case 1 :
                    return baseSpaces_ + "</" + outerHoldTag_ + ">\n";
                case 2 :
                    return baseSpaces_ + "</" + outerHoldTag_ + ">\n" + "</" + outerHoldTag_ + ">\n";
                case 3 :
                    return baseSpaces_
                        + "</"
                        + outerHoldTag_
                        + ">\n"
                        + " </"
                        + outerHoldTag_
                        + ">\n"
                        + "</"
                        + outerHoldTag_
                        + ">\n";
                default :
                    return "";
            }
        }
    }

    /**
     * ԥǡ
     * 
     * @return ԥǡ
     **/
    public String get()
    {
        return baseSpaces_ + "<" + dataHoldTag_ + ">" + lineData_ + "</" + dataHoldTag_ + ">\n";
    }
}
