package jp.mobster.webapp.wiki.transform;

import java.util.ArrayList;

import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.PatternMatcherInput;

import jp.mobster.util.StringUtil;

/**
 * ɡ,פ
 * 
 * , : <table><tr><td>[̾ʸ]</td></tr></table>
 * 
 * @see DataLineCreator
 */
public class TableDataLine implements DataLine
{
        private String keyword_ = ",", //ɡ֤оݡ
        lineData_, //ǡ
        dataHoldTag_ = "tr", //ǡΤϤॿ
    outerHoldTag_ = "table"; //ǡγ¦Ϥॿ

    /**
     * 
     * 
     * @param lineData ԥǡʥʬ
     **/
    public void init(String lineData)
    {
        //		String[] cells = StringUtil.split(lineData.substring(1), ",");
        // \\,б
        final ArrayList list = new ArrayList();
        final Perl5Util util = new Perl5Util();
        final PatternMatcherInput input = new PatternMatcherInput(lineData);
        while (util.match("m!([^,](\\\\,)?)+|$!", input))
        {
            String s = util.group(0);
            s = (s == null) ? "" : StringUtil.replace(s, "\\,", ",");
            list.add(s);
        }
        final String[] cells = (String[]) list.toArray(new String[list.size()]);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < cells.length; i++)
        {
            //			buf.append("<td>" + cells[i] + "</td>");
            buf.append("<td>" + makeCellContent(cells[i]) + "</td>");
        }

        lineData_ = buf.toString();
    }

    private String makeCellContent(String cell)
    {
        if (cell.length() < 2)
        {
            return cell;
        }

        if (cell.indexOf("&gt;&gt;") == 0)
        {
            return "<div align=right>" + cell.substring(8) + "</div>";
        }
        if (cell.indexOf("&gt;") == 0)
        {
            return "<div align=center>" + cell.substring(4) + "</div>";
        }
        return cell;
    }

    /**
     * Ƭɼ
     * 
     * @return Ƭ
     **/
    public String getKeyword()
    {
        return keyword_;
    }

    /**
     * ǡγ¦򶴤೫ϥ<table>˼
     * 
     * @param oldLine ιԥǡ
     * @return <table>
     **/
    public String openTag(DataLine oldLine)
    {
        if (oldLine != null && oldLine instanceof TableDataLine)
        {
            //ιԤơ֥ǡξ<table>Ϥʤ
            return "";
        }
        else
        {
            return "<" + outerHoldTag_ + ">\n";
        }
    }

    /**
     * ǡγ¦򶴤ཪλ</table>˼
     * 
     * @param newLine ιԥǡ
     * @return </table>
     **/
    public String closeTag(DataLine newLine)
    {
        if (newLine != null && !(newLine instanceof TableDataLine))
        {
            return "</" + outerHoldTag_ + ">\n";
        }
        else
        {
            //ιԤơ֥ǡξ</table>Ϥʤ
            return "";
        }
    }

    /**
     * ԥǡ
     * 
     * @return ԥǡ
     **/
    public String get()
    {
        return "<" + dataHoldTag_ + ">" + lineData_ + "</" + dataHoldTag_ + ">\n";
    }
}
