package jp.mobster.webapp.wiki.transform;

/**
 * ɡ>>>ס>>ס>פ
 * 
 * >>> : <blockquote><blockquote><blockquote>[̾ʸ]
 * 			</blockquote></blockquote></blockquote>
 * >> : <blockquote><blockquote>[̾ʸ]
 * 			</blockquote></blockquote>
 * > : <blockquote>[̾ʸ]</blockquote>
 * 
 * @see DataLineCreator
 */
public class BlockquoteDataLine implements DataLine
{
    private String keyword_, //ɡ֤оݡ
    lineData_, //ǡ
        dataHoldTag_ = "", //ǡΤϤॿ
        outerHoldTag_ = "blockquote", //ǡγ¦Ϥॿ
    baseSpaces_;

    /**
     * 
     * 
     * @param lineData ԥǡʥʬ
     **/
    public void init(String lineData)
    {
        int length = 0;
        if (lineData.indexOf("&gt;&gt;&gt;") == 0)
        {
            keyword_ = ">>>";
            baseSpaces_ = "  ";
            length = 12;
        }
        else if (lineData.indexOf("&gt;&gt;") == 0)
        {
            keyword_ = ">>";
            baseSpaces_ = " ";
            length = 8;
        }
        else
        {
            keyword_ = ">";
            baseSpaces_ = "";
            length = 4;
        }

        lineData_ = lineData.substring(length);
    }

    /**
     * Ƭɼ
     * 
     * @return Ƭ
     **/
    public String getKeyword()
    {
        return keyword_;
    }

    /**
     * ǡγ¦򶴤೫ϥ<blockquote>˼
     * 
     * @param oldLine ιԥǡ
     * @return <blockquote>
     **/
    public String openTag(DataLine oldLine)
    {
        if (oldLine != null && oldLine instanceof BlockquoteDataLine)
        {
            //ιԤ BLOCKQUOTE ξ
            BlockquoteDataLine oldBlockquoteLine = (BlockquoteDataLine) oldLine;
            int depth = getKeyword().length() - oldBlockquoteLine.getKeyword().length();
            switch (depth)
            {
                case 0 :
                    //BLOCKQUOTE ƱξϤʤ
                    return "";
                case 1 :
                    return baseSpaces_ + "<" + outerHoldTag_ + ">\n";
                case 2 :
                    return " <" + outerHoldTag_ + ">\n" + baseSpaces_ + "<" + outerHoldTag_ + ">\n";
                default :
                    return "";
            }
        }
        else
        {
            int depth = getKeyword().length();
            switch (depth)
            {
                case 1 :
                    return baseSpaces_ + "<" + outerHoldTag_ + ">\n";
                case 2 :
                    return "<" + outerHoldTag_ + ">\n" + baseSpaces_ + "<" + outerHoldTag_ + ">\n";
                case 3 :
                    return "<"
                        + outerHoldTag_
                        + ">\n"
                        + " <"
                        + outerHoldTag_
                        + ">\n"
                        + baseSpaces_
                        + "<"
                        + outerHoldTag_
                        + ">\n";
                default :
                    return "";
            }
        }
    }

    /**
     * ƬղäȾѥڡ" "˼
     * 
     * @param spaceNum ڡ
     * @return Ƭղä륹ڡ
     **/
    private String getBaseSpaces(int spaceNum)
    {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < spaceNum; i++)
        {
            buf.append(" ");
        }

        return buf.toString();
    }

    /**
     * ǡγ¦򶴤ཪλ<blockquote>˼
     * 
     * @param oldLine ιԥǡ
     * @return </blockquote>
     **/
    public String closeTag(DataLine newLine)
    {
        if (newLine != null && newLine instanceof BlockquoteDataLine)
        {
            //ιԤ BLOCKQUOTE ξ
            BlockquoteDataLine oldULLine = (BlockquoteDataLine) newLine;
            int depth = getKeyword().length() - newLine.getKeyword().length();
            switch (depth)
            {
                case 0 :
                    //BLOCKQUOTE ƱξϤʤ
                    return "";
                case 1 :
                    return baseSpaces_ + "</" + outerHoldTag_ + ">\n";
                case 2 :
                    return baseSpaces_ + "</" + outerHoldTag_ + ">\n" + " </" + outerHoldTag_ + ">\n";
                default :
                    return "";
            }
        }
        else
        {
            int depth = getKeyword().length();
            switch (depth)
            {
                case 1 :
                    return baseSpaces_ + "</" + outerHoldTag_ + ">\n";
                case 2 :
                    return baseSpaces_ + "</" + outerHoldTag_ + ">\n" + "</" + outerHoldTag_ + ">\n";
                case 3 :
                    return baseSpaces_
                        + "</"
                        + outerHoldTag_
                        + ">\n"
                        + " </"
                        + outerHoldTag_
                        + ">\n"
                        + "</"
                        + outerHoldTag_
                        + ">\n";
                default :
                    return "";
            }
        }
    }

    /**
     * ԥǡ
     * 
     * @return ԥǡ
     **/
    public String get()
    {
        return baseSpaces_ + lineData_ + "<br>\n";
    }
}
