package jp.mobster.webapp.wiki.tag;

import org.apache.oro.text.perl.Perl5Util;

import jp.mobster.util.WebUtil;
import jp.mobster.webapp.wiki.transform.DataTag;

/**
 * Link Data Tag
 * @author <a href="mailto:agata@mobster.jp">Toshitaka Agata</a>
 * @version $Revision: 1.1 $ $Date: 2003/09/10 14:22:56 $
 */
public class LinkDataTag implements DataTag
{
    /**
     * @see jp.mobster.webapp.wiki.transform.DataTag#get()
     */
    public String get(String pageData)
    {
        String tmp = pageData;
        Perl5Util perl = new Perl5Util();
        tmp = WebUtil.addLinkTagURL(tmp, "_blank");
        tmp = perl.substitute("s!<a.*>(https?\\://[\\!-~]+(jpg|gif|png))</a>!<img src=\"$1\">!g", tmp); // img
        tmp = WebUtil.addLinkTagFTP(tmp, "_blank");
        tmp = WebUtil.addLinkTagMail(tmp);
        return tmp;
    }
}
