package jp.mobster.webapp.wiki.tag;

import org.apache.oro.text.perl.Perl5Util;

import jp.mobster.webapp.wiki.transform.DataTag;

/**
 * ImageDataTag
 * usage : IMAGE(filename) -> <img src="images/filename">
 * @version $Revision: 1.1 $ $Date: 2003/09/10 14:22:56 $
 */
public class ImageDataTag implements DataTag
{

    private static final String REGULAR_EXPRESSION = "s!IMAGE\\(([^)]*)\\)!<img src=\\\"upload/$1\\\">!g";

    /**
     * @see jp.mobster.webapp.wiki.transform.DataTag#get()
     */
    public String get(String pageData)
    {
        Perl5Util perl = new Perl5Util();

        // font size
        return perl.substitute(REGULAR_EXPRESSION, pageData);
    }

}
