package jp.mobster.webapp.wiki;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

import org.apache.turbine.util.Log;

import jp.mobster.util.CacheProperties;
import jp.mobster.util.ExtensionFilter;
import jp.mobster.util.StringUtil;
import jp.mobster.util.WebUtil;

/**
 * Wiki Data Class
 * @version $Revision: 1.1 $ $Date: 2003/09/10 14:22:20 $
 */
public class WikiData
{
    private CacheProperties properties_;

    private String basePath_; // եΥ١ѥ
    private String fileName_; //եե륿
    final private static ExtensionFilter filter_ = new ExtensionFilter();

    static {
        filter_.addExtension("txt");
    }

    //local Test
    public WikiData(String fileName)
    {
        basePath_ = "d:/project/wiki/";
        fileName_ = fileName;
        String configPath = basePath_ + "WEB-INF/conf/wiki-config.properties";
        properties_ = CacheProperties.getInstance(new File(configPath), "UTF-8");
    }

    //Yamane's local Test
    public WikiData(int dummy, String fileName)
    {
        basePath_ = "D:/eclipse-SDK-2.0.1-win32/eclipse/workspace/wiki/";
        fileName_ = fileName;
        String configPath = basePath_ + "WEB-INF/conf/wiki-config.properties";
        properties_ = CacheProperties.getInstance(new File(configPath), "UTF-8");
    }

    /**
     * 󥹥ȥ饯
     * 
     * @param basePath եѥ
     * @param fileName ե̾
     * @param properties ץѥƥ
     **/
    public WikiData(String basePath, String fileName, CacheProperties properties)
    {
        basePath_ = basePath;
        fileName_ = fileName;
        properties_ = properties;
    }

    // text = ʸ
    public static WikiData[] getWikiDatas(
        String basePath,
        CacheProperties properties,
        String orderType,
        String order,
        String text)
    {
        final File[] dataFiles = getWikiFiles(basePath, text);
        final WikiData[] datas = new WikiData[dataFiles.length];
        for (int i = 0; i < dataFiles.length; i++)
        {
            datas[i] =
                new WikiData(
                    basePath,
                    dataFiles[i].getName().substring(0, (dataFiles[i].getName().length() - ".txt".length())),
                    properties);
        }

        final WikiComparator wikiComparator;
        if (orderType.equals("title"))
        {
            wikiComparator = new TitleComparator(order);
        }
        else if (orderType.equals("subtitle"))
        {
            wikiComparator = new SubTitleComparator(order);
        }
        else
        {
            wikiComparator = new DateComparator(order);
        }

        Arrays.sort(datas, wikiComparator);

        return datas;
    }
    // оݥե
    private static File[] getWikiFiles(String basePath, String text)
    {
        File[] dataFiles = new WikiData(basePath, null, null).getContentsFileList();
        if (text == null || text.equals(""))
        {
            return dataFiles;
        }
        else
        {
            return WikiUtil.grep(dataFiles, text);
        }
    }

    public String getTitle()
    {
        return fileName_;
    }

    /**
     * ֥ȥ
     * ڡƥȤΣܤ򥵥֥ȥȤ
     * 
     * @return ֥ȥ
     */
    public String getSubtitle() throws IOException
    {
        File file = getContentsFile();
        String subTitle = "";
        BufferedReader in = null;

        try
        {
            in =
                new BufferedReader(
                    new InputStreamReader(
                        new FileInputStream(file),
                        properties_.getProperty("save.encoding", "UTF-8")));

            if (in.ready())
            {
                //ܤ򥵥֥ȥȤ
                String firstLine = in.readLine();
                if (firstLine.trim().length() > 0)
                {
                    subTitle = " - " + firstLine;
                }
            }
        }
        finally
        {
            if (in != null)
            {
                in.close();
            }
        }

        return subTitle;
    }

    /**
     * ڡƥȤμ
     * ڡեΥ󥳡ɤ Shift_JIS 
     * 
     * @return ڡƥ
     */
    public String getText() throws IOException
    {
        File file = getContentsFile();
        return getFileContents(file);
    }
    /**
     * DiffƥȤμ
     * DiffեΥ󥳡ɤ Shift_JIS 
     * 
     * @return Diffƥ
     */
    public String getDiffText() throws IOException
    {
        File file = getDiffFile();
        String text = null;
        try
        {
            text = getFileContents(file);
        }
        catch (FileNotFoundException ex)
        {
            text = "";
        }
        return text;
    }
    protected String getFileContents(File file) throws UnsupportedEncodingException, FileNotFoundException, IOException
    {
        String text = "";
        BufferedReader in = null;

        try
        {
            in =
                new BufferedReader(
                    new InputStreamReader(
                        new FileInputStream(file),
                        properties_.getProperty("save.encoding", "UTF-8")));

            StringBuffer buffer = new StringBuffer();
            String str = null;

            //ܤΤߤб
            if (in.ready())
            {
                buffer.append(in.readLine());
            }

            while ((str = in.readLine()) != null)
            {
                buffer.append("\n" + str);
            }

            text = buffer.toString();
        }
        finally
        {
            if (in != null)
            {
                in.close();
            }
        }

        return text;
    }

    /**
     * ڡƥȤ¸
     * ڡեΥ󥳡ɤ Shift_JIS 
     * 
     * @param text ¸ڡƥ
     */
    public void setText(String text) throws IOException, WikiException
    {
        setText(text, true);
    }
    /**
     * ڡƥȤ¸
     * ڡեΥ󥳡ɤ Shift_JIS 
     * 
     * @param text ¸ڡƥ
     * @param updateTime 򹹿뤫
     */
    public void setText(String text, boolean updateTime) throws IOException, WikiException
    {

        diff(text);

        File file = getContentsFile();

        if (!file.exists())
        {
            file.createNewFile();
        }
        long lastModified = file.lastModified(); // ι

        BufferedWriter out = null;

        try
        {
            out =
                new BufferedWriter(
                    new OutputStreamWriter(
                        new FileOutputStream(file),
                        properties_.getProperty("save.encoding", "UTF-8")));

            out.write(text);
            out.flush();
        }
        finally
        {
            if (out != null)
            {
                out.close();
            }
        }
        if (!updateTime)
        {
            file.setLastModified(lastModified); // ᤹
        }
    }

    /**
     * Method diff.
     * @param text
     */
    private void diff(String text) throws IOException
    {
        String oldText = null;
        try
        {
            oldText = getText();
        }
        catch (FileNotFoundException ex)
        {
            oldText = "";
        }
        String diff = "";
        try
        {
            diff = MobWikiDiffPrint.diff(oldText, StringUtil.replace(text, "\r\n", "\n"));
        }
        catch (Exception e)
        {
        }

        BufferedWriter out = null;
        File file = getDiffFile();

        try
        {
            out =
                new BufferedWriter(
                    new OutputStreamWriter(
                        new FileOutputStream(file),
                        properties_.getProperty("save.encoding", "UTF-8")));

            out.write(diff);
            out.flush();
        }
        finally
        {
            if (out != null)
            {
                out.close();
            }
        }
    }

    /**
     * ڡեμ
     * 
     * @return ڡե
     */
    private File getContentsFile()
    {
        return new File(getContentsPath());
    }

    /**
     * ڡեΥեѥ
     * 
     * @return ڡեΥեѥ
     */
    private String getContentsPath()
    {
        String filePath = basePath_ + "WEB-INF/wiki/" + fileName_ + ".txt";
        Log.info("TEST: filePath = " + filePath);
        Log.info("TEST: encoding = " + WebUtil.getPageEncoding());
        Log.info("TEST: =====================================================================");
        return basePath_ + "WEB-INF/wiki/" + fileName_ + ".txt";
        //        try
        //        {
//        Log.info(
//            "TEST: converted filePath = "
//                + new String(filePath.getBytes(WebUtil.getPageEncoding()), System.getProperty("file.encoding")));
        //            return new String(filePath.getBytes(WebUtil.getPageEncoding()), System.getProperty("file.encoding"));
        //        }
        //        catch (Throwable ex)
        //        {
        //            return filePath;
        //        }
    }

    /**
     * diffեμ
     * 
     * @return diffե
     */
    private File getDiffFile()
    {
        return new File(getDiffPath());
    }

    /**
     *diffեΥեѥ
     * 
     * @return diffեΥեѥ
     */
    private String getDiffPath()
    {
        return basePath_ + "WEB-INF/wiki/diff/" + fileName_ + ".txt";
    }

    /**
     * ڡեǽ֤μ
     * 
     * @return ǽ
     */
    public String getLastModified()
    {
        return String.valueOf(getContentsFile().lastModified());
    }
    /**
     * ڡեǽ֤μ
     * 
     * @return ǽ
     */
    public Date getLastModifiedDate()
    {
        return new Date(getContentsFile().lastModified());
    }
    /**
     * ڡեǽ֤μ
     * 
     * @return ǽ
     */
    public String getLastModifiedAsString()
    {
        return new SimpleDateFormat("yyyy-MM-dd (EEE) HH:mm:ss", new Locale("en", "")).format(getLastModifiedDate());
    }
    /**
     * ڡե¸ߥå
     * 
     * @return ¸ߤƤ뤫ɤ
     */
    public boolean isExists()
    {
        return getContentsFile().exists();
    }

    /**
     * ڡե뷴μ
     * 
     * @return 
     */
    public File[] getContentsFileList()
    {
        return (new File(basePath_ + "WEB-INF/wiki/")).listFiles(filter_);
    }

    /**
     * եκ
     */
    public void deleteFile()
    {
        getContentsFile().delete();
        getDiffFile().delete();
    }

    //unit test method.
    String getBase()
    {
        return basePath_;
    }
}
