package jp.mobster.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;

import java.net.URLEncoder;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.oro.text.perl.Perl5Util;

/**
 * Webѥ桼ƥƥ饹
 * @author <a href="mailto:agata@mobster.jp">Toshitaka Agata</a>
 * @version $Revision: 1.1 $ $Date: 2003/09/10 14:23:46 $
 */
public class WebUtil
{

    /** JISAutoDetect */
    public static final String JIS_AUTO_DETECT = "JISAutoDetect";
    /** UTF-8 */
    public static final String UTF_8 = "UTF-8";
    /** SHIFT_JIS */
    public static final String SHIFT_JIS = "Shift_JIS";
    /** MS932 */
    public static final String MS932 = "MS932";
    /** MS932 */
    public static final String MICROSOFT = "MS932";
    /** EUC-JP */
    public static final String EUC_JP = "EUC-JP";
    /** SJIS */
    public static final String SJIS = "SJIS";

    /** Perl5Util */
    private static Perl5Util perl = new Perl5Util();

    /** Page Encoding */
    private static String pageEncoding = UTF_8;

    /** Current Page */
    private static String currentURL = "";

    /** Current Page */
    private static String currentPage = "";

    // ------------------------------------------------------------
    // ʸִ
    // ------------------------------------------------------------
    /**
     * URLʸ˥󥯥ɲ
     */
    public static String addLinkTagURL(String src, String target)
    {
        return perl.substitute(
            "s!([^=^\\\"]|^)(https?\\://[\\!-~]+)!$1<a href=\"$2\" target=\"" + target + "\">$2<\\/a>!g",
            src);
    }
    /**
     * URLʸ˥󥯥ɲ
     */
    public static String addLinkTagURL(String src)
    {
        return perl.substitute("s!([^=^\\\"]|^)(https?\\://[\\!-~]+)!$1<a href=\"$2\">$2<\\/a>!g", src);
    }
    /**
     * FTPʸ˥󥯥ɲ
     */
    public static String addLinkTagFTP(String src, String target)
    {
        return perl.substitute(
            "s!([^=^\\\"]|^)(ftp?\\://[\\!-~]+)!$1<a href=\"$2\" target=\"" + target + "\">$2<\\/a>!g",
            src);
    }
    /**
     * FTPʸ˥󥯥ɲ
     */
    public static String addLinkTagFTP(String src)
    {
        return perl.substitute("s!([^=^\\\"]|^)(ftp?\\://[\\!-~]+)!$1<a href=\"$2\">$2<\\/a>!g", src);
    }
    /**
     * ᡼륢ɥ쥹˥󥯥ɲ
     */
    public static String addLinkTagMail(String src)
    {
        return perl.substitute("s!(mailto:)?([\\!-~]+\\@[\\!-~]+)!<a href=\"mailto:$2\">$1$2<\\/a>!g", src);
    }
    /**
     * ԤBRѴ
     */
    public static String addBrTag(String src)
    {
        Perl5Util perl = new Perl5Util();
        return perl.substitute("s!(.*)!$1<br>!g", src);
    }
    /**
     * ʸΥ
     */
    public static String escapeChar(String src)
    {
        String tmp = src;
        tmp = perl.substitute("s!&!&amp;!g", tmp);
        tmp = perl.substitute("s!<!&lt;!g", tmp);
        tmp = perl.substitute("s!>!&gt;!g", tmp);
        tmp = perl.substitute("s!\"!&quot;!g", tmp);
        return tmp;
    }
    /**
     * ƬΥڡ֤&nbsp;Ѵ
     * ֤ϥڡʸǴ
     */
    public static String escapeSpace(String src)
    {
        String[] lines = StringUtil.split(src, "\n");
        for (int i = 0; i < lines.length; i++)
        {
            int count = 0;
            for (int j = 0; j < lines[i].length(); j++)
            {
                String s = lines[i].substring(j, j + 1);
                if (s.equals(" "))
                {
                    count += 1;
                }
                else if (s.equals("\t"))
                {
                    count += 4;
                }
                else
                {
                    lines[i] = StringUtil.repeat("&nbsp;", count) + lines[i].substring(j);
                    break;
                }
            }
        }
        return StringUtil.join(lines, "\n");
    }
    /**
     * ƤΥ󥯥ɲ
     */
    public static String addLinkTagAll(String src)
    {
        String tmp = src;
        tmp = addLinkTagURL(tmp);
        tmp = addLinkTagFTP(tmp);
        tmp = addLinkTagMail(tmp);
        tmp = addBrTag(tmp);
        return tmp;
    }
    /**
     * NullͤʸʤСʸ֤
     */
    public static String replaceNull(String str, String newStr)
    {
        if (str == null || str.equals(""))
        {
            return newStr;
        }
        return str;
    }

    // ------------------------------------------------------------
    // 󥳡ɷ
    // ------------------------------------------------------------
    /**
     * ʸBASE64ǥ󥳡
     * @param str ʸ
     * @return 󥳡ɤ줿ʸ
     */
    public static String encodeURL(String str)
    {
        try
        {
            return URLEncoder.encode(str, pageEncoding);
        }
        catch (UnsupportedEncodingException e)
        {
            return str;
        }
    }

    /**
     * 󥳡ɤ줿ʸBASE64ǥǥ
     * @param base64Str ʸ
     * @return 󥳡ɤ줿ʸ
     */
    public static String decodeURL(String base64Str)
    {
        try
        {
            return URLDecoder.decode(base64Str, pageEncoding);
        }
        catch (UnsupportedEncodingException e)
        {
            return base64Str;
        }
    }

    // ------------------------------------------------------------
    // ѥ᡼
    // ------------------------------------------------------------

    /**
     * ʸꤵ줿ɤǥ
     */
    private static String decode(String str, String enc)
    {
        try
        {
            return new String(str.getBytes("8859_1"), enc);
        }
        catch (Throwable ex)
        {
            return str;
        }
    }

    /**
     * ꥯȤѥ᡼μʸ
     */
    public static String getParameter(HttpServletRequest request, String paramName, String enc)
    {
        return getParameter(request, paramName, "", enc);
    }
    /**
     * ꥯȤѥ᡼μʸ
     */
    public static String getParameter(HttpServletRequest request, String paramName, String defaultStr, String enc)
    {
        String value = request.getParameter(paramName);
        if (value == null || value.equals(""))
        {
            return defaultStr;
        }
        return decode(value, enc);
    }

    // ------------------------------------------------------------
    // å/åȷ
    // ------------------------------------------------------------

    /**
     * åͤ
     * ꤵ줿å¸ߤʤ硢ʸ֤ޤ
     * åͤBASE64ǥ󥳡ɤƤΤȤߤʤơ
     * BASE64ǥǥɤƼФޤ
     * @param request HttpServletRequest
     * @param name å̾
     * @return å, å¸ߤʤʸ
     */
    //    public static String getCookieValue(HttpServletRequest request, String name)
    //    {
    //        return getCookieValue(request, name, "");
    //    }
    /**
     * åͤ
     * ꤵ줿å¸ߤʤ硢ǥե֤ͤޤ
     * åͤBASE64ǥ󥳡ɤƤΤȤߤʤơ
     * BASE64ǥǥɤƼФޤ
     * @param request HttpServletRequest
     * @param name å̾
     * @param defaultValue ǥե
     * @return å, å¸ߤʤdefaltValue
     */
    //    public static String getCookieValue(HttpServletRequest request, String name, String defaultValue)
    //    {
    //        Cookie cookie = getCookie(request, name);
    //        return cookie != null ? decodeURL(cookie.getValue()) : defaultValue;
    //    }
    /**
     * åμ
     * ꤵ줿å¸ߤʤ硢null֤ޤ
     * @param request HttpServletRequest
     * @param name å̾
     * @return å, å¸ߤʤnull
     */
    public static Cookie getCookie(HttpServletRequest request, String name)
    {
        Cookie[] cookies = request.getCookies();
        if (cookies == null)
            return null;

        for (int i = 0; i < cookies.length; i++)
        {
            if (cookies[i].getName().equals(name))
                return cookies[i];
        }
        return null;
    }
    /**
     * åͤ򥻥å
     * åͤBASE64ǥ󥳡ɤƥåȤޤ
     * @param request HttpServletRequest
     * @param name å̾
     * @param name å
     */
    //    public static void setCookieValue(HttpServletResponse response, String name, String value)
    //    {
    //        response.addCookie(makeCookie(name, value));
    //    }

    /**
     * å
     * å򿷤ޤ
     * åͤBASE64ǥ󥳡ɤƥåȤޤ
     * @param request HttpServletRequest
     * @param name å̾
     * @param value å
     * @return 줿å
     */
    //    public static Cookie makeCookie(String name, String value)
    //    {
    //        Cookie cookie = new Cookie(name, encodeURL(value));
    //        return cookie;
    //    }
    /**
     * åκ
     * åޤ
     * @param request HttpServletRequest
     * @param name å̾
     */
    public static void removeCookie(HttpServletResponse response, String name)
    {
        Cookie cookie = new Cookie(name, "");
        cookie.setMaxAge(0); //¸30
        response.addCookie(cookie);
    }

    // ------------------------------------------------------------
    // ¾
    // ------------------------------------------------------------

    /** ʸSimpleDateFormat */
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    /**
     * ʸμ
     * @return 2001/01/01 10:10:10 θʸ
     */
    public static String getTimestamp()
    {
        synchronized (format)
        {
            return format.format(new Date());
        }
    }
    /**
     * @param string
     */
    public static void setPageEncoding(String string)
    {
        pageEncoding = string;
    }

    /**
     * @return
     */
    public static String getPageEncoding()
    {
        return pageEncoding;
    }

    /**
     * @return
     */
    public static String getCurrentURL()
    {
        return currentURL;
    }

    /**
     * @param string
     */
    public static void setCurrentURL(String string)
    {
        currentURL = string;
    }

    /**
     * @return
     */
    public static String getCurrentPage()
    {
        return currentPage;
    }

    /**
     * @param string
     */
    public static void setCurrentPage(String string)
    {
        currentPage = string;
    }

}