package jp.mobster.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * åץѥƥ<p>
 * εǽޤ<p>
 * 
 * <li>ץѥƥեɤ߹
 * <li>ץѥƥեΥå
 * <li>ץѥƥեΥॹפåơ
 *     ưŪ˹뵡ǽ
 * <li>ʸɤꤷƥץѥƥեɤ߹
 * 
 * <li>getIntʤɷꤷƤμ ̤
 * 
 * @author <a href="mailto:agata@mobster.jp">Toshitaka Agata</a>
 * @version $Revision: 1.1 $ $Date: 2003/09/10 14:23:46 $
 */
public class CacheProperties
{

    // ------------------------------------------------------------
    // static field
    // ------------------------------------------------------------
    /** ǥեȥե륨󥳡ǥ */
    private static final String DEFAULT_FILE_ENCODING = System.getProperty("file.encoding");

    /** å奪֥ */
    private static Map cache_ = new HashMap(); // HashMap<String, CacheProperties>

    /** NULL֥ */
    private static final String NULL_STRING = "";
    // ------------------------------------------------------------
    // instance field
    // ------------------------------------------------------------

    /** ͤΥڥ */
    private Map entry_ = new HashMap(); // HashMap<String, List>

    /** ǽ */
    private long lastModified_;

    /** ץѥƥե */
    private File file_;

    /** ʸ */
    private String charset_;

    // ------------------------------------------------------------
    // 󥹥ȥ饯
    // ------------------------------------------------------------

    /**
     * 󥹥ȥ饯
     */
    private CacheProperties(File file, String charset)
    {

        file_ = file;
        charset_ = charset;

    }

    // ------------------------------------------------------------
    // 󥹥󥹼ʥեȥ᥽åɡ
    // ------------------------------------------------------------

    /**
     * 󥹥󥹤μʥǥեȤʸɡ
     * ǥեȤΥ饹ץѥƥե򸡺ޤ
     * @param fileName ץѥƥե̾
     * @return CacheProperties 󥹥
     */
    public static CacheProperties getInstance(String fileName)
    {

        return getInstance(fileName, DEFAULT_FILE_ENCODING);

    }

    /**
     * 󥹥󥹤μʸɻ
     * ǥեȤΥ饹ץѥƥե򸡺ޤ
     * @param fileName ץѥƥե̾
     * @param charset ʸ
     * @return CacheProperties 󥹥
     */
    public static CacheProperties getInstance(String fileName, String charset)
    {

        return getInstance(fileName, charset, ClassLoader.getSystemClassLoader());

    }

    /**
     * 󥹥󥹤μʥǥեȤʸ,饹
     * 饹ꤷƥץѥƥե򸡺ޤ
     * @param fileName ץѥƥե̾
     * @param loader 饹
     * @return CacheProperties 󥹥
     */
    public static CacheProperties getInstance(String fileName, ClassLoader loader)
    {

        return getInstance(fileName, DEFAULT_FILE_ENCODING, loader);

    }

    /**
     * 󥹥󥹤μʸ,饹
     * 饹ꤷƥץѥƥե򸡺ޤ
     * @param fileName ץѥƥե̾
     * @param charset ʸ
     * @param loader 饹
     * @return CacheProperties 󥹥
     */
    public static CacheProperties getInstance(String fileName, String charset, ClassLoader loader)
    {

        String path = loader.getSystemResource(fileName).getPath();
        return getInstance(new File(path), charset);

    }

    /**
     * 󥹥󥹤μʥǥեȤʸɡ
     * եľܻꤷƥץѥƥɤ߹ߤޤ
     * @param file ץѥƥե
     * @return CacheProperties 󥹥
     */
    public static CacheProperties getInstance(File file)
    {

        return getInstance(file, DEFAULT_FILE_ENCODING);

    }

    /**
     * 󥹥󥹤μʸɻ
     * եľܻꤷƥץѥƥɤ߹ߤޤ
     * @param file ץѥƥե
     * @param charset ʸ
     * @return CacheProperties 󥹥
     */
    public static synchronized CacheProperties getInstance(File file, String charset)
    {

        CacheProperties properties = (CacheProperties) cache_.get(file.getAbsolutePath());
        if (properties == null)
        {
            // 
            properties = new CacheProperties(file, charset);
            properties.load();
            cache_.put(file.getAbsolutePath(), properties);
        }
        else
        {
            // äɤå
            // Ƥƥ
            if (properties.isUpdate())
            {
                properties.load();
            }
        }
        return properties;

    }

    // ------------------------------------------------------------
    // ǡ
    // ------------------------------------------------------------

    /**
     * ץѥƥե뤫ǡɤ߹
     * CachePropertiesޤ
     * @param charset ʸ
     */
    private void load()
    {

        clear();
        try
        {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file_), charset_));
            String str = null;
            while ((str = reader.readLine()) != null)
            {
                if (str.indexOf('#') == 0)
                    continue; // ȹ

                int pos = str.indexOf('=');
                if (pos != -1)
                {
                    String key = str.substring(0, pos);
                    String value = str.substring(pos + 1);
                    setProperty(key, value);
                }
            }
            reader.close();
            lastModified_ = file_.lastModified();
        }
        catch (UnsupportedEncodingException e)
        {
            throw new RuntimeException("CacheProperties file load error : " + e.getMessage());
        }
        catch (FileNotFoundException e)
        {
            throw new RuntimeException("CacheProperties file load error : " + e.getMessage());
        }
        catch (IOException e)
        {
            throw new RuntimeException("CacheProperties file load error : " + e.getMessage());
        }

    }

    // ------------------------------------------------------------
    // ץѥƥ
    // ------------------------------------------------------------

    /**
     * ץѥƥͤΥå
     * @param key 
     * @param value 
     */
    public synchronized void setProperty(String key, String value)
    {
        List list = (List) entry_.get(key);
        if (list == null)
        {
            list = new ArrayList();
        }
        list.add(value);

        entry_.put(key, list);

    }
    /**
     * ץѥƥͤμ
     * @param key 
     * @return String 
     */
    public synchronized String getProperty(String key)
    {

        return getProperty(key, "");

    }

    /**
     * ץѥƥͤμ
     * @param key 
     * @param defaultValue ǥե
     * @return String 
     */
    public synchronized String getProperty(String key, String defaultValue)
    {

        if (isUpdate())
        {
            load();
        }

        String value = null;
        List list = (List) entry_.get(key);
        if (list != null)
        {
            value = (String) list.get(0);
        }
        return value != null ? value : defaultValue;

    }

    /**
     * ץѥƥͤǼ
     * @param key 
     * @return String[] 
     */
    public synchronized String[] getPropertyArray(String key)
    {
        List list = (List) entry_.get(key);
        if (list == null)
            return (new String[0]);
        else
            return ((String[]) list.toArray(new String[0]));
    }

    public boolean getPropertyAsBoolean(String key)
    {
        return getPropertyAsBoolean(key, false);
    }

    public boolean getPropertyAsBoolean(String key, boolean defaultValue)
    {
        String value = getProperty(key);
        boolean result = Boolean.valueOf(value).booleanValue();
        return result ? result : defaultValue;
    }

    public int getPropertyAsInt(String key)
    {
        return getPropertyAsInt(key, 0);
    }

    public int getPropertyAsInt(String key, int defaultValue) throws NumberFormatException
    {
        String value = getProperty(key);
        return value.equals(NULL_STRING) ? defaultValue : Integer.parseInt(value);
    }

    /**
     * ץѥƥꥹȤΥꥢ
     * @return long ǽ
     */
    public synchronized void clear()
    {

        entry_.clear();

    }

    // ------------------------------------------------------------
    // Ƚ
    // ------------------------------------------------------------

    /**
     * ե뤬Ƥ뤫ɤȽ
     * @return boolean ե뤬Ƥtrue, ʳfalse
     */
    private synchronized boolean isUpdate()
    {

        return (lastModified_ != file_.lastModified() ? true : false);

    }

    // ------------------------------------------------------------
    // ᥽å
    // ------------------------------------------------------------

    /**
     * ǽμ
     * @return long ǽ
     */
    public synchronized long getLastModified()
    {

        return lastModified_;

    }

    /**
     * ǽΥå
     * @param lastModified The lastModified to set
     */
    private synchronized void setLastModified(long lastModified)
    {

        lastModified_ = lastModified;

    }

    /**
     * ե륪֥Ȥμ
     * @return File ե륪֥
     */
    public File getFile()
    {

        return file_;

    }

    /**
     * ʸɤμ
     * @return String ʸ
     */
    public String getCharset()
    {
        return charset_;
    }

    /**
     * μ
     * preturn 
     **/
    public Set keySet()
    {
        return entry_.keySet();
    }

}