package com.marevol.portlet.wiki.services;

import java.io.File;

import jp.mobster.util.CacheProperties;
import jp.mobster.util.StringUtil;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.upload.FileItem;

/**
 * ե륢åץ
 * @author user
 */
public class WikiUploadService
{
    /**
     * Static initialization of the logger for this class
     */
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(WikiUploadService.class.getName());

    //ĥ
    private static final String GIF = ".GIF";
    private static final String JPEG = ".JPEG";
    private static final String JPG = ".JPG";

    private static CacheProperties properties_ = null;

    //ե륢åץɥǥ쥯ȥ
    private static String UPLOAD_DIR;

    private static String[] extentions;

    private static boolean isInit = false;

    /**
     * .
     * 
     * @param config
     * @throws ServletException
     **/
    public static void init(RunData rundata)
    {
        String baseDir = rundata.getServletConfig().getServletContext().getRealPath("/");
        if (!baseDir.substring(baseDir.length() - 1).equals(File.separator))
        {
            baseDir += File.separator;
        }

        final String configPath = baseDir + "WEB-INF/conf/wiki-config.properties";
        properties_ = CacheProperties.getInstance(new File(configPath), "UTF-8");

        // /webapps/wiki/images/
        UPLOAD_DIR = baseDir + "upload/";

        extentions = StringUtil.split(properties_.getProperty("upload_extentions"));
        for (int i = 0; i < extentions.length; i++)
        {
            extentions[i] = "." + extentions[i].toUpperCase();
        }
        isInit = true;
    }

    public static boolean isInit()
    {
        return isInit;
    }

    /**
     * HttpꥯȡPost ᥽åɡ˽.
     * 
     * @param request
     * @param response
     * @throws ServletException
     * @throws IOException
     **/
    public static void store(RunData rundata)
    {
        try
        {
            // Ѳǽ
            if (!properties_.getPropertyAsBoolean("upload"))
            {
                printErrorPage(rundata);
                return;
            }

            ParameterParser params = rundata.getParameters();

            // Create a new file upload handler
            // Parse the request
            //            final List items = getFileUpload().parseRequest(request);
            //            final Map itemsMap = makeFileUploadMap(items);

            // Auth
            if (!properties_.getPropertyAsBoolean("user.upload.file"))
            {
                //                String myPassword = ((FileItem) itemsMap.get("mypassword")).getString();
                String myPassword = params.getString("mypassword", "");
                String password = properties_.getProperty("password");
                if (!password.equals(myPassword))
                {
                    printErrorPage(rundata);
                    return;
                }
            }

            // Process the uploaded fields
            //            FileItem file = (FileItem) itemsMap.get("file");
            FileItem file = params.getFileItem("file");
            if (isExtention(getFileName(file.getName())))
            {
                saveFile(file);
                printSuccessPage(rundata, getFileName(file.getName()));
                return;
            }

        }
        catch (NullPointerException npe)
        {
            //	    	npe.printStackTrace();
        }
        catch (IllegalArgumentException iae)
        {
            //	    	iae.printStackTrace();
        }
        catch (IllegalStateException ise)
        {
            //	    	ise.printStackTrace();
        }

        printErrorPage(rundata);
    }

    /**
     * Method makeFileUploadMap.
     * @param list
     * @return Map
     */
    //    private Map makeFileUploadMap(List items)
    //    {
    //        Map map = new HashMap();
    //        for (Iterator iter = items.iterator(); iter.hasNext();)
    //        {
    //            FileItem item = (FileItem) iter.next();
    //            map.put(item.getFieldName(), item);
    //        }
    //        return map;
    //    }

    /**
     * ץѥƥåȺѤ FileUpload 󥹥󥹼.
     * 
     * @return ץѥƥåȺѤ FileUpload 󥹥
     **/
    //    private DiskFileUpload getFileUpload()
    //    {
    //        final DiskFileUpload upload = new DiskFileUpload();
    //
    //        // Set upload parameters
    //        upload.setSizeMax(properties_.getPropertyAsInt("max_upload_size"));
    //        upload.setSizeThreshold(properties_.getPropertyAsInt("max_memory_size"));
    //        upload.setRepositoryPath(UPLOAD_DIR);
    //
    //        return upload;
    //    }

    /**
     * ե륻.
     * 
     * @param request
     * @param item оݥեǡ
     * @throws IllegalArgumentException Ʊ̾Υե뤬¸ߤ
     * @throws IllegalStateException ե륻ּ
     **/
    private static void saveFile(FileItem item) throws IllegalArgumentException, IllegalStateException
    {
        final String fileName = getFileName(item.getName());

        //ե¸ߥå
        if (new File(UPLOAD_DIR + item.getName()).exists())
        {
            throw new IllegalArgumentException("ˤΥեΥե¸ߤޤ");
        }

        try
        {
            //save
            item.write(UPLOAD_DIR + fileName);
        }
        catch (Exception e)
        {
            //			e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    /**
     * Method getFileName.
     * @param string
     * @return String
     */
    private static String getFileName(String path)
    {
        int index = StringUtil.replace(path, "/", "\\").lastIndexOf("\\");
        return path.substring(index + 1);
    }

    /**
     * ¸λΥڡɽ.
     * 
     * @param request 
     * @param response
     * @param fileName ¸ե̾
     * @throws ServletException
     * @throws IOException
     **/
    private static void printSuccessPage(RunData rundata, String fileName)
    {
        rundata.getRequest().setAttribute("pid", new String("SaveSuccess"));
        rundata.getRequest().setAttribute("img", fileName);
        //        response.sendRedirect("../index.jsp?pid=SaveSuccess&img=" + fileName);
    }

    /**
     * ¸ԻΥڡɽ.
     * 
     * @param request
     * @param response
     * @throws ServletException
     * @throws IOException
     **/
    private static void printErrorPage(RunData rundata)
    {
        rundata.getRequest().setAttribute("pid", new String("SaveError"));
        //        response.sendRedirect("../index.jsp?pid=SaveError");
    }

    /**
     * fileName γĥҤ .gif ɤ.
     * ĥҤǤȽ.
     * 
     * @param fileName
     * @return true ĥҤ .giffalse ĥҤ .gif ʳ
     **/
    private static boolean isExtention(String fileName)
    {
        final String targetFile = fileName.toUpperCase();
        for (int i = 0; i < extentions.length; i++)
        {
            if (targetFile.lastIndexOf(extentions[i]) + extentions[i].length() == targetFile.length())
            {
                return true;
            }
        }
        return false;
    }

}
