/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.tools;

import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.rcs.Archive;
import org.apache.commons.jrcs.rcs.Version;

public class JRCS {
    static Archive archive;
    static Object[] orig;
    static int n;

    public static void main(String[] args) throws Exception {
        if (args.length > 2) {
            System.err.println("usage: ");
        } else {
            archive = args.length >= 1 ? new Archive(args[0]) : new Archive("test,v", System.in);
            System.err.println();
            System.err.println("==========================================");
            orig = archive.getRevision("1.3");
            System.out.println("*-orig-*********");
            System.out.print(Diff.arrayToString(orig));
            System.out.println("**********");
            JRCS.trywith("1.2.3.1");
            JRCS.trywith("1.2.3.5");
            JRCS.trywith("1.2.3.1.");
            JRCS.trywith("1.2");
            JRCS.trywith("1.2.2");
        }
    }

    static void trywith(String ver) {
        try {
            System.out.println();
            System.out.println("-------------");
            System.out.println("Adding " + ver);
            Object[] rev = Diff.randomEdit(orig, n++);
            Version newVer = archive.addRevision(rev, ver);
            System.out.println(newVer + " added");
            if (newVer != null) {
                // empty if block
            }
            System.out.println(ver + " OK");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    static {
        n = 1;
    }
}

