/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.util.List;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.rcs.BranchNode;
import org.apache.commons.jrcs.rcs.BranchNotFoundException;
import org.apache.commons.jrcs.rcs.InvalidFileFormatException;
import org.apache.commons.jrcs.rcs.InvalidTrunkVersionNumberException;
import org.apache.commons.jrcs.rcs.Line;
import org.apache.commons.jrcs.rcs.Node;
import org.apache.commons.jrcs.rcs.NodeNotFoundException;
import org.apache.commons.jrcs.rcs.Version;

class TrunkNode
extends Node {
    TrunkNode(TrunkNode other) {
        super(other);
    }

    TrunkNode(Version vernum, TrunkNode next) throws InvalidTrunkVersionNumberException {
        super(vernum, next);
        if (vernum.size() > 2) {
            throw new InvalidTrunkVersionNumberException(vernum);
        }
    }

    public void setRCSNext(Node node) {
        super.setRCSNext(node);
        if (this.getParent() != null) {
            this.getParent().child = null;
        }
        this.parent = node;
        if (this.getParent() != null) {
            this.getParent().child = this;
        }
    }

    public Node deltaRevision() {
        return this.getChild() != null ? this.getChild() : this;
    }

    public Node nextInPathTo(Version vernum, boolean soft) throws NodeNotFoundException {
        Version branchPoint = vernum.getBase(2);
        if (this.version.isLessThan(branchPoint)) {
            if (soft) {
                return null;
            }
            throw new NodeNotFoundException(vernum);
        }
        Version thisBase = this.version.getBase(branchPoint.size());
        if (thisBase.isGreaterThan(branchPoint)) {
            return this.getParent();
        }
        if (vernum.size() > this.version.size()) {
            BranchNode branch = this.getBranch(vernum.at(this.version.size()));
            if (branch != null || soft) {
                return branch;
            }
            throw new BranchNotFoundException(vernum.getBase(this.version.size() + 1));
        }
        return null;
    }

    protected void patch0(List original, boolean annotate) throws InvalidFileFormatException, NodeNotFoundException, PatchFailedException {
        Node root = this.root();
        int it = 0;
        while (it < this.getText().length) {
            original.add(new Line(root, this.getText()[it]));
            ++it;
        }
        if (annotate && this.getParent() != null) {
            this.getParent().pathTo(root.version).patch(original, true);
        }
    }
}

