/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.text.Format;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.rcs.Line;
import org.apache.commons.jrcs.rcs.Node;
import org.apache.commons.jrcs.util.ToString;

class Lines
extends ArrayList {
    public static final Format annotationFormat = new MessageFormat("{0,,        } ({1} {2,  date,dd-MMM-yyyy}):");

    public Lines() {
    }

    public Lines(String text) {
        this(null, ToString.stringToArray(text));
    }

    public Lines(Node release, String text) {
        this(release, ToString.stringToArray(text));
    }

    public Lines(Object[] text) {
        this(null, text);
    }

    public Lines(Node release, Object[] text) {
        int i = 0;
        while (i < text.length) {
            super.add(new Line(release, text[i]));
            ++i;
        }
    }

    public boolean add(Object o) {
        return super.add((Line)o);
    }

    public Object[] toArray() {
        return this.toArray(false);
    }

    public Object[] toArray(boolean annotate) {
        Object[] result = new Object[this.size()];
        Iterator r = ((AbstractList)this).iterator();
        int i = 0;
        while (r.hasNext()) {
            Line l = (Line)r.next();
            Object o = l.getText();
            if (annotate) {
                Node rev = l.getRevision();
                o = annotationFormat.format(new Object[]{rev.getVersion(), rev.getAuthor(), rev.getDate()});
            }
            result[i++] = o;
        }
        return result;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean annotate) {
        return Diff.arrayToString(this.toArray(annotate));
    }
}

