/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.jrcs.rcs.Archive;
import org.apache.commons.jrcs.rcs.ArchiveParserConstants;
import org.apache.commons.jrcs.rcs.ArchiveParserTokenManager;
import org.apache.commons.jrcs.rcs.Node;
import org.apache.commons.jrcs.rcs.ParseException;
import org.apache.commons.jrcs.rcs.SimpleCharStream;
import org.apache.commons.jrcs.rcs.Token;
import org.apache.commons.jrcs.rcs.Version;

class ArchiveParser
implements ArchiveParserConstants {
    static final String ident = "RCS ArchiveParser Parser $version$:";
    public ArchiveParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;

    public static void main(String[] args) {
        ArchiveParser parser;
        if (args.length == 0) {
            System.out.println("RCS ArchiveParser Parser $version$:  Reading from standard input . . .");
            parser = new ArchiveParser(System.in);
        } else if (args.length == 1) {
            System.out.println("RCS ArchiveParser Parser $version$:  Reading from file " + args[0] + " . . .");
            try {
                parser = new ArchiveParser(new FileInputStream(args[0]));
            }
            catch (FileNotFoundException e) {
                System.out.println("RCS ArchiveParser Parser $version$:  File " + args[0] + " not found.");
                return;
            }
        } else {
            System.out.println("RCS ArchiveParser Parser $version$:  Usage is one of:");
            System.out.println("         java ArchiveParser < inputfile");
            System.out.println("OR");
            System.out.println("         java ArchiveParser inputfile");
            return;
        }
        parser.parse();
    }

    public static void load(Archive arc, InputStream input) throws ParseException {
        ArchiveParser parser = new ArchiveParser(input);
        parser.archive(arc);
    }

    public static void load(Archive arc, String fname) throws FileNotFoundException, ParseException {
        ArchiveParser.load(arc, new FileInputStream(fname));
    }

    public void parse() {
        try {
            this.archive(null);
            System.out.println("RCS ArchiveParser Parser version 1.1:  RCS ArchiveParser parsed successfully.");
        }
        catch (ParseException e) {
            System.out.println("RCS ArchiveParser Parser version 1.1:  Encountered errors during parse.");
        }
    }

    public final void archive(Archive arc) throws ParseException {
        this.admin(arc);
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 27: {
                    break;
                }
                default: {
                    break block6;
                }
            }
            this.delta(arc);
        }
        this.desc(arc);
        block7: while (true) {
            switch (this.jj_nt.kind) {
                case 27: {
                    break;
                }
                default: {
                    break block7;
                }
            }
            this.text(arc);
        }
        this.jj_consume_token(0);
    }

    public final void admin(Archive arc) throws ParseException {
        this.head(arc);
        switch (this.jj_nt.kind) {
            case 8: {
                this.branch(arc);
                break;
            }
        }
        this.access(arc);
        this.symbols(arc);
        this.locks(arc);
        this.optionals(arc);
    }

    public final void optionals(Archive arc) throws ParseException {
        block9: {
            block8: while (true) {
                switch (this.jj_nt.kind) {
                    case 10: 
                    case 13: 
                    case 22: {
                        break;
                    }
                    default: {
                        break block9;
                    }
                }
                switch (this.jj_nt.kind) {
                    case 10: {
                        this.comment(arc);
                        continue block8;
                    }
                    case 13: {
                        this.expand(arc);
                        continue block8;
                    }
                    case 22: {
                        this.newPhrase(arc.phrases);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void newPhrases(Map map) throws ParseException {
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 22: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.newPhrase(map);
        }
    }

    public final void head(Archive arc) throws ParseException {
        this.jj_consume_token(14);
        switch (this.jj_nt.kind) {
            case 27: {
                Version v = this.version();
                arc.setHead(v);
                break;
            }
        }
        this.jj_consume_token(28);
    }

    public final void branch(Archive arc) throws ParseException {
        this.jj_consume_token(8);
        switch (this.jj_nt.kind) {
            case 27: {
                Version v = this.version();
                arc.setBranch(v);
                break;
            }
        }
        this.jj_consume_token(28);
    }

    public final void access(Archive arc) throws ParseException {
        this.jj_consume_token(6);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 22: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            String name = this.id();
            arc.addUser(name);
        }
        this.jj_consume_token(28);
    }

    public final void symbols(Archive arc) throws ParseException {
        this.jj_consume_token(20);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 22: 
                case 23: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            String s = this.sym();
            this.jj_consume_token(29);
            Version v = this.version();
            arc.addSymbol(s, v);
        }
        this.jj_consume_token(28);
    }

    public final void locks(Archive arc) throws ParseException {
        this.jj_consume_token(15);
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 22: {
                    break;
                }
                default: {
                    break block6;
                }
            }
            String name = this.id();
            this.jj_consume_token(29);
            Version v = this.version();
            arc.addLock(name, v);
        }
        this.jj_consume_token(28);
        switch (this.jj_nt.kind) {
            case 19: {
                this.jj_consume_token(19);
                this.jj_consume_token(28);
                arc.setStrictLocking(true);
                break;
            }
        }
    }

    public final void comment(Archive arc) throws ParseException {
        this.jj_consume_token(10);
        switch (this.jj_nt.kind) {
            case 24: {
                String s = this.string();
                arc.setComment(s);
                break;
            }
        }
        this.jj_consume_token(28);
    }

    public final void expand(Archive arc) throws ParseException {
        this.jj_consume_token(13);
        switch (this.jj_nt.kind) {
            case 24: {
                String s = this.string();
                arc.setExpand(s);
                break;
            }
        }
        this.jj_consume_token(28);
    }

    public final void newPhrase(Map map) throws ParseException {
        StringBuffer values = new StringBuffer();
        String key = this.id();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 22: 
                case 24: 
                case 27: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            String value = this.word();
            values.append(" " + value);
        }
        this.jj_consume_token(28);
        if (map != null) {
            map.put(key, values.toString());
        }
    }

    public final String word() throws ParseException {
        String result = this.simpleWord();
        switch (this.jj_nt.kind) {
            case 29: {
                String right = this.range();
                result = result + right;
                break;
            }
        }
        return result;
    }

    public final String simpleWord() throws ParseException {
        String result;
        switch (this.jj_nt.kind) {
            case 22: {
                result = this.id();
                break;
            }
            case 27: {
                Version v = this.version();
                result = v.toString();
                break;
            }
            case 24: {
                result = this.string();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final String range() throws ParseException {
        this.jj_consume_token(29);
        String rightSide = this.simpleWord();
        return ":" + rightSide;
    }

    public final void desc(Archive arc) throws ParseException {
        this.jj_consume_token(12);
        String s = this.string();
        arc.setDesc(s);
    }

    public final void delta(Archive arc) throws ParseException {
        Version v = this.version();
        Node node = arc.newNode(v);
        this.jj_consume_token(11);
        int[] d = this.date();
        node.setDate(d);
        this.jj_consume_token(28);
        this.jj_consume_token(7);
        String s = this.id();
        node.setAuthor(s);
        this.jj_consume_token(28);
        this.jj_consume_token(18);
        switch (this.jj_nt.kind) {
            case 22: {
                s = this.id();
                node.setState(s);
                break;
            }
        }
        this.jj_consume_token(28);
        this.jj_consume_token(9);
        block9: while (true) {
            switch (this.jj_nt.kind) {
                case 27: {
                    break;
                }
                default: {
                    break block9;
                }
            }
            v = this.version();
            node.addBranch(arc.newBranchNode(v));
        }
        this.jj_consume_token(28);
        this.jj_consume_token(17);
        switch (this.jj_nt.kind) {
            case 27: {
                v = this.version();
                node.setRCSNext(arc.newNode(v));
                break;
            }
        }
        this.jj_consume_token(28);
        this.newPhrases(node.phrases);
    }

    public final void text(Archive arc) throws ParseException {
        Version v = this.version();
        Node node = arc.getNode(v);
        this.jj_consume_token(16);
        String log = this.string();
        node.setLog(log);
        this.newPhrases(node.phrases);
        this.jj_consume_token(21);
        String txt = this.string();
        node.setText(txt);
    }

    public final String id() throws ParseException {
        Token t = this.jj_consume_token(22);
        return t.image;
    }

    public final String sym() throws ParseException {
        Token t;
        switch (this.jj_nt.kind) {
            case 23: {
                t = this.jj_consume_token(23);
                break;
            }
            case 22: {
                t = this.jj_consume_token(22);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t.image;
    }

    public final Version version() throws ParseException {
        int n = this.num();
        Version v = new Version(n);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 30: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.jj_consume_token(30);
            n = this.num();
            v.__addBranch(n);
        }
        return v;
    }

    public final int[] date() throws ParseException {
        int[] n = new int[6];
        n[0] = this.num();
        this.jj_consume_token(30);
        n[1] = this.num();
        this.jj_consume_token(30);
        n[2] = this.num();
        this.jj_consume_token(30);
        n[3] = this.num();
        this.jj_consume_token(30);
        n[4] = this.num();
        this.jj_consume_token(30);
        n[5] = this.num();
        return n;
    }

    public final int num() throws ParseException {
        Token t = this.jj_consume_token(27);
        return Integer.parseInt(t.image);
    }

    public final String string() throws ParseException {
        Token t = this.jj_consume_token(24);
        return Archive.unquoteString(t.image);
    }

    public ArchiveParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ArchiveParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    public ArchiveParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ArchiveParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    public ArchiveParser(ArchiveParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    public void ReInit(ArchiveParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == kind) {
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = oldToken;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    public final ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? ArchiveParserConstants.tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

