/*
 * Decompiled with CFR 0.152.
 */
package jp.mobster.webapp.wiki.transform;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.mobster.util.CacheProperties;
import jp.mobster.util.ExtensionFilter;
import jp.mobster.util.StringUtil;
import jp.mobster.util.WebUtil;
import jp.mobster.webapp.wiki.transform.BasicDataLine;
import jp.mobster.webapp.wiki.transform.DataLine;
import jp.mobster.webapp.wiki.transform.DataLineComparator;
import jp.mobster.webapp.wiki.transform.DataTag;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.PatternMatcherInput;

public class WikiTransformer {
    String basePath_;
    String str_;
    File[] files_;
    CacheProperties properties_;
    Map lineMap_ = new HashMap();
    String[] keywords_;
    String[] dataTags_;

    public WikiTransformer(String basePath, String str, File[] files) {
        this.basePath_ = basePath;
        this.str_ = str;
        this.files_ = files;
        this.init();
    }

    private void init() {
        String configPath = this.basePath_ + "WEB-INF/conf/wiki-tag.properties";
        this.properties_ = CacheProperties.getInstance(new File(configPath), "UTF-8");
        Iterator i = this.properties_.keySet().iterator();
        while (i.hasNext()) {
            String keyword = (String)i.next();
            if (keyword.indexOf("tag.") != -1) continue;
            this.lineMap_.put(keyword, this.properties_.getProperty(keyword));
        }
        this.keywords_ = this.lineMap_.keySet().toArray(new String[0]);
        Arrays.sort(this.keywords_, new DataLineComparator());
        this.dataTags_ = this.properties_.getPropertyArray("tag");
    }

    private String addWikiTagURLEscape(String src) {
        String pageName;
        String tmp = src;
        Perl5Util util = new Perl5Util();
        int i = 0;
        while (i < this.files_.length) {
            pageName = ExtensionFilter.removeExtention(this.files_[i].getName());
            if (WikiTransformer.isAutoLink(pageName)) {
                tmp = util.substitute("s!([^=^\\\"]|^)(" + pageName + ")!$1ENCODE{$2}ENCODE!g", tmp);
                tmp = util.substitute("s!([^=^\\\"]|^)\\[\\[(ENCODE{" + pageName + "}ENCODE)\\]\\]!$1$2!g", tmp);
            } else {
                tmp = util.substitute("s!([^=^\\\"]|^)\\[\\[(" + pageName + ")\\]\\]!$1ENCODE{$2}ENCODE!g", tmp);
            }
            tmp = util.substitute("s!([^=^\\\"]|^)\\[\\[" + pageName + "\\]\\]!$1ENCODE{$2}ENCODE!g", tmp);
            ++i;
        }
        PatternMatcherInput input = new PatternMatcherInput(tmp);
        while (util.match("m!\\[\\[(.*)\\]\\]!", input)) {
            pageName = util.group(1);
            tmp = util.substitute("s!([^=^\\\"]|^)\\[\\[(" + pageName + ")\\]\\]!$1ENCODE2{$2}ENCODE2!g", tmp);
        }
        return tmp;
    }

    static boolean isAutoLink(String pageName) {
        if (!StringUtil.containsChar(pageName, "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")) {
            return false;
        }
        int upper = 0;
        int i = 0;
        while (i < pageName.length()) {
            char c = pageName.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                ++upper;
            }
            ++i;
        }
        return upper > 1;
    }

    private String addWikiTagURL(String src) {
        String pageName;
        String tmp = src;
        Perl5Util util = new Perl5Util();
        int i = 0;
        while (i < this.files_.length) {
            pageName = ExtensionFilter.removeExtention(this.files_[i].getName());
            tmp = util.substitute("s!(ENCODE{" + pageName + "}ENCODE)!<a href=" + WebUtil.getCurrentURL() + "?pid=" + WebUtil.encodeURL(pageName) + ">" + pageName + "</a>!g", tmp);
            ++i;
        }
        PatternMatcherInput input = new PatternMatcherInput(tmp);
        while (util.match("m!\\ENCODE2{(.*)}ENCODE2!", input)) {
            pageName = util.group(1);
            tmp = util.substitute("s!ENCODE2{(" + pageName + ")}ENCODE2!<a href=" + WebUtil.getCurrentURL() + "?wiki_action=create&pid=" + WebUtil.encodeURL(pageName) + ">?</a>$1" + "!g", tmp);
        }
        return tmp;
    }

    private String getReplacedSimpleTags() {
        try {
            Perl5Util perl = new Perl5Util();
            String tmp = this.str_ + "\n";
            int i = 0;
            while (i < this.dataTags_.length) {
                tmp = this.createDataTag(this.dataTags_[i]).get(tmp);
                ++i;
            }
            return tmp;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private DataTag createDataTag(String dataTag) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (DataTag)Class.forName(dataTag).newInstance();
    }

    public String transform() {
        try {
            StringBuffer buf = new StringBuffer();
            this.str_ = this.addWikiTagURLEscape(this.str_);
            String[] datas = StringUtil.split(this.getReplacedSimpleTags(), "\n");
            DataLine dataLine = new BasicDataLine();
            dataLine.init("");
            int i = 0;
            while (i < datas.length) {
                String data = datas[i];
                DataLine newLine = this.getDataLine(data);
                buf.append(dataLine.closeTag(newLine));
                buf.append(newLine.openTag(dataLine));
                dataLine = newLine;
                buf.append(dataLine.get());
                ++i;
            }
            return this.addWikiTagURL(buf.toString());
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private DataLine getDataLine(String data) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        int i = 0;
        while (i < this.keywords_.length) {
            String keyword = this.keywords_[i];
            if (WikiTransformer.fastIndex(data, keyword)) {
                DataLine dataLine = this.createDataLine((String)this.lineMap_.get(keyword));
                dataLine.init(data);
                return dataLine;
            }
            ++i;
        }
        BasicDataLine dataLine = new BasicDataLine();
        dataLine.init(data);
        return dataLine;
    }

    private DataLine createDataLine(String dataLine) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (DataLine)Class.forName(dataLine).newInstance();
    }

    private static boolean fastIndex(String str, String keyword) {
        int index = str.indexOf(keyword);
        return index == 0;
    }
}

