/*
 * Decompiled with CFR 0.152.
 */
package jp.mobster.webapp.wiki.transform;

import jp.mobster.webapp.wiki.transform.DataLine;

public class ULDataLine
implements DataLine {
    protected String keyword_;
    protected String lineData_;
    protected String dataHoldTag_ = "li";
    protected String outerHoldTag_ = "ul";
    protected String baseSpaces_;

    public void init(String lineData) {
        if (lineData.indexOf("---") == 0) {
            this.keyword_ = "---";
            this.baseSpaces_ = "  ";
        } else if (lineData.indexOf("--") == 0) {
            this.keyword_ = "--";
            this.baseSpaces_ = " ";
        } else {
            this.keyword_ = "-";
            this.baseSpaces_ = "";
        }
        this.lineData_ = lineData.substring(this.getKeyword().length());
    }

    public String getKeyword() {
        return this.keyword_;
    }

    public String openTag(DataLine oldLine) {
        if (oldLine != null && oldLine instanceof ULDataLine) {
            ULDataLine oldULLine = (ULDataLine)oldLine;
            int depth = this.getKeyword().length() - oldULLine.getKeyword().length();
            switch (depth) {
                case 0: {
                    return "";
                }
                case 1: {
                    return this.baseSpaces_ + "<" + this.outerHoldTag_ + ">\n";
                }
                case 2: {
                    return " <" + this.outerHoldTag_ + ">\n" + this.baseSpaces_ + "<" + this.outerHoldTag_ + ">\n";
                }
            }
            return "";
        }
        int depth = this.getKeyword().length();
        switch (depth) {
            case 1: {
                return this.baseSpaces_ + "<" + this.outerHoldTag_ + ">\n";
            }
            case 2: {
                return "<" + this.outerHoldTag_ + ">\n" + this.baseSpaces_ + "<" + this.outerHoldTag_ + ">\n";
            }
            case 3: {
                return "<" + this.outerHoldTag_ + ">\n" + " <" + this.outerHoldTag_ + ">\n" + this.baseSpaces_ + "<" + this.outerHoldTag_ + ">\n";
            }
        }
        return "";
    }

    private String getBaseSpaces(int spaceNum) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < spaceNum) {
            buf.append(" ");
            ++i;
        }
        return buf.toString();
    }

    public String closeTag(DataLine newLine) {
        if (newLine != null && newLine instanceof ULDataLine) {
            ULDataLine oldULLine = (ULDataLine)newLine;
            int depth = this.getKeyword().length() - newLine.getKeyword().length();
            switch (depth) {
                case 0: {
                    return "";
                }
                case 1: {
                    return this.baseSpaces_ + "</" + this.outerHoldTag_ + ">\n";
                }
                case 2: {
                    return this.baseSpaces_ + "</" + this.outerHoldTag_ + ">\n" + " </" + this.outerHoldTag_ + ">\n";
                }
            }
            return "";
        }
        int depth = this.getKeyword().length();
        switch (depth) {
            case 1: {
                return this.baseSpaces_ + "</" + this.outerHoldTag_ + ">\n";
            }
            case 2: {
                return this.baseSpaces_ + "</" + this.outerHoldTag_ + ">\n" + "</" + this.outerHoldTag_ + ">\n";
            }
            case 3: {
                return this.baseSpaces_ + "</" + this.outerHoldTag_ + ">\n" + " </" + this.outerHoldTag_ + ">\n" + "</" + this.outerHoldTag_ + ">\n";
            }
        }
        return "";
    }

    public String get() {
        return this.baseSpaces_ + "<" + this.dataHoldTag_ + ">" + this.lineData_ + "</" + this.dataHoldTag_ + ">\n";
    }
}

