/*
 * Decompiled with CFR 0.152.
 */
package jp.mobster.webapp.wiki.transform;

import java.util.ArrayList;
import jp.mobster.util.StringUtil;
import jp.mobster.webapp.wiki.transform.DataLine;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.PatternMatcherInput;

public class TableDataLine
implements DataLine {
    private String keyword_ = ",";
    private String lineData_;
    private String dataHoldTag_ = "tr";
    private String outerHoldTag_ = "table";

    public void init(String lineData) {
        ArrayList<String> list = new ArrayList<String>();
        Perl5Util util = new Perl5Util();
        PatternMatcherInput input = new PatternMatcherInput(lineData);
        while (util.match("m!([^,](\\\\,)?)+|$!", input)) {
            String s = util.group(0);
            s = s == null ? "" : StringUtil.replace(s, "\\,", ",");
            list.add(s);
        }
        String[] cells = list.toArray(new String[list.size()]);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < cells.length) {
            buf.append("<td>" + this.makeCellContent(cells[i]) + "</td>");
            ++i;
        }
        this.lineData_ = buf.toString();
    }

    private String makeCellContent(String cell) {
        if (cell.length() < 2) {
            return cell;
        }
        if (cell.indexOf("&gt;&gt;") == 0) {
            return "<div align=right>" + cell.substring(8) + "</div>";
        }
        if (cell.indexOf("&gt;") == 0) {
            return "<div align=center>" + cell.substring(4) + "</div>";
        }
        return cell;
    }

    public String getKeyword() {
        return this.keyword_;
    }

    public String openTag(DataLine oldLine) {
        if (oldLine != null && oldLine instanceof TableDataLine) {
            return "";
        }
        return "<" + this.outerHoldTag_ + ">\n";
    }

    public String closeTag(DataLine newLine) {
        if (newLine != null && !(newLine instanceof TableDataLine)) {
            return "</" + this.outerHoldTag_ + ">\n";
        }
        return "";
    }

    public String get() {
        return "<" + this.dataHoldTag_ + ">" + this.lineData_ + "</" + this.dataHoldTag_ + ">\n";
    }
}

