/*
 * Decompiled with CFR 0.152.
 */
package jp.mobster.webapp.wiki.transform;

import jp.mobster.util.StringUtil;
import jp.mobster.webapp.wiki.transform.DataLine;

public class DefinitionDataLine
implements DataLine {
    private String keyword_ = ":";
    private String lineData_;
    private String dataHoldTag_ = "";
    private String outerHoldTag_ = "dl";

    public void init(String lineData) {
        String[] cells = StringUtil.split(lineData.substring(1), ":");
        StringBuffer buf = new StringBuffer();
        if (cells.length > 0) {
            buf.append("<dt>" + cells[0] + "</dt>");
        }
        if (cells.length > 1) {
            buf.append("<dd>" + cells[1] + "</dd>");
        }
        this.lineData_ = buf.toString();
    }

    public String getKeyword() {
        return this.keyword_;
    }

    public String openTag(DataLine oldLine) {
        if (oldLine != null && oldLine instanceof DefinitionDataLine) {
            return "";
        }
        return "<" + this.outerHoldTag_ + ">\n";
    }

    public String closeTag(DataLine newLine) {
        if (newLine != null && !(newLine instanceof DefinitionDataLine)) {
            return "</" + this.outerHoldTag_ + ">\n";
        }
        return "";
    }

    public String get() {
        return this.lineData_ + "\n";
    }
}

