/*
 * Decompiled with CFR 0.152.
 */
package jp.mobster.webapp.wiki.transform;

import jp.mobster.webapp.wiki.transform.DataLine;

public class BlockquoteDataLine
implements DataLine {
    private String keyword_;
    private String lineData_;
    private String dataHoldTag_ = "";
    private String outerHoldTag_ = "blockquote";
    private String baseSpaces_;

    public void init(String lineData) {
        int length = 0;
        if (lineData.indexOf("&gt;&gt;&gt;") == 0) {
            this.keyword_ = ">>>";
            this.baseSpaces_ = "  ";
            length = 12;
        } else if (lineData.indexOf("&gt;&gt;") == 0) {
            this.keyword_ = ">>";
            this.baseSpaces_ = " ";
            length = 8;
        } else {
            this.keyword_ = ">";
            this.baseSpaces_ = "";
            length = 4;
        }
        this.lineData_ = lineData.substring(length);
    }

    public String getKeyword() {
        return this.keyword_;
    }

    public String openTag(DataLine oldLine) {
        if (oldLine != null && oldLine instanceof BlockquoteDataLine) {
            BlockquoteDataLine oldBlockquoteLine = (BlockquoteDataLine)oldLine;
            int depth = this.getKeyword().length() - oldBlockquoteLine.getKeyword().length();
            switch (depth) {
                case 0: {
                    return "";
                }
                case 1: {
                    return this.baseSpaces_ + "<" + this.outerHoldTag_ + ">\n";
                }
                case 2: {
                    return " <" + this.outerHoldTag_ + ">\n" + this.baseSpaces_ + "<" + this.outerHoldTag_ + ">\n";
                }
            }
            return "";
        }
        int depth = this.getKeyword().length();
        switch (depth) {
            case 1: {
                return this.baseSpaces_ + "<" + this.outerHoldTag_ + ">\n";
            }
            case 2: {
                return "<" + this.outerHoldTag_ + ">\n" + this.baseSpaces_ + "<" + this.outerHoldTag_ + ">\n";
            }
            case 3: {
                return "<" + this.outerHoldTag_ + ">\n" + " <" + this.outerHoldTag_ + ">\n" + this.baseSpaces_ + "<" + this.outerHoldTag_ + ">\n";
            }
        }
        return "";
    }

    private String getBaseSpaces(int spaceNum) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < spaceNum) {
            buf.append(" ");
            ++i;
        }
        return buf.toString();
    }

    public String closeTag(DataLine newLine) {
        if (newLine != null && newLine instanceof BlockquoteDataLine) {
            BlockquoteDataLine oldULLine = (BlockquoteDataLine)newLine;
            int depth = this.getKeyword().length() - newLine.getKeyword().length();
            switch (depth) {
                case 0: {
                    return "";
                }
                case 1: {
                    return this.baseSpaces_ + "</" + this.outerHoldTag_ + ">\n";
                }
                case 2: {
                    return this.baseSpaces_ + "</" + this.outerHoldTag_ + ">\n" + " </" + this.outerHoldTag_ + ">\n";
                }
            }
            return "";
        }
        int depth = this.getKeyword().length();
        switch (depth) {
            case 1: {
                return this.baseSpaces_ + "</" + this.outerHoldTag_ + ">\n";
            }
            case 2: {
                return this.baseSpaces_ + "</" + this.outerHoldTag_ + ">\n" + "</" + this.outerHoldTag_ + ">\n";
            }
            case 3: {
                return this.baseSpaces_ + "</" + this.outerHoldTag_ + ">\n" + " </" + this.outerHoldTag_ + ">\n" + "</" + this.outerHoldTag_ + ">\n";
            }
        }
        return "";
    }

    public String get() {
        return this.baseSpaces_ + this.lineData_ + "<br>\n";
    }
}

