/*
 * Decompiled with CFR 0.152.
 */
package jp.mobster.webapp.wiki.transform;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jp.mobster.webapp.wiki.transform.DataLine;
import jp.mobster.webapp.wiki.transform.DataLineComparator;

public class BasicDataLine
implements DataLine {
    private String keyword_;
    private String lineData_;
    private String dataHoldTag_;
    private String baseSpaces_ = "";
    private static final Map tagMap_ = new HashMap();
    private static final String[] tags_;

    public void init(String lineData) {
        int i = 0;
        while (i < tags_.length) {
            String tempKey = tags_[i];
            if (BasicDataLine.fastIndex(lineData, tempKey)) {
                this.keyword_ = tempKey;
                this.lineData_ = lineData.substring(this.keyword_.length());
                this.dataHoldTag_ = (String)tagMap_.get(tempKey);
                break;
            }
            ++i;
        }
        if (this.keyword_ == null) {
            this.keyword_ = "";
            this.lineData_ = lineData;
            this.dataHoldTag_ = "";
        }
    }

    public String getKeyword() {
        return this.keyword_;
    }

    public String openTag(DataLine oldLine) {
        return "";
    }

    public String closeTag(DataLine newLine) {
        return "";
    }

    public String get() {
        if (this.dataHoldTag_.length() > 0) {
            return this.baseSpaces_ + "<" + this.dataHoldTag_ + ">" + this.lineData_ + "</" + this.dataHoldTag_ + ">\n";
        }
        return this.baseSpaces_ + this.lineData_ + "<br>\n";
    }

    private static boolean fastIndex(String str, String keyword) {
        int index = str.indexOf(keyword);
        return index == 0;
    }

    static {
        tagMap_.put("----", "hr");
        tagMap_.put("**", "h3");
        tagMap_.put("*", "h2");
        tags_ = tagMap_.keySet().toArray(new String[0]);
        Arrays.sort(tags_, new DataLineComparator());
    }
}

