/*
 * Decompiled with CFR 0.152.
 */
package jp.mobster.webapp.wiki.tag;

import jp.mobster.util.StringUtil;
import jp.mobster.util.WebUtil;
import jp.mobster.webapp.wiki.transform.DataTag;

public class ShortCutDataTag
implements DataTag {
    public String get(String pageData) {
        StringBuffer buffer = new StringBuffer();
        String[] datas = StringUtil.split(pageData, "\n");
        int count = 0;
        int i = 0;
        while (i < datas.length) {
            String name;
            if (ShortCutDataTag.fastIndex(datas[i], "#NOSHORTCUT")) {
                datas = this.removeArray(datas, i);
                return StringUtil.join(datas, "\n");
            }
            if (ShortCutDataTag.fastIndex(datas[i], "**")) {
                name = "i" + count;
                buffer.append("--" + this.makeShortCutAnchorTag(name, datas[i].substring(2)) + "\n");
                datas[i] = datas[i] + this.makeAnchorNameTag(name);
                ++count;
            } else if (ShortCutDataTag.fastIndex(datas[i], "*")) {
                name = "i" + count;
                buffer.append("-" + this.makeShortCutAnchorTag(name, datas[i].substring(1)) + "\n");
                datas[i] = datas[i] + this.makeAnchorNameTag(name);
                ++count;
            }
            ++i;
        }
        buffer.append(StringUtil.join(datas, "\n"));
        return buffer.toString();
    }

    private String[] removeArray(String[] src, int pos) {
        String[] dest = new String[src.length - 1];
        int i = 0;
        int index = 0;
        while (i < src.length) {
            if (i != pos) {
                dest[index] = src[i];
                ++index;
            }
            ++i;
        }
        return dest;
    }

    private String makeShortCutAnchorTag(String name, String text) {
        return "<a href=\"" + WebUtil.getCurrentURL() + "?pid=" + WebUtil.encodeURL(WebUtil.getCurrentPage()) + "#" + name + "\">" + text + "</a>";
    }

    private String makeAnchorNameTag(String name) {
        return "<a name=\"" + name + "\"> </a>";
    }

    private static boolean fastIndex(String str, String keyword) {
        int index = str.indexOf(keyword);
        return index == 0;
    }
}

