/*
 * Decompiled with CFR 0.152.
 */
package jp.mobster.webapp.wiki;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import jp.mobster.util.ExtensionFilter;
import jp.mobster.util.WebUtil;

public class WikiUtil {
    private static final String SEP = File.separator;
    private static final int WIKI_NAME_MIN_LENGTH = 1;

    public static boolean validWikiWordName(String name) {
        if (name == null) {
            return false;
        }
        if (name.length() < 1) {
            return false;
        }
        if (name.indexOf(92) != -1) {
            return false;
        }
        if (name.indexOf(47) != -1) {
            return false;
        }
        return name.indexOf(46) == -1;
    }

    public static File[] grep(File dir, String text) throws IOException {
        ExtensionFilter filter = new ExtensionFilter("txt");
        File[] files = dir.listFiles(filter);
        return WikiUtil.grep(files, text);
    }

    public static File[] grep(File[] files, String text) {
        ArrayList<File> list = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (WikiUtil.find(file, text)) {
                list.add(file);
            }
            ++i;
        }
        return list.toArray(new File[0]);
    }

    public static boolean find(File file, String text) {
        if (WikiUtil.find(file.getName(), text)) {
            return true;
        }
        boolean flg = false;
        try {
            flg = WikiUtil.find(new InputStreamReader((InputStream)new FileInputStream(file), "Shift_JIS"), text);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return flg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean find(Reader reader, String text) throws IOException {
        BufferedReader in;
        block4: {
            boolean bl;
            if (text == null) return false;
            if (text.equals("")) {
                return false;
            }
            in = null;
            try {
                in = new BufferedReader(reader);
                String str = null;
                do {
                    if ((str = in.readLine()) != null) continue;
                    break block4;
                } while (!WikiUtil.find(str, text));
                bl = true;
                Object var6_5 = null;
                if (in == null) return bl;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return bl;
        }
        Object var6_6 = null;
        if (in == null) return false;
        in.close();
        return false;
    }

    public static boolean find(String str, String text) {
        return WikiUtil.find(str, text, true);
    }

    public static boolean find(String str, String text, boolean flg) {
        if (text == null || text.equals("")) {
            return false;
        }
        if (flg) {
            return str.toUpperCase().indexOf(text.toUpperCase()) != -1;
        }
        return str.indexOf(text) != -1;
    }

    public static String getStackTrace(Throwable ex) throws IOException {
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        String str = writer.getBuffer().toString();
        str = WebUtil.addBrTag(str);
        str = WebUtil.escapeSpace(str);
        return str;
    }
}

