/*
 * Decompiled with CFR 0.152.
 */
package jp.mobster.webapp.wiki;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import jp.mobster.util.CacheProperties;
import jp.mobster.util.ExtensionFilter;
import jp.mobster.util.StringUtil;
import jp.mobster.util.WebUtil;
import jp.mobster.webapp.wiki.DateComparator;
import jp.mobster.webapp.wiki.MobWikiDiffPrint;
import jp.mobster.webapp.wiki.SubTitleComparator;
import jp.mobster.webapp.wiki.TitleComparator;
import jp.mobster.webapp.wiki.WikiComparator;
import jp.mobster.webapp.wiki.WikiException;
import jp.mobster.webapp.wiki.WikiUtil;
import org.apache.turbine.util.Log;

public class WikiData {
    private CacheProperties properties_;
    private String basePath_;
    private String fileName_;
    private static final ExtensionFilter filter_ = new ExtensionFilter();

    public WikiData(String fileName) {
        this.basePath_ = "d:/project/wiki/";
        this.fileName_ = fileName;
        String configPath = this.basePath_ + "WEB-INF/conf/wiki-config.properties";
        this.properties_ = CacheProperties.getInstance(new File(configPath), "UTF-8");
    }

    public WikiData(int dummy, String fileName) {
        this.basePath_ = "D:/eclipse-SDK-2.0.1-win32/eclipse/workspace/wiki/";
        this.fileName_ = fileName;
        String configPath = this.basePath_ + "WEB-INF/conf/wiki-config.properties";
        this.properties_ = CacheProperties.getInstance(new File(configPath), "UTF-8");
    }

    public WikiData(String basePath, String fileName, CacheProperties properties) {
        this.basePath_ = basePath;
        this.fileName_ = fileName;
        this.properties_ = properties;
    }

    public static WikiData[] getWikiDatas(String basePath, CacheProperties properties, String orderType, String order, String text) {
        File[] dataFiles = WikiData.getWikiFiles(basePath, text);
        WikiData[] datas = new WikiData[dataFiles.length];
        int i = 0;
        while (i < dataFiles.length) {
            datas[i] = new WikiData(basePath, dataFiles[i].getName().substring(0, dataFiles[i].getName().length() - ".txt".length()), properties);
            ++i;
        }
        WikiComparator wikiComparator = orderType.equals("title") ? new TitleComparator(order) : (orderType.equals("subtitle") ? new SubTitleComparator(order) : new DateComparator(order));
        Arrays.sort(datas, wikiComparator);
        return datas;
    }

    private static File[] getWikiFiles(String basePath, String text) {
        File[] dataFiles = new WikiData(basePath, null, null).getContentsFileList();
        if (text == null || text.equals("")) {
            return dataFiles;
        }
        return WikiUtil.grep(dataFiles, text);
    }

    public String getTitle() {
        return this.fileName_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSubtitle() throws IOException {
        File file = this.getContentsFile();
        String subTitle = "";
        BufferedReader in = null;
        try {
            String firstLine;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.properties_.getProperty("save.encoding", "UTF-8")));
            if (in.ready() && (firstLine = in.readLine()).trim().length() > 0) {
                subTitle = " - " + firstLine;
            }
            Object var6_5 = null;
            if (in == null) return subTitle;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
        return subTitle;
    }

    public String getText() throws IOException {
        File file = this.getContentsFile();
        return this.getFileContents(file);
    }

    public String getDiffText() throws IOException {
        File file = this.getDiffFile();
        String text = null;
        try {
            text = this.getFileContents(file);
        }
        catch (FileNotFoundException ex) {
            text = "";
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getFileContents(File file) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        String text = "";
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.properties_.getProperty("save.encoding", "UTF-8")));
            StringBuffer buffer = new StringBuffer();
            String str = null;
            if (in.ready()) {
                buffer.append(in.readLine());
            }
            while ((str = in.readLine()) != null) {
                buffer.append("\n" + str);
            }
            text = buffer.toString();
            Object var7_6 = null;
            if (in == null) return text;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
        return text;
    }

    public void setText(String text) throws IOException, WikiException {
        this.setText(text, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setText(String text, boolean updateTime) throws IOException, WikiException {
        long lastModified;
        File file;
        block5: {
            this.diff(text);
            file = this.getContentsFile();
            if (!file.exists()) {
                file.createNewFile();
            }
            lastModified = file.lastModified();
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.properties_.getProperty("save.encoding", "UTF-8")));
                out.write(text);
                out.flush();
                Object var8_6 = null;
                if (out == null) break block5;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
            out.close();
        }
        if (!updateTime) {
            file.setLastModified(lastModified);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void diff(String text) throws IOException {
        String oldText = null;
        try {
            oldText = this.getText();
        }
        catch (FileNotFoundException ex) {
            oldText = "";
        }
        String diff = "";
        try {
            diff = MobWikiDiffPrint.diff(oldText, StringUtil.replace(text, "\r\n", "\n"));
        }
        catch (Exception e) {
            // empty catch block
        }
        BufferedWriter out = null;
        File file = this.getDiffFile();
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.properties_.getProperty("save.encoding", "UTF-8")));
            out.write(diff);
            out.flush();
            Object var7_8 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }

    private File getContentsFile() {
        return new File(this.getContentsPath());
    }

    private String getContentsPath() {
        String filePath = this.basePath_ + "WEB-INF/wiki/" + this.fileName_ + ".txt";
        Log.info((String)("TEST: filePath = " + filePath));
        Log.info((String)("TEST: encoding = " + WebUtil.getPageEncoding()));
        Log.info((String)"TEST: =====================================================================");
        return this.basePath_ + "WEB-INF/wiki/" + this.fileName_ + ".txt";
    }

    private File getDiffFile() {
        return new File(this.getDiffPath());
    }

    private String getDiffPath() {
        return this.basePath_ + "WEB-INF/wiki/diff/" + this.fileName_ + ".txt";
    }

    public String getLastModified() {
        return String.valueOf(this.getContentsFile().lastModified());
    }

    public Date getLastModifiedDate() {
        return new Date(this.getContentsFile().lastModified());
    }

    public String getLastModifiedAsString() {
        return new SimpleDateFormat("yyyy-MM-dd (EEE) HH:mm:ss", new Locale("en", "")).format(this.getLastModifiedDate());
    }

    public boolean isExists() {
        return this.getContentsFile().exists();
    }

    public File[] getContentsFileList() {
        return new File(this.basePath_ + "WEB-INF/wiki/").listFiles(filter_);
    }

    public void deleteFile() {
        this.getContentsFile().delete();
        this.getDiffFile().delete();
    }

    String getBase() {
        return this.basePath_;
    }

    static {
        filter_.addExtension("txt");
    }
}

