/*
 * Decompiled with CFR 0.152.
 */
package jp.mobster.webapp.wiki;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.mobster.util.CacheProperties;
import jp.mobster.util.StringUtil;
import jp.mobster.util.WebUtil;
import jp.mobster.webapp.wiki.MobWikiDiffPrint;
import jp.mobster.webapp.wiki.WikiData;
import jp.mobster.webapp.wiki.WikiException;
import jp.mobster.webapp.wiki.WikiUtil;
import jp.mobster.webapp.wiki.transform.WikiTransformer;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.resources.JetspeedResources;

public class Wiki {
    public static final String KEY_ADMIN_PASSWORD = "admin.password";
    public static final String KEY_FIXEDPAGE = "fixedpage";
    public static final String KEY_LOCKEDPAGE = "lockedpage";
    public static final String KEY_DEFAULT_STYLE = "default.style";
    public static final String DEFAULT_SYSTEM_ENCODING = System.getProperty("file.encoding");
    private HttpServletRequest request_;
    private HttpServletResponse response_;
    private String base_;
    private final String pageName_;
    private final CacheProperties properties_;
    private final WikiData pageData_;
    private String pageEncoding;

    public Wiki(String pageName) {
        this.base_ = "d:/project/wiki/";
        String configPath = this.base_ + "WEB-INF/conf/wiki-config.properties";
        this.properties_ = CacheProperties.getInstance(new File(configPath), "UTF-8");
        this.pageName_ = pageName;
        this.pageData_ = new WikiData(this.base_, this.getPageName(), this.properties_);
    }

    public Wiki(int dummy, String pageName) {
        this.base_ = "D:/eclipse-SDK-2.0.1-win32/eclipse/workspace/wiki/";
        String configPath = this.base_ + "WEB-INF/conf/wiki-config.properties";
        this.properties_ = CacheProperties.getInstance(new File(configPath), "UTF-8");
        this.pageName_ = pageName;
        this.pageData_ = new WikiData(this.base_, pageName, this.properties_);
    }

    public Wiki(HttpServletRequest request, HttpServletResponse response, ServletConfig config) throws WikiException {
        MediaTypeEntry media;
        this.request_ = request;
        this.response_ = response;
        this.base_ = config.getServletContext().getRealPath("/");
        if (!this.base_.substring(this.base_.length() - 1).equals(File.separator)) {
            this.base_ = this.base_ + File.separator;
        }
        String configPath = this.base_ + "WEB-INF/conf/wiki-config.properties";
        this.properties_ = CacheProperties.getInstance(new File(configPath), "UTF-8");
        this.pageEncoding = JetspeedResources.getString((String)"content.defaultencoding", (String)"US-ASCII");
        CapabilityMap cm = CapabilityMapFactory.getCapabilityMap((String)request.getHeader("User-Agent"));
        String mimeCode = cm.getPreferredType().getCode();
        if (mimeCode != null && (media = (MediaTypeEntry)Registry.getEntry((String)Registry.MEDIA_TYPE, (String)mimeCode)) != null && media.getCharacterSet() != null) {
            this.pageEncoding = media.getCharacterSet();
        }
        WebUtil.setPageEncoding(this.pageEncoding);
        this.pageName_ = this.getPageName();
        if (!WikiUtil.validWikiWordName(this.pageName_)) {
            throw new WikiException(this.properties_.getProperty("error.file.valid"));
        }
        this.pageData_ = new WikiData(this.base_, this.pageName_, this.properties_);
        if (this.getAction().equals("create") && this.pageData_.isExists()) {
            throw new WikiException(this.properties_.getProperty("error.file.exists"));
        }
    }

    public WikiData[] getWikiDatas(String orderType, String order, String text) {
        return WikiData.getWikiDatas(this.base_, this.properties_, orderType, order, text);
    }

    public String getPageName() {
        if (this.getParameter("wiki_action").equals("create")) {
            return this.getParameter("pid");
        }
        Object obj = this.request_.getAttribute("pid");
        if (obj != null && obj instanceof String) {
            return (String)obj;
        }
        return WebUtil.getParameter(this.request_, "pid", this.getFrontPage(), this.pageEncoding);
    }

    private String getFrontPage() {
        return this.properties_.getProperty("frontpage");
    }

    public void setText(String text) throws IOException, WikiException {
        if (this.isFixedPage(this.pageName_)) {
            return;
        }
        if (this.isLockedPage() && !this.getParameter("mypassword").equals(this.properties_.getProperty("password"))) {
            throw new WikiException(this.properties_.getProperty("error.password"));
        }
        if (!this.isUpdatable()) {
            throw new WikiException(this.properties_.getProperty("error.updated"));
        }
        if (this.isDeletable()) {
            this.pageData_.deleteFile();
        } else {
            boolean updateTime = Boolean.valueOf(this.getParameter("mytouch"));
            this.pageData_.setText(text, updateTime);
        }
    }

    public String replaceWiki(String str) throws IOException {
        File[] files = this.pageData_.getContentsFileList();
        WikiTransformer trans = new WikiTransformer(this.base_, str, files);
        String tmp = trans.transform();
        return tmp;
    }

    public boolean isFixedPage() {
        return this.isFixedPage(this.pageName_);
    }

    private boolean isFixedPage(String pageName) {
        String[] fixedPages = StringUtil.split(this.properties_.getProperty(KEY_FIXEDPAGE));
        int i = 0;
        while (i < fixedPages.length) {
            if (fixedPages[i].equals(pageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isLockedPage() {
        return this.isLockedPage(this.pageName_);
    }

    private boolean isLockedPage(String pageName) {
        String[] lockedPages = StringUtil.split(this.properties_.getProperty(KEY_LOCKEDPAGE));
        int i = 0;
        while (i < lockedPages.length) {
            if (lockedPages[i].equals(pageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getParameter(String paramName) {
        return WebUtil.getParameter(this.request_, paramName, this.pageEncoding);
    }

    public String getParameter(String paramName, String defaultStr) {
        return WebUtil.getParameter(this.request_, paramName, defaultStr, this.pageEncoding);
    }

    public String getContents() throws IOException {
        if (this.isEditable() || this.isDeletable()) {
            return "";
        }
        return this.getContentsByString(this.pageData_.getText());
    }

    public String getFormatContents() throws IOException {
        WikiData formatData = new WikiData(this.base_, "format", this.properties_);
        return this.getContentsByString(formatData.getText());
    }

    public String getContentsByString(String str) throws IOException {
        return this.replaceWiki(str);
    }

    public String getText() throws IOException {
        if (this.isEditable() || this.isDeletable()) {
            return this.getParameter("mymsg");
        }
        return this.pageData_.getText();
    }

    public String getDiffText() throws IOException {
        if (this.isEditable() || this.isDeletable()) {
            return this.getParameter("mymsg");
        }
        return MobWikiDiffPrint.diffHtml(this.getText(), this.pageData_.getDiffText());
    }

    public String getStylePath() throws IOException {
        String fileName = this.properties_.getProperty(KEY_DEFAULT_STYLE);
        return "css/" + fileName + ".css";
    }

    public String getSubtitle() throws IOException {
        if (this.isEditable() || this.isDeletable()) {
            return "";
        }
        return this.pageData_.getSubtitle();
    }

    public String getLastModified() {
        return this.pageData_.getLastModified();
    }

    public String getAction() {
        String action = this.getParameter("wiki_action");
        String action_preview = this.getParameter("action_preview");
        String action_save = this.getParameter("action_save");
        if (!action_preview.equals("")) {
            action = "preview";
        } else if (!action_save.equals("")) {
            action = "save";
        }
        return action;
    }

    public boolean isEditable() {
        return this.getAction().equals("create") || this.getAction().equals("new") || this.getAction().equals("preview");
    }

    public boolean isDeletable() throws IOException {
        return this.getAction().equals("save") && this.getParameter("mymsg").equals("");
    }

    public boolean isUpdatable() throws WikiException {
        String lastModified = this.getParameter("lastModified");
        String fileLastModified = String.valueOf(this.pageData_.getLastModified());
        return lastModified.equals(fileLastModified);
    }

    public String getProperty(String name) {
        return this.properties_.getProperty(name);
    }
}

