/*
 * Decompiled with CFR 0.152.
 */
package jp.mobster.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.mobster.util.StringUtil;
import org.apache.oro.text.perl.Perl5Util;

public class WebUtil {
    public static final String JIS_AUTO_DETECT = "JISAutoDetect";
    public static final String UTF_8 = "UTF-8";
    public static final String SHIFT_JIS = "Shift_JIS";
    public static final String MS932 = "MS932";
    public static final String MICROSOFT = "MS932";
    public static final String EUC_JP = "EUC-JP";
    public static final String SJIS = "SJIS";
    private static Perl5Util perl = new Perl5Util();
    private static String pageEncoding = "UTF-8";
    private static String currentURL = "";
    private static String currentPage = "";
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public static String addLinkTagURL(String src, String target) {
        return perl.substitute("s!([^=^\\\"]|^)(https?\\://[\\!-~]+)!$1<a href=\"$2\" target=\"" + target + "\">$2<\\/a>!g", src);
    }

    public static String addLinkTagURL(String src) {
        return perl.substitute("s!([^=^\\\"]|^)(https?\\://[\\!-~]+)!$1<a href=\"$2\">$2<\\/a>!g", src);
    }

    public static String addLinkTagFTP(String src, String target) {
        return perl.substitute("s!([^=^\\\"]|^)(ftp?\\://[\\!-~]+)!$1<a href=\"$2\" target=\"" + target + "\">$2<\\/a>!g", src);
    }

    public static String addLinkTagFTP(String src) {
        return perl.substitute("s!([^=^\\\"]|^)(ftp?\\://[\\!-~]+)!$1<a href=\"$2\">$2<\\/a>!g", src);
    }

    public static String addLinkTagMail(String src) {
        return perl.substitute("s!(mailto:)?([\\!-~]+\\@[\\!-~]+)!<a href=\"mailto:$2\">$1$2<\\/a>!g", src);
    }

    public static String addBrTag(String src) {
        Perl5Util perl = new Perl5Util();
        return perl.substitute("s!(.*)!$1<br>!g", src);
    }

    public static String escapeChar(String src) {
        String tmp = src;
        tmp = perl.substitute("s!&!&amp;!g", tmp);
        tmp = perl.substitute("s!<!&lt;!g", tmp);
        tmp = perl.substitute("s!>!&gt;!g", tmp);
        tmp = perl.substitute("s!\"!&quot;!g", tmp);
        return tmp;
    }

    public static String escapeSpace(String src) {
        String[] lines = StringUtil.split(src, "\n");
        int i = 0;
        while (i < lines.length) {
            int count = 0;
            int j = 0;
            while (j < lines[i].length()) {
                String s = lines[i].substring(j, j + 1);
                if (s.equals(" ")) {
                    ++count;
                } else if (s.equals("\t")) {
                    count += 4;
                } else {
                    lines[i] = StringUtil.repeat("&nbsp;", count) + lines[i].substring(j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return StringUtil.join(lines, "\n");
    }

    public static String addLinkTagAll(String src) {
        String tmp = src;
        tmp = WebUtil.addLinkTagURL(tmp);
        tmp = WebUtil.addLinkTagFTP(tmp);
        tmp = WebUtil.addLinkTagMail(tmp);
        tmp = WebUtil.addBrTag(tmp);
        return tmp;
    }

    public static String replaceNull(String str, String newStr) {
        if (str == null || str.equals("")) {
            return newStr;
        }
        return str;
    }

    public static String encodeURL(String str) {
        try {
            return URLEncoder.encode(str, pageEncoding);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static String decodeURL(String base64Str) {
        try {
            return URLDecoder.decode(base64Str, pageEncoding);
        }
        catch (UnsupportedEncodingException e) {
            return base64Str;
        }
    }

    private static String decode(String str, String enc) {
        try {
            return new String(str.getBytes("8859_1"), enc);
        }
        catch (Throwable ex) {
            return str;
        }
    }

    public static String getParameter(HttpServletRequest request, String paramName, String enc) {
        return WebUtil.getParameter(request, paramName, "", enc);
    }

    public static String getParameter(HttpServletRequest request, String paramName, String defaultStr, String enc) {
        String value = request.getParameter(paramName);
        if (value == null || value.equals("")) {
            return defaultStr;
        }
        return WebUtil.decode(value, enc);
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        int i = 0;
        while (i < cookies.length) {
            if (cookies[i].getName().equals(name)) {
                return cookies[i];
            }
            ++i;
        }
        return null;
    }

    public static void removeCookie(HttpServletResponse response, String name) {
        Cookie cookie = new Cookie(name, "");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestamp() {
        SimpleDateFormat simpleDateFormat = format;
        synchronized (simpleDateFormat) {
            return format.format(new Date());
        }
    }

    public static void setPageEncoding(String string) {
        pageEncoding = string;
    }

    public static String getPageEncoding() {
        return pageEncoding;
    }

    public static String getCurrentURL() {
        return currentURL;
    }

    public static void setCurrentURL(String string) {
        currentURL = string;
    }

    public static String getCurrentPage() {
        return currentPage;
    }

    public static void setCurrentPage(String string) {
        currentPage = string;
    }
}

