/*
 * Decompiled with CFR 0.152.
 */
package jp.mobster.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeUtil {
    public static final String SEP_COLON = ":";
    public static final String SEP_SPACE = " ";
    public static final String SEP_BAR = "-";
    public static final String SEP_SLASH = "/";
    public static final int HHMMSS_COLON = 0;
    public static final int HHMMSS_SLASH = 1;
    public static final int HHMMSS_BAR = 2;
    public static final int HHMMSS_SPACE = 3;
    public static final int HHMMSS = 0;
    public static final int YYYYMMDD_COLON = 10;
    public static final int YYYYMMDD_SLASH = 11;
    public static final int YYYYMMDD_BAR = 12;
    public static final int YYYYMMDD_SPACE = 13;
    public static final int YYYYMMDD = 11;
    public static final int YYYYMMDD_HHMMSS_COLON = 20;
    public static final int YYYYMMDD_HHMMSS_SLASH = 21;
    public static final int YYYYMMDD_HHMMSS_BAR = 22;
    public static final int YYYYMMDD_HHMMSS_SPACE = 23;
    public static final int YYYYMMDD_HHMMSS = 24;

    public static Timestamp getNowTimestamp() {
        Calendar cal = Calendar.getInstance();
        return new Timestamp(TimeUtil._getTimeInMillis(cal));
    }

    public static Calendar getNowCalendar() {
        return Calendar.getInstance();
    }

    public static Date getNowDate() {
        Calendar cal = Calendar.getInstance();
        return cal.getTime();
    }

    public static Time getNowTime() {
        Calendar cal = Calendar.getInstance();
        long lTime = TimeUtil._getTimeInMillis(cal);
        return new Time(lTime);
    }

    public static Date Timestamp2Date(Timestamp time) {
        long lTime = time.getTime();
        return new Date(lTime);
    }

    public static Time Timestamp2Time(Timestamp time) {
        long lTime = time.getTime();
        return new Time(lTime);
    }

    public static Calendar Timestamp2Calendar(Timestamp time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time.getTime()));
        return cal;
    }

    public static Timestamp Date2Timestamp(Date date) {
        long lTime = date.getTime();
        return new Timestamp(lTime);
    }

    public static Calendar Date2Calendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Time Date2Time(Date date) {
        long lTime = date.getTime();
        return new Time(lTime);
    }

    public static Timestamp Calendar2Timestamp(Calendar cal) {
        return new Timestamp(TimeUtil._getTimeInMillis(cal));
    }

    public static Date Calendar2Date(Calendar cal) {
        return cal.getTime();
    }

    public static Time Calendar2Time(Calendar cal) {
        return new Time(TimeUtil._getTimeInMillis(cal));
    }

    public static Timestamp Time2Timestamp(Time time) {
        return new Timestamp(time.getTime());
    }

    public static Date Time2Date(Time time) {
        return time;
    }

    public static Calendar Time2Calendar(Time time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return cal;
    }

    public static String getString(Time time, int type) {
        return TimeUtil.getString(TimeUtil.Time2Calendar(time), type);
    }

    public static String getString(Timestamp timestamp, int type) {
        return TimeUtil.getString(TimeUtil.Timestamp2Calendar(timestamp), type);
    }

    public static String getString(Date date, int type) {
        return TimeUtil.getString(TimeUtil.Date2Calendar(date), type);
    }

    public static String getString(Calendar cal, int type) {
        return TimeUtil.getStringFromType(type, cal.get(1), cal.get(2), cal.get(5), cal.get(11), cal.get(12), cal.get(13));
    }

    public static String getString(Calendar cal, String format) {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(TimeUtil.createTimeString(cal));
    }

    public static String getString(Date date, String format) {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(TimeUtil.createTimeString(TimeUtil.Date2Calendar(date)));
    }

    public static String getString(Time time, String format) {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(TimeUtil.createTimeString(TimeUtil.Time2Calendar(time)));
    }

    public static String getString(Timestamp stamp, String format) {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(TimeUtil.createTimeString(TimeUtil.Timestamp2Calendar(stamp)));
    }

    public static String getString(Calendar cal, String format, int nWeekType) {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(TimeUtil.createTimeString(cal, nWeekType));
    }

    public static String getString(Date date, String format, int nWeekType) {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(TimeUtil.createTimeString(TimeUtil.Date2Calendar(date), nWeekType));
    }

    public static String getString(Time time, String format, int nWeekType) {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(TimeUtil.createTimeString(TimeUtil.Time2Calendar(time), nWeekType));
    }

    public static String getString(Timestamp stamp, String format, int nWeekType) {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(TimeUtil.createTimeString(TimeUtil.Timestamp2Calendar(stamp), nWeekType));
    }

    private static final String[] createTimeString(Calendar cal) {
        return TimeUtil.createTimeString(cal, 1);
    }

    private static final String[] createTimeString(Calendar cal, int nWeekType) {
        String[] timeString = new String[]{String.valueOf(cal.get(1)), String.valueOf(cal.get(2)), String.valueOf(cal.get(5)), String.valueOf(cal.get(11)), String.valueOf(cal.get(12)), String.valueOf(cal.get(13)), TimeUtil.getWeekString(cal.get(7), nWeekType)};
        return timeString;
    }

    public static String getWeekString(int nWeek, int type) {
        String sWeek = new String();
        switch (nWeek) {
            case 1: {
                sWeek = type == 0 ? "SUNDAY" : (type == 1 ? "Sunday" : "Sun");
                break;
            }
            case 2: {
                sWeek = type == 0 ? "MONDAY" : (type == 1 ? "Monday" : "Mon");
                break;
            }
            case 3: {
                sWeek = type == 0 ? "TUESDAY" : (type == 1 ? "Tuesday" : "Tue");
                break;
            }
            case 4: {
                sWeek = type == 0 ? "WEDNSDAY" : (type == 1 ? "Wednsday" : "Wed");
                break;
            }
            case 5: {
                sWeek = type == 0 ? "THURSDAY" : (type == 1 ? "Thursday" : "Thu");
                break;
            }
            case 6: {
                sWeek = type == 0 ? "FRIDAY" : (type == 1 ? "Friday" : "Fri");
                break;
            }
            case 7: {
                sWeek = type == 0 ? "SATURDAY" : (type == 1 ? "Saturday" : "Sat");
            }
        }
        return sWeek;
    }

    public static int getDays(Calendar start, Calendar end) {
        Calendar startC = Calendar.getInstance();
        startC.set(start.get(1), start.get(2), start.get(5));
        Calendar endC = Calendar.getInstance();
        endC.set(end.get(1), end.get(2), end.get(5));
        long nTime = endC.getTime().getTime() - startC.getTime().getTime();
        return (int)(nTime / 86400000L) + 1;
    }

    private static final String getStringFromType(int nType, int year, int mon, int day, int h, int min, int sec) {
        StringBuffer dateString = new StringBuffer();
        int[] nYear = new int[3];
        int[] nDate = new int[3];
        switch (nType) {
            case 2: {
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(TimeUtil.getStringSep(nDate, SEP_BAR));
                break;
            }
            case 0: {
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(TimeUtil.getStringSep(nDate, SEP_COLON));
                break;
            }
            case 1: {
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(TimeUtil.getStringSep(nDate, SEP_SLASH));
                break;
            }
            case 3: {
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(TimeUtil.getStringSep(nDate, SEP_SPACE));
                break;
            }
            case 10: {
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(TimeUtil.getStringSep(nYear, SEP_COLON));
                break;
            }
            case 11: {
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(TimeUtil.getStringSep(nYear, SEP_SLASH));
                break;
            }
            case 13: {
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(TimeUtil.getStringSep(nYear, SEP_SPACE));
                break;
            }
            case 12: {
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(TimeUtil.getStringSep(nYear, SEP_BAR));
                break;
            }
            case 24: {
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(TimeUtil.getStringSep(nYear, SEP_SLASH));
                dateString.append(SEP_SPACE);
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(TimeUtil.getStringSep(nDate, SEP_COLON));
                break;
            }
            case 20: {
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(TimeUtil.getStringSep(nYear, SEP_COLON));
                dateString.append(SEP_SPACE);
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(TimeUtil.getStringSep(nDate, SEP_COLON));
                break;
            }
            case 22: {
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(TimeUtil.getStringSep(nYear, SEP_BAR));
                dateString.append(SEP_SPACE);
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(TimeUtil.getStringSep(nDate, SEP_BAR));
                break;
            }
            case 21: {
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(TimeUtil.getStringSep(nYear, SEP_SLASH));
                dateString.append(SEP_SPACE);
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(TimeUtil.getStringSep(nDate, SEP_SLASH));
                break;
            }
            case 23: {
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(TimeUtil.getStringSep(nYear, SEP_SPACE));
                dateString.append(SEP_SPACE);
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(TimeUtil.getStringSep(nDate, SEP_SPACE));
            }
        }
        return dateString.toString();
    }

    private static final String getStringSep(int[] value, String sep) {
        StringBuffer buf = new StringBuffer();
        int count = 0;
        while (count < value.length) {
            if (count != 0) {
                buf.append(sep);
            }
            buf.append(String.valueOf(value[count]));
            ++count;
        }
        return buf.toString();
    }

    private static long _getTimeInMillis(Calendar cal) {
        return cal.getTime().getTime();
    }
}

