/*
 * Decompiled with CFR 0.152.
 */
package jp.mobster.util;

import java.util.ArrayList;

public class StringUtil {
    private static final String DEFAULT_DELIM = ",";
    private static final String ALPHA = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static String join(String[] list) {
        return StringUtil.join(list, DEFAULT_DELIM);
    }

    public static String join(String[] str, String delim) {
        int length = str.length;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < length) {
            buf.append(str[i]);
            if (i != length - 1) {
                buf.append(delim);
            }
            ++i;
        }
        return new String(buf);
    }

    public static String repeat(String str, int repeat) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < repeat) {
            buf.append(str);
            ++i;
        }
        return buf.toString();
    }

    public static String repeat(char c, int repeat) {
        return StringUtil.repeat(String.valueOf(c), repeat);
    }

    public static String[] split(String str) {
        return StringUtil.split(str, DEFAULT_DELIM);
    }

    public static String[] split(String str, String delim) {
        int delimLength = delim.length();
        int pos = 0;
        int index = 0;
        ArrayList<String> list = new ArrayList<String>();
        while ((index = str.indexOf(delim, pos)) != -1) {
            list.add(str.substring(pos, index));
            pos = index + delimLength;
        }
        list.add(str.substring(pos));
        return list.toArray(new String[0]);
    }

    public static String replaceNull(String str) {
        return StringUtil.replaceNull(str, "");
    }

    public static String replaceNull(String str, String repStr) {
        return str == null ? StringUtil.replaceNull(repStr) : str;
    }

    public static String right(String str, int n) {
        return str.substring(str.length() - n);
    }

    public static String left(String str, int n) {
        return str.substring(0, n);
    }

    public static String insert(String str, int offset, String insertStr) {
        StringBuffer buffer = new StringBuffer(str);
        buffer.insert(offset, insertStr);
        return buffer.toString();
    }

    public static String trimZero(String str) {
        return StringUtil.trim(str, '0');
    }

    public static String trim(String str, char c) {
        int startIndex = 0;
        while (str.charAt(startIndex) == c) {
            ++startIndex;
        }
        int lastIndex = str.length() - 1;
        while (str.charAt(lastIndex) == c) {
            --lastIndex;
        }
        return str.substring(startIndex, lastIndex + 1);
    }

    public static String replace(String str, String oldStr, String newStr) {
        return StringUtil.replace(str, oldStr, newStr, 0, str.length());
    }

    public static String replace(String str, String oldStr, String newStr, int startOffset, int endOffset) {
        int pos;
        String subStr = str.substring(0, endOffset);
        StringBuffer buffer = new StringBuffer(str.substring(0, startOffset));
        int oldPos = pos = startOffset;
        while (oldPos <= endOffset && (pos = subStr.indexOf(oldStr, oldPos)) != -1) {
            buffer.append(subStr.substring(oldPos, pos));
            buffer.append(newStr);
            oldPos = pos + oldStr.length();
        }
        buffer.append(str.substring(oldPos));
        return buffer.toString();
    }

    public static boolean containsChar(String str1, String str2) {
        int i = 0;
        while (i < str2.length()) {
            if (str1.indexOf(str2.charAt(i)) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsChar(String str, char[] c) {
        int i = 0;
        while (i < c.length) {
            if (str.indexOf(c[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isAlpha(String str) {
        int i = 0;
        while (i < str.length()) {
            if (ALPHA.indexOf(str.charAt(i)) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String fillChar(String str, int length, char c) {
        int count = length - str.length();
        if (count > 0) {
            return str + StringUtil.repeat(c, count);
        }
        return str;
    }

    public static String fillSpace(String str, int length) {
        return StringUtil.fillChar(str, length, ' ');
    }
}

