/*
 * Decompiled with CFR 0.152.
 */
package jp.mobster.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CacheProperties {
    private static final String DEFAULT_FILE_ENCODING = System.getProperty("file.encoding");
    private static Map cache_ = new HashMap();
    private static final String NULL_STRING = "";
    private Map entry_ = new HashMap();
    private long lastModified_;
    private File file_;
    private String charset_;

    private CacheProperties(File file, String charset) {
        this.file_ = file;
        this.charset_ = charset;
    }

    public static CacheProperties getInstance(String fileName) {
        return CacheProperties.getInstance(fileName, DEFAULT_FILE_ENCODING);
    }

    public static CacheProperties getInstance(String fileName, String charset) {
        return CacheProperties.getInstance(fileName, charset, ClassLoader.getSystemClassLoader());
    }

    public static CacheProperties getInstance(String fileName, ClassLoader loader) {
        return CacheProperties.getInstance(fileName, DEFAULT_FILE_ENCODING, loader);
    }

    public static CacheProperties getInstance(String fileName, String charset, ClassLoader loader) {
        String path = ClassLoader.getSystemResource(fileName).getPath();
        return CacheProperties.getInstance(new File(path), charset);
    }

    public static CacheProperties getInstance(File file) {
        return CacheProperties.getInstance(file, DEFAULT_FILE_ENCODING);
    }

    public static synchronized CacheProperties getInstance(File file, String charset) {
        CacheProperties properties = (CacheProperties)cache_.get(file.getAbsolutePath());
        if (properties == null) {
            properties = new CacheProperties(file, charset);
            properties.load();
            cache_.put(file.getAbsolutePath(), properties);
        } else if (properties.isUpdate()) {
            properties.load();
        }
        return properties;
    }

    private void load() {
        this.clear();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file_), this.charset_));
            String str = null;
            while ((str = reader.readLine()) != null) {
                int pos;
                if (str.indexOf(35) == 0 || (pos = str.indexOf(61)) == -1) continue;
                String key = str.substring(0, pos);
                String value = str.substring(pos + 1);
                this.setProperty(key, value);
            }
            reader.close();
            this.lastModified_ = this.file_.lastModified();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("CacheProperties file load error : " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("CacheProperties file load error : " + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("CacheProperties file load error : " + e.getMessage());
        }
    }

    public synchronized void setProperty(String key, String value) {
        ArrayList<String> list = (ArrayList<String>)this.entry_.get(key);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(value);
        this.entry_.put(key, list);
    }

    public synchronized String getProperty(String key) {
        return this.getProperty(key, NULL_STRING);
    }

    public synchronized String getProperty(String key, String defaultValue) {
        if (this.isUpdate()) {
            this.load();
        }
        String value = null;
        List list = (List)this.entry_.get(key);
        if (list != null) {
            value = (String)list.get(0);
        }
        return value != null ? value : defaultValue;
    }

    public synchronized String[] getPropertyArray(String key) {
        List list = (List)this.entry_.get(key);
        if (list == null) {
            return new String[0];
        }
        return list.toArray(new String[0]);
    }

    public boolean getPropertyAsBoolean(String key) {
        return this.getPropertyAsBoolean(key, false);
    }

    public boolean getPropertyAsBoolean(String key, boolean defaultValue) {
        String value = this.getProperty(key);
        boolean result = Boolean.valueOf(value);
        return result ? result : defaultValue;
    }

    public int getPropertyAsInt(String key) {
        return this.getPropertyAsInt(key, 0);
    }

    public int getPropertyAsInt(String key, int defaultValue) throws NumberFormatException {
        String value = this.getProperty(key);
        return value.equals(NULL_STRING) ? defaultValue : Integer.parseInt(value);
    }

    public synchronized void clear() {
        this.entry_.clear();
    }

    private synchronized boolean isUpdate() {
        return this.lastModified_ != this.file_.lastModified();
    }

    public synchronized long getLastModified() {
        return this.lastModified_;
    }

    private synchronized void setLastModified(long lastModified) {
        this.lastModified_ = lastModified;
    }

    public File getFile() {
        return this.file_;
    }

    public String getCharset() {
        return this.charset_;
    }

    public Set keySet() {
        return this.entry_.keySet();
    }
}

