/*
 * Decompiled with CFR 0.152.
 */
package com.marevol.portlet.wiki.services;

import java.io.File;
import jp.mobster.util.CacheProperties;
import jp.mobster.util.StringUtil;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.upload.FileItem;

public class WikiUploadService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)(class$com$marevol$portlet$wiki$services$WikiUploadService == null ? (class$com$marevol$portlet$wiki$services$WikiUploadService = WikiUploadService.class$("com.marevol.portlet.wiki.services.WikiUploadService")) : class$com$marevol$portlet$wiki$services$WikiUploadService).getName());
    private static final String GIF = ".GIF";
    private static final String JPEG = ".JPEG";
    private static final String JPG = ".JPG";
    private static CacheProperties properties_ = null;
    private static String UPLOAD_DIR;
    private static String[] extentions;
    private static boolean isInit;
    static /* synthetic */ Class class$com$marevol$portlet$wiki$services$WikiUploadService;

    public static void init(RunData rundata) {
        String baseDir = rundata.getServletConfig().getServletContext().getRealPath("/");
        if (!baseDir.substring(baseDir.length() - 1).equals(File.separator)) {
            baseDir = baseDir + File.separator;
        }
        String configPath = baseDir + "WEB-INF/conf/wiki-config.properties";
        properties_ = CacheProperties.getInstance(new File(configPath), "UTF-8");
        UPLOAD_DIR = baseDir + "upload/";
        extentions = StringUtil.split(properties_.getProperty("upload_extentions"));
        int i = 0;
        while (i < extentions.length) {
            WikiUploadService.extentions[i] = "." + extentions[i].toUpperCase();
            ++i;
        }
        isInit = true;
    }

    public static boolean isInit() {
        return isInit;
    }

    public static void store(RunData rundata) {
        try {
            FileItem file;
            if (!properties_.getPropertyAsBoolean("upload")) {
                WikiUploadService.printErrorPage(rundata);
                return;
            }
            ParameterParser params = rundata.getParameters();
            if (!properties_.getPropertyAsBoolean("user.upload.file")) {
                String myPassword = params.getString("mypassword", "");
                String password = properties_.getProperty("password");
                if (!password.equals(myPassword)) {
                    WikiUploadService.printErrorPage(rundata);
                    return;
                }
            }
            if (WikiUploadService.isExtention(WikiUploadService.getFileName((file = params.getFileItem("file")).getName()))) {
                WikiUploadService.saveFile(file);
                WikiUploadService.printSuccessPage(rundata, WikiUploadService.getFileName(file.getName()));
                return;
            }
        }
        catch (NullPointerException npe) {
        }
        catch (IllegalArgumentException iae) {
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        WikiUploadService.printErrorPage(rundata);
    }

    private static void saveFile(FileItem item) throws IllegalArgumentException, IllegalStateException {
        String fileName = WikiUploadService.getFileName(item.getName());
        if (new File(UPLOAD_DIR + item.getName()).exists()) {
            throw new IllegalArgumentException("\u65e2\u306b\u305d\u306e\u30d5\u30a1\u30a4\u30eb\u306e\u30d5\u30a1\u30a4\u30eb\u306f\u5b58\u5728\u3057\u307e\u3059\u3002");
        }
        try {
            item.write(UPLOAD_DIR + fileName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private static String getFileName(String path) {
        int index = StringUtil.replace(path, "/", "\\").lastIndexOf("\\");
        return path.substring(index + 1);
    }

    private static void printSuccessPage(RunData rundata, String fileName) {
        rundata.getRequest().setAttribute("pid", (Object)new String("SaveSuccess"));
        rundata.getRequest().setAttribute("img", (Object)fileName);
    }

    private static void printErrorPage(RunData rundata) {
        rundata.getRequest().setAttribute("pid", (Object)new String("SaveError"));
    }

    private static boolean isExtention(String fileName) {
        String targetFile = fileName.toUpperCase();
        int i = 0;
        while (i < extentions.length) {
            if (targetFile.lastIndexOf(extentions[i]) + extentions[i].length() == targetFile.length()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        isInit = false;
    }
}

