CREATE or REPLACE FUNCTION getPermissionId(p_name in varchar2)
  return integer
  is
    l_id integer;
begin
  select PERMISSION_ID into l_id from TURBINE_PERMISSION where PERMISSION_NAME = p_name;
  return (l_id);
end;
/
CREATE or REPLACE FUNCTION getRoleId(p_name in varchar2)
  return integer
  is
    l_id integer;
begin
  select ROLE_ID into l_id from TURBINE_ROLE where ROLE_NAME = p_name;
  return (l_id);
end;
/
CREATE or REPLACE FUNCTION getGroupId(p_name in varchar2)
  return integer
  is
    l_id integer;
begin
  select GROUP_ID into l_id from TURBINE_GROUP where GROUP_NAME = p_name;
  return (l_id);
end;
/
CREATE or REPLACE FUNCTION getUserId(p_name in varchar2)
  return integer
  is
    l_id integer;
begin
  select USER_ID into l_id from TURBINE_USER where LOGIN_NAME = p_name;
  return (l_id);
end;
/

INSERT INTO TURBINE_PERMISSION VALUES(turbine_permission_seq.nextval,'view',NULL);
INSERT INTO TURBINE_PERMISSION VALUES(turbine_permission_seq.nextval,'customize',NULL);
INSERT INTO TURBINE_PERMISSION VALUES(turbine_permission_seq.nextval,'maximize',NULL);
INSERT INTO TURBINE_PERMISSION VALUES(turbine_permission_seq.nextval,'minimize',NULL);
INSERT INTO TURBINE_PERMISSION VALUES(turbine_permission_seq.nextval,'personalize',NULL);
INSERT INTO TURBINE_PERMISSION VALUES(turbine_permission_seq.nextval,'info',NULL);
INSERT INTO TURBINE_PERMISSION VALUES(turbine_permission_seq.nextval,'close',NULL);
INSERT INTO TURBINE_PERMISSION VALUES(turbine_permission_seq.nextval,'detach',NULL);
INSERT INTO TURBINE_ROLE VALUES(turbine_role_seq.nextval,'user',NULL);
INSERT INTO TURBINE_ROLE VALUES(turbine_role_seq.nextval,'admin',NULL);
INSERT INTO TURBINE_ROLE VALUES(turbine_role_seq.nextval,'guest',NULL);
INSERT INTO TURBINE_GROUP VALUES(turbine_group_seq.nextval,'Jetspeed',NULL);
INSERT INTO TURBINE_GROUP VALUES(turbine_group_seq.nextval,'apache',NULL);
INSERT INTO TURBINE_USER VALUES(turbine_user_seq.nextval,'admin','jetspeed','Jetspeed','Admin','admin@jakarta-jetspeed.com','CONFIRMED',NULL,NULL,SYSDATE,'F',NULL, NULL);
INSERT INTO TURBINE_USER VALUES(turbine_user_seq.nextval,'turbine','turbine','Tommy','Turbine','tommy@jakarta-jetspeed.com','CONFIRMED',NULL,NULL,SYSDATE,'F',NULL, NULL);
INSERT INTO TURBINE_USER VALUES(turbine_user_seq.nextval,'anon','anon','Anonymous','User','anon@jakarta-jetspeed.com','CONFIRMED',NULL,NULL,SYSDATE,'F',NULL, NULL);
INSERT INTO TURBINE_ROLE_PERMISSION VALUES(getRoleId('user'),getPermissionId('view'));
INSERT INTO TURBINE_ROLE_PERMISSION VALUES(getRoleId('user'),getPermissionId('customize'));
INSERT INTO TURBINE_ROLE_PERMISSION VALUES(getRoleId('user'),getPermissionId('maximize'));
INSERT INTO TURBINE_ROLE_PERMISSION VALUES(getRoleId('user'),getPermissionId('minimize'));
INSERT INTO TURBINE_ROLE_PERMISSION VALUES(getRoleId('user'),getPermissionId('personalize'));
INSERT INTO TURBINE_ROLE_PERMISSION VALUES(getRoleId('user'),getPermissionId('info'));
INSERT INTO TURBINE_ROLE_PERMISSION VALUES(getRoleId('admin'),getPermissionId('view'));
INSERT INTO TURBINE_ROLE_PERMISSION VALUES(getRoleId('admin'),getPermissionId('customize'));
INSERT INTO TURBINE_ROLE_PERMISSION VALUES(getRoleId('admin'),getPermissionId('maximize'));
INSERT INTO TURBINE_ROLE_PERMISSION VALUES(getRoleId('admin'),getPermissionId('minimize'));
INSERT INTO TURBINE_ROLE_PERMISSION VALUES(getRoleId('admin'),getPermissionId('personalize'));
INSERT INTO TURBINE_ROLE_PERMISSION VALUES(getRoleId('admin'),getPermissionId('info'));
INSERT INTO TURBINE_ROLE_PERMISSION VALUES(getRoleId('admin'),getPermissionId('close'));
INSERT INTO TURBINE_ROLE_PERMISSION VALUES(getRoleId('guest'),getPermissionId('view'));
INSERT INTO TURBINE_ROLE_PERMISSION VALUES(getRoleId('guest'),getPermissionId('info'));
INSERT INTO TURBINE_USER_GROUP_ROLE VALUES(getUserId('turbine'),getGroupId('Jetspeed'),getRoleId('user'));
INSERT INTO TURBINE_USER_GROUP_ROLE VALUES(getUserId('admin'),getGroupId('Jetspeed'),getRoleId('user'));
INSERT INTO TURBINE_USER_GROUP_ROLE VALUES(getUserId('admin'),getGroupId('Jetspeed'),getRoleId('admin'));
INSERT INTO TURBINE_USER_GROUP_ROLE VALUES(getUserId('anon'),getGroupId('Jetspeed'),getRoleId('guest'));
INSERT INTO COFFEES VALUES('ColombianGrade',5,7.99,1,2);
INSERT INTO COFFEES VALUES('KonaGrade',6,7.99,1,2);
INSERT INTO COFFEES VALUES('FrenchRoastGrade',7,7.99,1,2);
INSERT INTO COFFEES VALUES('HazelNutGrade',8,7.99,1,2);
INSERT INTO COFFEES VALUES('VanillaGrade',9,7.99,1,2);
INSERT INTO COFFEES VALUES('JavaGrade',10,7.99,1,2);
INSERT INTO COFFEES VALUES('IndonesianGrade',11,7.99,1,2);
INSERT INTO COFFEES VALUES('OotyGrade',1,7.99,1,2);
INSERT INTO COFFEES VALUES('KenyanGrade',2,7.99,1,2);
INSERT INTO COFFEES VALUES('JoeGrade',3,7.99,1,2);
INSERT INTO COFFEES VALUES('CantThinkOfAnymoreGrade',4,7.99,1,2);

